/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.design.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.util.ObjectUtil;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.common.business.configfile.ConfigFileChangeEvent;
import de.justsoftware.onx.common.business.configfile.ConfigService;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.design.business.ThemeReadDataService;
import de.justsoftware.onx.design.business.ThemeService;
import de.justsoftware.onx.design.business.ThemeUpdateSource;
import de.justsoftware.onx.design.business.ThemeWriteDataService;
import de.justsoftware.onx.design.persistence.model.DBTheme;
import de.justsoftware.onx.design.persistence.model.DBThemeAttribute;
import de.justsoftware.onx.design.shared.DefaultThemeAttributeValueFactory;
import de.justsoftware.onx.design.shared.SameAttributePredicate;
import de.justsoftware.onx.design.shared.model.ITheme;
import de.justsoftware.onx.design.shared.model.IThemeAttribute;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeAttribute;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.design.shared.model.ThemeId;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class ThemeServiceImpl
extends ThemeUpdateSource
implements ServerEventHandler,
ThemeService {
    private final ThemeReadDataService _themeReadDataService;
    private final ThemeWriteDataService _themeWriteDataService;
    private final ConfigService _configService;
    private ImmutableSet<ThemeAttributeType> _editableThemeAttributes = null;
    private final Function<Theme, Theme> _removeNotEditableAttributesFunction = new NullPermeableFunction<Theme, Theme>(){

        @Override
        protected Theme applySafe(Theme origin) {
            ImmutableSet editableAttributes = FluentIterable.from(origin.getThemeAttributes()).filter((Predicate)new NullIsFalsePredicate<ThemeAttribute>(){

                @Override
                protected boolean applySafe(ThemeAttribute input) {
                    return ThemeServiceImpl.this.getEditableAttributes().contains((Object)input.getAttributeType());
                }
            }).toSet();
            return Theme.copyWithNewAttributes(origin, (ImmutableSet<ThemeAttribute>)editableAttributes);
        }
    };
    private final Function<Theme, Theme> _removeNonEntityThemeAttributesFunction = new NullPermeableFunction<Theme, Theme>(){

        @Override
        protected Theme applySafe(Theme origin) {
            ImmutableSet entityThemeAttributes = FluentIterable.from(origin.getThemeAttributes()).filter((Predicate)new NullIsFalsePredicate<ThemeAttribute>(){

                @Override
                protected boolean applySafe(ThemeAttribute input) {
                    return input.getAttributeType().getScope() == ThemeAttributeType.Scope.ENTITY_THEME;
                }
            }).toSet();
            return Theme.copyWithNewAttributes(origin, (ImmutableSet<ThemeAttribute>)entityThemeAttributes);
        }
    };
    private final Function<Theme, Theme> _applyFactoryDefaultsToThemeFunction = Functions.compose((Function)new NullPermeableFunction<Theme, Theme>(){

        @Override
        protected Theme applySafe(Theme theme) {
            ImmutableSet currentAttributeTypes = FluentIterable.from(theme.getThemeAttributes()).transform(ThemeAttribute::getAttributeType).toSet();
            ImmutableSet.Builder newAttributesBuilder = ImmutableSet.builder();
            for (ThemeAttributeType type : ThemeAttributeType.values()) {
                if (currentAttributeTypes.contains((Object)type)) continue;
                newAttributesBuilder.add((Object)new ThemeAttribute(theme.getId(), (String)type.accept(DefaultThemeAttributeValueFactory.INSTANCE).orNull(), type));
            }
            ImmutableSet newAttributes = newAttributesBuilder.build();
            if (!newAttributes.isEmpty()) {
                Sets.SetView newSet = Sets.union((Set)newAttributes, theme.getThemeAttributes());
                return Theme.copyWithNewAttributes(theme, (ImmutableSet<ThemeAttribute>)ImmutableSet.copyOf((Collection)newSet));
            }
            return theme;
        }
    }, this._removeNotEditableAttributesFunction);
    private final Function<Theme, Theme> _addAttributesFromDefaultTheme = Functions.compose((Function)Functions.compose((Function)new NullPermeableFunction<Theme, Theme>(){

        @Override
        protected Theme applySafe(Theme theme) {
            Theme defaultTheme = ThemeServiceImpl.this.getDefaultTheme();
            ImmutableSet currentAttributeTypes = FluentIterable.from(theme.getThemeAttributes()).transform(ThemeAttribute::getAttributeType).toSet();
            ImmutableSet.Builder newAttributesBuilder = ImmutableSet.builder();
            for (ThemeAttributeType type : ThemeAttributeType.values()) {
                if (currentAttributeTypes.contains((Object)type)) continue;
                ThemeAttribute defaultAttribute = defaultTheme.getAttribute(type);
                newAttributesBuilder.add((Object)new ThemeAttribute(theme.getId(), defaultAttribute != null ? defaultAttribute.getValue() : null, type));
            }
            ImmutableSet newAttributes = newAttributesBuilder.build();
            if (!newAttributes.isEmpty()) {
                Sets.SetView newSet = Sets.union((Set)newAttributes, theme.getThemeAttributes());
                return Theme.copyWithNewAttributes(theme, (ImmutableSet<ThemeAttribute>)ImmutableSet.copyOf((Collection)newSet));
            }
            return theme;
        }
    }, this._removeNotEditableAttributesFunction), this._removeNonEntityThemeAttributesFunction);

    @Autowired
    @ParametersAreNonnullByDefault
    public ThemeServiceImpl(ThemeReadDataService themeReadDataService, ThemeWriteDataService themeWriteDataService, ConfigService configService, Settings settings) {
        this._themeReadDataService = themeReadDataService;
        this._themeWriteDataService = themeWriteDataService;
        this._configService = configService;
    }

    @Nonnull
    private ImmutableSet<ThemeAttributeType> getEditableAttributes() {
        if (this._editableThemeAttributes == null) {
            this._editableThemeAttributes = this._configService.getEditableThemeAttributes();
        }
        return this._editableThemeAttributes;
    }

    @Nonnull
    private Theme cleanUpTheme(@Nonnull ITheme theme) {
        Theme cleanTheme = (Theme)this._removeNotEditableAttributesFunction.apply((Object)Theme.copyOf(theme));
        if (theme.isDefaultTheme()) {
            return cleanTheme;
        }
        return (Theme)this._removeNonEntityThemeAttributesFunction.apply((Object)cleanTheme);
    }

    @Override
    public Theme getDefaultTheme() {
        Theme defaultTheme = this._themeReadDataService.getDefaultTheme();
        if (defaultTheme != null) {
            return this.enrichWithDefaults(defaultTheme);
        }
        ThemeId newDefault = this._themeWriteDataService.createTheme("default");
        this._themeWriteDataService.setDefaultTheme(newDefault);
        return this.getByIdNonnull(newDefault);
    }

    @Nonnull
    private Theme getByIdNonnull(@Nonnull ThemeId themeId) {
        Theme theme = this.getByIdUnauthorized(themeId);
        if (theme == null) {
            throw new IllegalArgumentException("no theme with id " + themeId);
        }
        return theme;
    }

    @Override
    public Theme getById(ThemeId themeId, AuthorizationCheckContext authorizationContext) {
        return this.getByIdUnauthorized(themeId);
    }

    @Override
    public Theme getByIdUnauthorized(@Nonnull ThemeId themeId) {
        Theme theme = this._themeReadDataService.getById(themeId);
        return theme != null ? this.enrichWithDefaults(theme) : null;
    }

    @Override
    public Theme updateDefaultTheme(ITheme theme, AuthorizationCheckContext authCtx) {
        authCtx.check(StaticAction.ADMIN_MODIFY_DEFAULT_DESIGN);
        this._themeWriteDataService.updateTheme(DBTheme.copyOf(this.cleanUpTheme(theme)));
        ThemeId id = ObjectUtil.checkNotNull(theme.getId());
        this.onThemeUpdated(id, theme.isDefaultTheme());
        return this.getByIdNonnull(id);
    }

    @Override
    public void setDefaultThemeAttribute(ThemeAttribute attribute, AuthorizationCheckContext authCtx) {
        authCtx.check(StaticAction.ADMIN_MODIFY_DEFAULT_DESIGN);
        ThemeId themeId = attribute.getThemeId();
        if (themeId == null) {
            throw new PermissionDeniedException();
        }
        Theme theme = this.getByIdNonnull(themeId);
        if (!theme.isDefaultTheme()) {
            throw new PermissionDeniedException();
        }
        this.updateThemeAttributeInternal(theme, attribute);
    }

    private void updateThemeAttributeInternal(@Nonnull Theme theme, @Nonnull IThemeAttribute attribute) {
        DBTheme dbTheme = DBTheme.copyOf(theme);
        Iterable<DBThemeAttribute> currentAttributes = dbTheme.getThemeAttributes();
        FluentIterable otherAttributes = FluentIterable.from(currentAttributes).filter(Predicates.not((Predicate)new SameAttributePredicate(attribute)));
        dbTheme.setThemeElements((Iterable<DBThemeAttribute>)ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)otherAttributes, (Iterable)ImmutableList.of((Object)((DBThemeAttribute)DBThemeAttribute.FROM_ITHEME_ELEMENT.apply((Object)attribute))))));
        this._themeWriteDataService.updateTheme(dbTheme);
        this.onThemeUpdated(theme.getId(), theme.isDefaultTheme());
    }

    @Subscribe
    public void onConfigurationChanged(@Nonnull ConfigFileChangeEvent e) {
        this.refreshEditableAttributes();
    }

    private void refreshEditableAttributes() {
        Theme beforeUpdate = this.getDefaultTheme();
        this._editableThemeAttributes = this._configService.getEditableThemeAttributes();
        Theme afterUpdate = this.getDefaultTheme();
        if (!beforeUpdate.equals(afterUpdate)) {
            this.onThemeUpdated(this.getDefaultTheme().getId(), true);
        }
    }

    @Nonnull
    private Theme enrichWithDefaults(@Nonnull Theme theme) {
        if (theme.isDefaultTheme()) {
            return (Theme)this._applyFactoryDefaultsToThemeFunction.apply((Object)theme);
        }
        return (Theme)this._addAttributesFromDefaultTheme.apply((Object)theme);
    }

    @Override
    public Theme getFactoryDefaultTheme() {
        return this.enrichWithDefaults(Theme.copyWithNewAttributes(this.getDefaultTheme(), (ImmutableSet<ThemeAttribute>)ImmutableSet.of()));
    }
}

