/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.datasource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ParametersAreNonnullByDefault
public class DataSourceConfiguration {
    @Bean(name={"dataSource"}, destroyMethod="close")
    @Nonnull
    static DataSource dataSource(@Value(value="${JDBC.ConnectionURL}") String connectionURL, @Value(value="${JDBC.Driver}") String driverClassName, @Value(value="${JDBC.Username}") String username, @Value(value="${JDBC.Password}") String password, @Value(value="${hikariCP.maximumPoolSize:20}") int maximumPoolSize, @Value(value="${hikariCP.minimumIdle:5}") int minimumIdle, @Value(value="${hikariCP.connectionTimeout:30000}") long connectionTimeout, @Value(value="${hikariCP.idleTimeout:600000}") long idleTimeout, @Value(value="${hikariCP.maxLifetime:1800000}") long maxLifetime) {
        HikariConfig config = new HikariConfig();
        config.setPoolName("defaultHikariCP");
        config.setJdbcUrl(connectionURL);
        config.setUsername(username);
        config.setPassword(password);
        config.setDriverClassName(driverClassName);
        config.setInitializationFailTimeout(-1L);
        config.setMaximumPoolSize(maximumPoolSize);
        config.setMinimumIdle(minimumIdle);
        config.setConnectionTimeout(connectionTimeout);
        config.setIdleTimeout(idleTimeout);
        config.setMaxLifetime(maxLifetime);
        return new HikariDataSource(config);
    }
}

