/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.datasource;

import de.justsoftware.toolbox.mybatis.SupportedJdbcDriver;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.support.DatabaseStartupValidator;

@Configuration
@ParametersAreNonnullByDefault
public class AwaitDatabaseConnectionConfiguration {
    @Nonnull
    @Bean
    public DatabaseStartupValidator databaseStartupValidator(DataSource dataSource, @Value(value="${JDBC.ConnectionURL}") String jdbcUrl, @Value(value="${just.database.awaitTimeoutInS:60}") int timeoutInS, @Value(value="${just.database.awaitIntervalInS:1}") int intervalInS) {
        DatabaseStartupValidator dsv = new DatabaseStartupValidator();
        dsv.setDataSource(dataSource);
        dsv.setTimeout(timeoutInS);
        dsv.setInterval(intervalInS);
        SupportedJdbcDriver driver = SupportedJdbcDriver.driverFromUrl((String)jdbcUrl);
        String validationQuery = SupportedJdbcDriver.ORACLE == driver ? "SELECT 'Hello' from DUAL" : "SELECT 1";
        dsv.setValidationQuery(validationQuery);
        return dsv;
    }

    @Nonnull
    @Bean
    public BeanFactoryPostProcessor rewireBeanDependencies() {
        return beanFactory -> {
            String[] liquibaseIntegration = beanFactory.getBeanNamesForType(SpringLiquibase.class);
            Stream.of(liquibaseIntegration).map(arg_0 -> ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(arg_0)).forEach(it -> it.setDependsOn(new String[]{"databaseStartupValidator"}));
        };
    }
}

