/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model.db;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DBEntityLinkedEntityPrivacy
implements Serializable {
    public static final Function<DBEntityLinkedEntityPrivacy, EntityType> GET_ENTITY_TYPE = new NullPermeableFunction<DBEntityLinkedEntityPrivacy, EntityType>(){

        @Override
        protected EntityType applySafe(DBEntityLinkedEntityPrivacy input) {
            return input.getEntityType();
        }
    };
    public static final Function<DBEntityLinkedEntityPrivacy, List<AuthorityModel>> GET_AVAILABLE_AUTHORITIES = new NullPermeableFunction<DBEntityLinkedEntityPrivacy, List<AuthorityModel>>(){

        @Override
        protected List<AuthorityModel> applySafe(DBEntityLinkedEntityPrivacy input) {
            return input.getAvailableAuthories();
        }
    };
    private static final long serialVersionUID = -630768306488112788L;
    private EntityId _entityId;
    private EntityType _entityType;
    private List<String> _selectedAuthorityNames;
    private List<AuthorityModel> _availableAuthorityNames;

    public DBEntityLinkedEntityPrivacy() {
    }

    public DBEntityLinkedEntityPrivacy(EntityId entityId, EntityType entityType, ImmutableSet<String> selectedAuthorityNames) {
        this._entityId = entityId;
        this._entityType = entityType;
        this._selectedAuthorityNames = Lists.newArrayList(selectedAuthorityNames);
    }

    public EntityId getEntityId() {
        return this._entityId;
    }

    public void setEntityId(EntityId entityId) {
        this._entityId = entityId;
    }

    public EntityType getEntityType() {
        return this._entityType;
    }

    public void setEntityType(EntityType entityType) {
        this._entityType = entityType;
    }

    public ImmutableSet<String> getSelectedAuthorityNames() {
        return this._selectedAuthorityNames != null ? ImmutableSet.copyOf(this._selectedAuthorityNames) : ImmutableSet.of();
    }

    @Deprecated
    @Nonnull
    public List<String> getSelectedAuthorityNamesIbatis() {
        return this._selectedAuthorityNames;
    }

    @Deprecated
    public void setSelectedAuthorityNamesIbatis(@Nullable List<String> selectedAuthorityNames) {
        this.setSelectedAuthorityNames((ImmutableSet<String>)(selectedAuthorityNames != null ? ImmutableSet.copyOf(selectedAuthorityNames) : ImmutableSet.of()));
    }

    public void setSelectedAuthorityNames(@Nonnull ImmutableSet<String> selectedAuthorityNames) {
        this._selectedAuthorityNames = Lists.newArrayList(selectedAuthorityNames);
    }

    public List<AuthorityModel> getAvailableAuthories() {
        return this._availableAuthorityNames;
    }

    public void setAvailableAuthorities(List<AuthorityModel> availableAuthorities) {
        this._availableAuthorityNames = availableAuthorities;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityId", (Object)this._entityId).add("entityType", (Object)this._entityType).add("selectedAuthorityNames", this._selectedAuthorityNames == null ? null : Integer.valueOf(this._selectedAuthorityNames.size())).add("availableAuthorityNames", this._availableAuthorityNames == null ? null : Integer.valueOf(this._availableAuthorityNames.size())).toString();
    }
}

