/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model.db;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.EntityDynamicAttributeClientModel;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityStatusClientModel;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.like.shared.model.SubscriptionType;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DBEntity
implements Identifiable<EntityId>,
Serializable {
    public static final Function<DBEntity, EntityType> TO_ENTITY_TYPE = new Function<DBEntity, EntityType>(){

        public EntityType apply(DBEntity input) {
            return input != null ? input.getType() : null;
        }
    };
    public static final Function<? super DBEntity, EntityId> TO_ENTITY_ID = Identifiables.toId();
    public static final Function<DBEntity, List<DBEntityLink>> GET_LINKED_ENTITIES = new Function<DBEntity, List<DBEntityLink>>(){

        public List<DBEntityLink> apply(@Nullable DBEntity input) {
            return input != null ? input.getLinkedEntities() : null;
        }
    };
    public static final Function<DBEntity, String> TO_NAME = new NullPermeableFunction<DBEntity, String>(){

        @Override
        protected String applySafe(DBEntity input) {
            return input.getName();
        }
    };
    public static final Predicate<DBEntity> HAS_DEFAULT_NAVIGATION = new NullIsFalsePredicate<DBEntity>(){

        @Override
        protected boolean applySafe(DBEntity input) {
            return input.isDefaultNavigation();
        }
    };
    public static final Function<DBEntity, String> GET_DESCRIPTION = new NullPermeableFunction<DBEntity, String>(){

        @Override
        protected String applySafe(DBEntity input) {
            return input.getDescription();
        }
    };
    private static final long serialVersionUID = 3L;
    private EntityId _id;
    private EntityType _type;
    private TenantId _tenantId;
    private String _name;
    private String _description;
    private String _tags;
    private DateWithoutTimezone _startAt;
    private DateWithoutTimezone _endAt;
    private TimeZone _timeZone;
    private DateWithoutTimezone _closingDate;
    private String _location;
    private String _icon;
    private String _logo;
    private String _slideshowImage;
    private SubscriptionType _tenantSubscriptionType;
    private ImmutableSet<EntityStatusClientModel> _entityStatus = ImmutableSet.of();
    private boolean _initialDraft = false;
    private List<DBEntityLink> _linkedEntities;
    private ImmutableList<EntityDynamicAttributeClientModel> _dynamicAttributes;
    private Date _createDate;
    private Date _modifyDate;
    private int _participantLimit = -1;
    private PersonId _assignee;
    private EntityTab _defaultTab;
    private boolean _defaultNavigation = true;
    private Integer _lastDriveChange;

    @Override
    public EntityId getId() {
        return this._id;
    }

    public void setId(EntityId id) {
        this._id = id;
    }

    public EntityType getType() {
        return this._type;
    }

    public void setType(EntityType type) {
        this._type = type;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getTags() {
        return this._tags;
    }

    public void setTags(String tags) {
        this._tags = tags;
    }

    @CheckForNull
    public DateWithoutTimezone getStartAt() {
        return this._startAt;
    }

    public void setStartAt(@Nullable DateWithoutTimezone startAt) {
        this._startAt = startAt;
    }

    @CheckForNull
    public DateWithoutTimezone getEndAt() {
        return this._endAt;
    }

    public void setEndAt(@Nullable DateWithoutTimezone endAt) {
        this._endAt = endAt;
    }

    @CheckForNull
    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public void setTimeZone(@Nullable TimeZone timeZone) {
        this._timeZone = timeZone;
    }

    @CheckForNull
    public DateWithoutTimezone getClosingDate() {
        return this._closingDate;
    }

    public void setClosingDate(@Nullable DateWithoutTimezone closingDate) {
        this._closingDate = closingDate;
    }

    public String getLocation() {
        return this._location;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public String getIcon() {
        return this._icon;
    }

    public void setIcon(String icon) {
        this._icon = icon;
    }

    public String getSlideshowImage() {
        return this._slideshowImage;
    }

    public void setSlideshowImage(String slideshowImage) {
        this._slideshowImage = slideshowImage;
    }

    public String getLogo() {
        return this._logo;
    }

    public void setLogo(String logo) {
        this._logo = logo;
    }

    public List<DBEntityLink> getLinkedEntities() {
        return this._linkedEntities;
    }

    public Set<EntityId> getLinkedEntityIds() {
        return this._linkedEntities != null ? (Set)this._linkedEntities.stream().filter(Objects::nonNull).map(DBEntityLink::getLinkedEntityId).collect(ImmutableSet.toImmutableSet()) : ImmutableSet.of();
    }

    public void setLinkedEntities(List<DBEntityLink> linkedEntities) {
        this._linkedEntities = linkedEntities;
    }

    @Nonnull
    public ImmutableList<EntityDynamicAttributeClientModel> getDynamicAttributes() {
        return this._dynamicAttributes != null ? this._dynamicAttributes : ImmutableList.of();
    }

    public void setDynamicAttributes(@Nonnull ImmutableList<EntityDynamicAttributeClientModel> dynamicAttributes) {
        this._dynamicAttributes = dynamicAttributes;
    }

    public Date getCreateDate() {
        return Dates.clone(this._createDate);
    }

    public Date getModifyDate() {
        return Dates.clone(this._modifyDate);
    }

    public void setModifyDate(Date modifyDate) {
        this._modifyDate = Dates.clone(modifyDate);
    }

    public void setCreateDate(Date createDate) {
        this._createDate = Dates.clone(createDate);
    }

    public void setParticipantLimit(int participantLimit) {
        this._participantLimit = participantLimit;
    }

    public int getParticipantLimit() {
        return this._participantLimit;
    }

    @Nonnull
    public ImmutableSet<EntityStatusClientModel> getEntityStatus() {
        return this._entityStatus;
    }

    public void setEntityStatus(@Nonnull ImmutableSet<EntityStatusClientModel> entityStatus) {
        this._entityStatus = entityStatus;
    }

    public boolean isInitialDraft() {
        return this._initialDraft;
    }

    public void setInitialDraft(boolean initialDraft) {
        this._initialDraft = initialDraft;
    }

    @CheckForNull
    public PersonId getAssignee() {
        return this._assignee;
    }

    public void setAssignee(@Nullable PersonId assignee) {
        this._assignee = assignee;
    }

    public void setDefaultTab(@Nullable EntityTab defaultTab) {
        this._defaultTab = defaultTab;
    }

    @CheckForNull
    public EntityTab getDefaultTab() {
        return this._defaultTab;
    }

    public boolean isDefaultNavigation() {
        return this._defaultNavigation;
    }

    public void setDefaultNavigation(boolean defaultNavigation) {
        this._defaultNavigation = defaultNavigation;
    }

    @CheckForNull
    public Integer getLastDriveChange() {
        return this._lastDriveChange;
    }

    public void setLastDriveChange(@Nullable Integer lastDriveChange) {
        this._lastDriveChange = lastDriveChange;
    }

    @Nonnull
    public TenantId getTenantId() {
        return this._tenantId;
    }

    public void setTenantId(@Nonnull TenantId tenantId) {
        this._tenantId = tenantId;
    }

    @CheckForNull
    public SubscriptionType getTenantSubscriptionType() {
        return this._tenantSubscriptionType;
    }

    public void setTenantSubscriptionType(@Nullable SubscriptionType tenantSubscriptionType) {
        this._tenantSubscriptionType = tenantSubscriptionType;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("type", (Object)this._type).add("tenantId", (Object)this._tenantId).add("name", (Object)this._name).add("description", (Object)this._description).add("tags", (Object)this._tags).add("startAt", (Object)this._startAt).add("endAt", (Object)this._endAt).add("timeZone", (Object)this._timeZone).add("closingDate", (Object)this._closingDate).add("location", (Object)this._location).add("icon", (Object)this._icon).add("logo", (Object)this._logo).add("linkedEntities", this._linkedEntities == null ? null : Integer.valueOf(this._linkedEntities.size())).add("dynamicAttributes", this._dynamicAttributes == null ? null : Integer.valueOf(this._dynamicAttributes.size())).add("createDate", (Object)this._createDate).add("modifyDate", (Object)this._modifyDate).add("participantLimit", this._participantLimit).add("entityStatus", this._entityStatus).add("initialDraft", this._initialDraft).add("assignee", (Object)this._assignee).add("defaultTab", (Object)this._defaultTab).add("defaultNavigation", this._defaultNavigation).add("lastDriveChange", (Object)this._lastDriveChange).add("tenantSubscriptionType", (Object)this._tenantSubscriptionType).toString();
    }
}

