/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedItemId;
import de.justsoftware.onx.container.shared.model.IdParseException;
import de.justsoftware.onx.container.shared.model.ItemIdVisitor;
import de.justsoftware.onx.container.shared.model.ItemType;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TenantId
extends AbstractUUIDBasedItemId {
    private static final long serialVersionUID = 1L;

    @Deprecated
    public TenantId() {
    }

    public TenantId(UUID uuid) {
        super(uuid);
    }

    @Nonnull
    public static Optional<TenantId> parse(@Nullable String s) {
        if (s == null) {
            return Optional.empty();
        }
        try {
            String t = s.trim();
            int comma = t.indexOf(44);
            if (comma < 0 || !t.startsWith("TENANT")) {
                throw new IdParseException("Input '" + s + "' has wrong format. Must be of format 'TENANT,UUID'");
            }
            String rest = t.substring(comma + 1);
            return Optional.of(new TenantId(UUID.fromString(rest)));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    @Nonnull
    public static TenantId random() {
        return new TenantId(UUID.randomUUID());
    }

    @Override
    public ItemType getType() {
        return ItemType.TENANT;
    }

    @Override
    public <T> T accept(ItemIdVisitor<T> v) {
        return v.visit(this);
    }
}

