/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Optional;
import de.justsoftware.onx.chat.shared.model.ChatId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.DefaultItemIdVisitor;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemIdVisitor;
import de.justsoftware.onx.container.shared.model.NewsChannelId;
import de.justsoftware.onx.container.shared.model.NewsPostId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.wiki.shared.model.ArticleId;
import de.justsoftware.onx.wiki.shared.model.ChapterId;
import de.justsoftware.onx.wiki.shared.model.WikiId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

public interface SearchableId {
    public static final ItemIdVisitor<Optional<SearchableId>> ITEM_ID_TO_SEARCHABLE_ID_VISITOR = new DefaultSearchableIdItemIdVisitor<Optional<SearchableId>>(){

        @Override
        public Optional<SearchableId> visitSearchableId(SearchableId searchableId) {
            return Optional.of((Object)searchableId);
        }

        @Override
        public Optional<SearchableId> visitDefault(ItemId itemId) {
            return Optional.absent();
        }
    };

    @Nonnull
    public ItemId toItemId();

    @Nonnull
    public <T> T accept(@Nonnull Visitor<T> var1);

    @CheckForNull
    public static SearchableId parse(@Nullable String s) {
        ItemId result = ItemId.parse(s);
        if (result == null) {
            return null;
        }
        return SearchableId.fromItemId(result);
    }

    @CheckForNull
    public static SearchableId fromItemId(@Nonnull ItemId result) {
        return (SearchableId)result.accept(ITEM_ID_TO_SEARCHABLE_ID_VISITOR).orNull();
    }

    public static interface DefaultSearchableIdItemIdVisitor<T>
    extends DefaultItemIdVisitor<T> {
        @Nonnull
        public T visitSearchableId(@Nonnull SearchableId var1);

        @Override
        default public T visit(EntityId entityId) {
            return this.visitSearchableId(entityId);
        }

        @Override
        default public T visit(DriveDocumentId driveDocumentId) {
            return this.visitSearchableId(driveDocumentId);
        }

        @Override
        default public T visit(ConversationId conversationId) {
            return this.visitSearchableId(conversationId);
        }

        @Override
        default public T visit(ChatId chatId) {
            return this.visitSearchableId(chatId);
        }

        @Override
        default public T visit(NewsPostId id) {
            return this.visitSearchableId(id);
        }

        @Override
        default public T visit(NewsChannelId id) {
            return this.visitSearchableId(id);
        }

        @Override
        default public T visit(ProfileId profileId) {
            return this.visitSearchableId(profileId.asPersonId());
        }

        @Override
        default public T visit(WikiId wikiId) {
            return this.visitSearchableId(wikiId);
        }

        @Override
        default public T visit(ChapterId chapterId) {
            return this.visitSearchableId(chapterId);
        }

        @Override
        default public T visit(ArticleId articleId) {
            return this.visitSearchableId(articleId);
        }

        @Override
        default public T visit(WorkstreamMessageId workstreamMessageId) {
            return this.visitSearchableId(workstreamMessageId);
        }
    }

    public static interface DefaultSearchableIdVisitor<T>
    extends Visitor<T> {
        @Nonnull
        public T handleDefault(@Nonnull SearchableId var1);

        @Override
        default public T visit(PersonId personId) {
            return this.handleDefault(personId);
        }

        @Override
        default public T visit(EntityId entityId) {
            return this.handleDefault(entityId);
        }

        @Override
        default public T visit(WorkstreamMessageId workstreamMessageId) {
            return this.handleDefault(workstreamMessageId);
        }

        @Override
        default public T visit(ConversationId conversationId) {
            return this.handleDefault(conversationId);
        }

        @Override
        default public T visit(ChatId chatId) {
            return this.handleDefault(chatId);
        }

        @Override
        default public T visit(DriveDocumentId driveDocumentId) {
            return this.handleDefault(driveDocumentId);
        }

        @Override
        default public T visit(WikiId wikiId) {
            return this.handleDefault(wikiId);
        }

        @Override
        default public T visit(ChapterId chapterId) {
            return this.handleDefault(chapterId);
        }

        @Override
        default public T visit(ArticleId articleId) {
            return this.handleDefault(articleId);
        }
    }

    @ParametersAreNonnullByDefault
    public static interface Visitor<T> {
        @Nonnull
        public T visit(PersonId var1);

        @Nonnull
        public T visit(EntityId var1);

        @Nonnull
        public T visit(WorkstreamMessageId var1);

        @Nonnull
        public T visit(ConversationId var1);

        @Nonnull
        public T visit(ChatId var1);

        @Nonnull
        public T visit(DriveDocumentId var1);

        @Nonnull
        public T visit(WikiId var1);

        @Nonnull
        public T visit(ChapterId var1);

        @Nonnull
        public T visit(ArticleId var1);

        @Nonnull
        public T visit(NewsPostId var1);

        @Nonnull
        public T visit(NewsChannelId var1);
    }

    public static interface SearchableItemId
    extends ItemId,
    SearchableId {
        @Override
        default public ItemId toItemId() {
            return this;
        }
    }
}

