/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MyMemberStatus
implements Serializable {
    public static final MyMemberStatus DEFAULT = new MyMemberStatus((ImmutableSet<EntityMemberRole>)ImmutableSet.of(), false);
    private static final long serialVersionUID = 4L;
    private boolean _closed;
    private ImmutableSet<EntityMemberRole> _roles;

    @Deprecated
    public MyMemberStatus() {
    }

    public MyMemberStatus(@Nonnull ImmutableSet<EntityMemberRole> roles, boolean closed) {
        this._roles = roles;
        this._closed = closed;
    }

    public boolean isClosed() {
        return this._closed;
    }

    @Nonnull
    public ImmutableSet<EntityMemberRole> getRoles() {
        return this._roles;
    }

    @Nonnull
    public PublicEventStatus getEventStatus() {
        for (EntityMemberRole role : this.getRoles()) {
            if (EntityMemberRole.EVENT_IS_ATTENDING.equals(role)) {
                return PublicEventStatus.ATTENDING;
            }
            if (EntityMemberRole.EVENT_IS_ON_WAITINGLIST.equals(role)) {
                return PublicEventStatus.ON_WAITINGLIST;
            }
            if (EntityMemberRole.EVENT_IS_NOT_ATTENDING.equals(role)) {
                return PublicEventStatus.NOT_ATTENDING;
            }
            if (!EntityMemberRole.EVENT_IS_MAYBE_ATTENDING.equals(role)) continue;
            return PublicEventStatus.MAYBE_ATTENDING;
        }
        return PublicEventStatus.NOT_YET_DECIDED;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("roles", this._roles).add("closed", this._closed).toString();
    }

    public static enum PublicEventStatus implements Function<MyMemberStatus, PublicEventStatus>,
    VisitablePublicEventStatus
    {
        ATTENDING{

            @Override
            public <T> T visit(PublicEventStatusVisitor<T> visitor) {
                return visitor.visitAttending();
            }
        }
        ,
        ON_WAITINGLIST{

            @Override
            public <T> T visit(PublicEventStatusVisitor<T> visitor) {
                return visitor.visitOnWaitingList();
            }
        }
        ,
        NOT_ATTENDING{

            @Override
            public <T> T visit(PublicEventStatusVisitor<T> visitor) {
                return visitor.visitNotAttending();
            }
        }
        ,
        MAYBE_ATTENDING{

            @Override
            public <T> T visit(PublicEventStatusVisitor<T> visitor) {
                return visitor.visitMaybeAttending();
            }
        }
        ,
        NOT_YET_DECIDED{

            @Override
            public <T> T visit(PublicEventStatusVisitor<T> visitor) {
                return visitor.visitNotYetDecided();
            }
        };


        @Nonnull
        public static PublicEventStatus valueOf(@Nullable MyMemberStatus status) {
            return status != null ? status.getEventStatus() : NOT_YET_DECIDED;
        }

        public PublicEventStatus apply(MyMemberStatus status) {
            return PublicEventStatus.valueOf(status);
        }
    }

    public static interface VisitablePublicEventStatus {
        @Nonnull
        public <T> T visit(@Nonnull PublicEventStatusVisitor<T> var1);
    }

    public static interface PublicEventStatusVisitor<T> {
        @Nonnull
        public T visitAttending();

        @Nonnull
        public T visitOnWaitingList();

        @Nonnull
        public T visitNotAttending();

        @Nonnull
        public T visitMaybeAttending();

        @Nonnull
        public T visitNotYetDecided();
    }
}

