/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.shared.model.PersonId;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MemberChangeOptions {
    private static final MemberChangeOptions DEFAULT = MemberChangeOptions.builder().build();
    private final boolean _sendMailNotification;
    private final boolean _entityNewMembershipWorkstreamMessage;
    private final boolean _makeOldAdminCoAdmin;
    private final PersonId _actor;
    private final boolean _bulk;
    private final boolean _updateSubscriptions;
    private final boolean _entityCreation;

    private MemberChangeOptions(@Nonnull Builder builder) {
        this._sendMailNotification = builder._sendMailNotification;
        this._entityNewMembershipWorkstreamMessage = builder._entityNewMembershipWorkstreamMessage;
        this._makeOldAdminCoAdmin = builder._makeOldAdminCoAdmin;
        this._actor = builder._actor;
        this._bulk = builder._bulk;
        this._updateSubscriptions = builder._updateSubscriptions;
        this._entityCreation = builder._entityCreation;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static final MemberChangeOptions buildDefaultWith(@Nonnull AuthorizationCheckContextWithUserId authCtx) {
        PersonId userId = authCtx.getUserId();
        return MemberChangeOptions.buildDefaultWith(userId);
    }

    @Nonnull
    public static MemberChangeOptions buildDefaultWith(@Nonnull PersonId actorId) {
        return DEFAULT.transform().setActor(actorId).build();
    }

    @Nonnull
    public static final MemberChangeOptions buildDefault() {
        return DEFAULT;
    }

    @Nonnull
    public Builder transform() {
        return new Builder(this);
    }

    public boolean isSendMailNotification() {
        return this._sendMailNotification;
    }

    public boolean isEntityNewMembershipWorkstreamMessage() {
        return this._entityNewMembershipWorkstreamMessage;
    }

    public boolean makeOldAdminCoAdmin() {
        return this._makeOldAdminCoAdmin;
    }

    @Nonnull
    public PersonId getActor(@Nonnull PersonId defaultPersonId) {
        return this._actor != null ? this._actor : defaultPersonId;
    }

    public boolean isBulk() {
        return this._bulk;
    }

    public boolean isUpdateSubscriptions() {
        return this._updateSubscriptions;
    }

    public boolean isEntityCreation() {
        return this._entityCreation;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sendMailNotification", this._sendMailNotification).add("createMembershipNotification", this._entityNewMembershipWorkstreamMessage).add("makeOldAdminCoAdmin", this._makeOldAdminCoAdmin).add("actor", (Object)this._actor).add("bulk", this._bulk).add("updateSubscriptions", this._updateSubscriptions).add("entityCreation", this._entityCreation).toString();
    }

    public static final class Builder {
        private boolean _sendMailNotification = true;
        private boolean _entityNewMembershipWorkstreamMessage = true;
        private boolean _makeOldAdminCoAdmin = true;
        private PersonId _actor = null;
        private boolean _bulk;
        private boolean _updateSubscriptions = true;
        private boolean _entityCreation = false;

        private Builder() {
        }

        private Builder(@Nonnull MemberChangeOptions memberChangeOptions) {
            this._entityNewMembershipWorkstreamMessage = memberChangeOptions._entityNewMembershipWorkstreamMessage;
            this._sendMailNotification = memberChangeOptions._sendMailNotification;
            this._makeOldAdminCoAdmin = memberChangeOptions._makeOldAdminCoAdmin;
            this._bulk = memberChangeOptions._bulk;
            this._updateSubscriptions = memberChangeOptions._updateSubscriptions;
            this._entityCreation = memberChangeOptions._entityCreation;
        }

        @Nonnull
        public Builder enableEmailNotification() {
            this._sendMailNotification = true;
            return this;
        }

        @Nonnull
        public Builder disableEmailNotification() {
            this._sendMailNotification = false;
            return this;
        }

        @Nonnull
        public Builder setEntityNewMembershipWorkstreamMessage(boolean entityNewMembershipWorkstreamMessage) {
            this._entityNewMembershipWorkstreamMessage = entityNewMembershipWorkstreamMessage;
            return this;
        }

        @Nonnull
        public Builder setMakeOldAdminCoAdmin(boolean makeOldAdminCoAdmin) {
            this._makeOldAdminCoAdmin = makeOldAdminCoAdmin;
            return this;
        }

        @Nonnull
        public Builder setActor(@Nullable PersonId actor) {
            this._actor = actor;
            return this;
        }

        @Nonnull
        public Builder setActor(@Nonnull AuthorizationCheckContextWithUserId authCtx) {
            return this.setActor(authCtx.getUserId());
        }

        @Nonnull
        public Builder setBulk(boolean bulk) {
            this._bulk = bulk;
            return this;
        }

        @Nonnull
        public Builder setUpdateSubscriptions(boolean updateSubscriptions) {
            this._updateSubscriptions = updateSubscriptions;
            return this;
        }

        @Nonnull
        public Builder setEntityCreation(boolean entityCreation) {
            this._entityCreation = entityCreation;
            return this;
        }

        @Nonnull
        public MemberChangeOptions build() {
            return new MemberChangeOptions(this);
        }
    }
}

