/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.util.Enums2;
import de.justsoftware.onx.container.shared.model.ItemTypeVisitor;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ItemType implements Type
{
    ENTITY{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitEntity();
        }
    }
    ,
    POST{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitNewsPost();
        }
    }
    ,
    PSEUDO_ENTITY{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitPseudoEntity();
        }
    }
    ,
    DOCUMENT{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitDocument();
        }
    }
    ,
    DOCUMENT_VERSION{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitDocumentVersion();
        }
    }
    ,
    ALBUM{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitAlbum();
        }
    }
    ,
    ALBUM_IMAGE{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitAlbumImage();
        }
    }
    ,
    WIKI_EDITOR{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitWikiEditor();
        }
    }
    ,
    WIKI_VERSION{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitWikiVersion();
        }
    }
    ,
    WIKI_BACKUP{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitWikiBackup();
        }
    }
    ,
    COMMENT{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitComment();
        }
    }
    ,
    SURVEY{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitSurvey();
        }
    }
    ,
    PROFILE{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitProfile();
        }
    }
    ,
    STARTPAGE{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitStartpage();
        }
    }
    ,
    FEED{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitFeed();
        }
    }
    ,
    VIDEOLINK{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitVideolink();
        }
    }
    ,
    WORKSTREAM_MESSAGE{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitWorkstreamMessage();
        }
    }
    ,
    RAW_EDITOR{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitRawEditor();
        }
    }
    ,
    MULTI_WIKI{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitMultiWiki();
        }
    }
    ,
    MULTI_WIKI_VERSION{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitMultiWikiVersion();
        }
    }
    ,
    MULTI_WIKI_SECTION{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitMultiWikiSegment();
        }
    }
    ,
    ENTITY_VERSION{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitEntityVersion();
        }
    }
    ,
    LINK{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitLink();
        }
    }
    ,
    CONVERSATION{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitConversation();
        }
    }
    ,
    CHAT{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitChat();
        }
    }
    ,
    DRIVE_DOCUMENT{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitDriveDocument();
        }
    }
    ,
    DRIVE_TEMP_DOCUMENT{

        @Override
        public <T> T accept(@Nonnull ItemTypeVisitor<T> v) {
            return v.visitDriveTempDocument();
        }
    }
    ,
    POLL{

        @Override
        public <T> T accept(@Nonnull ItemTypeVisitor<T> v) {
            return v.visitPoll();
        }
    }
    ,
    SHARE{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitDriveShare();
        }
    }
    ,
    TASK{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitTask();
        }
    }
    ,
    TASK_LIST{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitTaskList();
        }
    }
    ,
    TENANT{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitTenant();
        }
    }
    ,
    WIKI_WIKI{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitWiki();
        }
    }
    ,
    WIKI_CHAPTER{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitChapter();
        }
    }
    ,
    WIKI_ARTICLE{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitArticle();
        }
    }
    ,
    CHANNEL{

        @Override
        public <T> T accept(ItemTypeVisitor<T> v) {
            return v.visitNewsChannel();
        }
    };

    private static final ImmutableMap<String, ItemType> BY_NAME_MAP;

    @Nonnull
    public abstract <T> T accept(@Nonnull ItemTypeVisitor<T> var1);

    @CheckForNull
    public static ItemType getItemTypeByName(@Nullable String name) {
        return (ItemType)BY_NAME_MAP.get((Object)name);
    }

    static {
        BY_NAME_MAP = Enums2.index((Enum[])ItemType.values());
    }
}

