/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.container.shared.model.Identifiable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Identifiables {
    @Nonnull
    public static <T> Function<Identifiable<? extends T>, T> toId() {
        return input -> Identifiables.getIdFromNullable(input);
    }

    @Nonnull
    public static <T> Predicate<Identifiable<? extends T>> idEquals(@Nullable T otherId) {
        return Predicates.compose((Predicate)Predicates.equalTo(otherId), Identifiables.toId());
    }

    @CheckForNull
    public static <T> T getIdFromNullable(@Nullable Identifiable<? extends T> bean) {
        return bean != null ? (T)bean.getId() : null;
    }

    @Nonnull
    public static <T> Optional<T> optionalIdOf(@Nullable Identifiable<? extends T> bean) {
        return bean == null ? Optional.absent() : Optional.fromNullable(bean.getId());
    }

    @Nonnull
    public static <T> ImmutableList<T> toIdList(@Nonnull Iterable<? extends Identifiable<T>> items) {
        return Identifiables.toNonnullIdIterable(items).toList();
    }

    @Nonnull
    public static <T> ImmutableSet<T> toIdSet(@Nonnull Iterable<? extends Identifiable<T>> items) {
        return Identifiables.toNonnullIdIterable(items).toSet();
    }

    @Nonnull
    private static <T> FluentIterable<T> toNonnullIdIterable(@Nonnull Iterable<? extends Identifiable<T>> items) {
        return FluentIterable.from(items).transform(Identifiables.toId()).filter(Predicates.notNull());
    }

    public static <T> boolean isIdIn(T id, Iterable<? extends Identifiable<? extends T>> identifiables) {
        return FluentIterable.from(identifiables).transform(Identifiables.toId()).contains(id);
    }
}

