/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.model.LongId;
import de.justsoftware.onx.container.shared.model.AbstractCreateGlobalIdVisitor;
import de.justsoftware.onx.container.shared.model.IdParseException;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class GlobalId
extends LongId
implements ItemId {
    public static final String DEFAULT_TYPE_KEY = "type";
    public static final String DEFAULT_ID_KEY = "id";
    public static final Function<Map<String, Object>, GlobalId> FROM_MAP = new Function<Map<String, Object>, GlobalId>(){

        public GlobalId apply(Map<String, Object> input) {
            return input != null ? GlobalId.fromMap(input) : null;
        }
    };
    public static final Function<GlobalId, Map<String, Object>> AS_MAP = new Function<GlobalId, Map<String, Object>>(){

        public Map<String, Object> apply(GlobalId input) {
            return input != null ? input.asMap() : Maps.newHashMap();
        }
    };
    public static final Function<Iterable<? extends GlobalId>, List<?>> AS_MAP_LIST = new Function<Iterable<? extends GlobalId>, List<?>>(){

        public List<?> apply(Iterable<? extends GlobalId> input) {
            return input != null ? GlobalId.asMapList(input) : ImmutableList.of();
        }
    };
    public static final Function<GlobalId, Map<String, Object>> AS_MAP_OR_NULL = new Function<GlobalId, Map<String, Object>>(){

        public Map<String, Object> apply(GlobalId input) {
            return input != null ? input.asMap() : null;
        }
    };
    private static final long serialVersionUID = 1L;

    @Deprecated
    public GlobalId() {
    }

    protected GlobalId(long id) {
        super(id);
    }

    @Nonnull
    public static final Predicate<GlobalId> isItemType(final @Nonnull ItemType itemType) {
        return new Predicate<GlobalId>(){

            public boolean apply(GlobalId input) {
                return input != null && input.getType() == itemType;
            }
        };
    }

    @Nonnull
    public static GlobalId create(@Nonnull Long id, @Nonnull ItemType type) {
        return GlobalId.create((long)id, type);
    }

    @Nonnull
    public static GlobalId create(final long id, @Nonnull ItemType type) {
        return (GlobalId)type.accept(new AbstractCreateGlobalIdVisitor(){

            @Override
            protected long longId() {
                return id;
            }

            @Override
            public GlobalId visitPseudoEntity() {
                throw new UnsupportedOperationException("PseudoEntityItemId is not a GlobalId");
            }

            @Override
            public ItemId visitConversation() {
                throw new UnsupportedOperationException("ConversationId is not a GlobalId");
            }

            @Override
            public ItemId visitChat() {
                throw new UnsupportedOperationException("ChatId is not a GlobalId");
            }

            @Override
            public GlobalId visitDriveDocument() {
                throw new UnsupportedOperationException("DriveDocumentId is not a GlobalId");
            }

            @Override
            public ItemId visitDriveTempDocument() {
                throw new UnsupportedOperationException("DriveTempId is not a GlobalId");
            }

            @Override
            public ItemId visitNewsPost() {
                throw new UnsupportedOperationException("NewsPostId is not a GlobalId");
            }

            @Override
            public ItemId visitNewsChannel() {
                throw new UnsupportedOperationException("NewsChannelId is not a GlobalId");
            }

            @Override
            public ItemId visitTask() {
                throw new UnsupportedOperationException("TaskId is not a GlobalId");
            }

            @Override
            public ItemId visitTaskList() {
                throw new UnsupportedOperationException("TaskListId is not a GlobalId");
            }

            @Override
            public ItemId visitDriveShare() {
                throw new UnsupportedOperationException("DriveShareId is not a GlobalId");
            }

            @Override
            public ItemId visitFeed() {
                throw new UnsupportedOperationException("FeedId is not a GlobalId");
            }

            @Override
            public ItemId visitTenant() {
                throw new UnsupportedOperationException("TenantId is not a GlobalId");
            }

            @Override
            public ItemId visitWiki() {
                throw new UnsupportedOperationException("WikiId is not a GlobalId");
            }

            @Override
            public ItemId visitChapter() {
                throw new UnsupportedOperationException("ChapterId is not a GlobalId");
            }

            @Override
            public ItemId visitArticle() {
                throw new UnsupportedOperationException("ArticleId is not a GlobalId");
            }

            @Override
            public ItemId visitPoll() {
                throw new UnsupportedOperationException("PollId is not a GlobalId");
            }
        });
    }

    @CheckForNull
    public static GlobalId parse(@Nonnull String s) throws IdParseException {
        if ("null".equals(s)) {
            return null;
        }
        try {
            String[] parts = s.split(",");
            return GlobalId.create(Long.parseLong(parts[1]), ItemType.valueOf(parts[0]));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IdParseException("Unable to parse '" + s + "'", e);
        }
        catch (NumberFormatException e) {
            throw new IdParseException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IdParseException(e);
        }
        catch (NullPointerException e) {
            throw new IdParseException(e);
        }
    }

    @CheckForNull
    public static Long parseId(@Nullable String s) {
        if (s == null || s.equals("null")) {
            return null;
        }
        String[] ss = s.split(",");
        try {
            return Long.valueOf(ss[ss.length - 1]);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public final String toString() {
        return this.asString();
    }

    @Override
    public String getSqlString() {
        return this.asString();
    }

    @Override
    public final String asString() {
        return this.getType().name() + "," + this.getId();
    }

    @Nonnull
    public Map<String, Object> asMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.addToMap(result);
        return result;
    }

    public void addToMap(@Nonnull Map<String, Object> result) {
        this.addToMap(result, DEFAULT_ID_KEY, DEFAULT_TYPE_KEY);
    }

    public void addToMap(@Nonnull Map<String, Object> result, @Nonnull String idKey, @Nonnull String typeKey) {
        result.put(idKey, this.getId());
        result.put(typeKey, this.getType());
    }

    @Nonnull
    public static List<Map<String, Object>> asMapList(@Nonnull Iterable<? extends GlobalId> globalIds) {
        return Lists.newArrayList((Iterable)Iterables.transform(globalIds, AS_MAP));
    }

    @Nonnull
    public static GlobalId fromMap(@Nonnull Map<String, Object> map) {
        return GlobalId.fromMap(map, DEFAULT_ID_KEY, DEFAULT_TYPE_KEY);
    }

    @Nonnull
    public static GlobalId fromMap(@Nonnull Map<String, Object> map, @Nonnull String idKey, @Nonnull String typeKey) {
        return GlobalId.create((Long)map.get(idKey), ItemType.valueOf((String)map.get(typeKey)));
    }

    @Nonnull
    public static List<GlobalId> fromMapList(@Nonnull List<Map<String, Object>> maps) {
        return Lists.transform(maps, FROM_MAP);
    }

    @Nonnull
    public static String asString(@Nullable GlobalId id) {
        if (id == null) {
            return "null";
        }
        return id.asString();
    }
}

