/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import de.justsoftware.onx.container.shared.model.ItemId;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class FailedAndSuccessfulActions<T extends ItemId>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ImmutableSet<T> _successfullyProcessedObjects;
    private ImmutableSetMultimap<T, String> _errorMessages;

    @Deprecated
    public FailedAndSuccessfulActions() {
    }

    protected FailedAndSuccessfulActions(@Nonnull ImmutableSet<T> successfullyProcessedObjects, @Nonnull ImmutableSetMultimap<T, String> errorMessages) {
        this._successfullyProcessedObjects = successfullyProcessedObjects;
        this._errorMessages = errorMessages;
    }

    @Nonnull
    public ImmutableSet<T> getSuccessfullyProcessedObjects() {
        return this._successfullyProcessedObjects;
    }

    @Nonnull
    public ImmutableMultimap<T, String> getErrorMessages() {
        return this._errorMessages;
    }

    @Nonnull
    public static <T extends ItemId> Builder<T> builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("successfullyProcessedObjects", this._successfullyProcessedObjects).add("errorMessages", this._errorMessages).toString();
    }

    public static class Builder<T extends ItemId> {
        protected final ImmutableSet.Builder<T> _successfullyProcessedObjectsBuilder = ImmutableSet.builder();
        protected final ImmutableSetMultimap.Builder<T, String> _errorMessagesBuilder = ImmutableSetMultimap.builder();

        @Nonnull
        public Builder<T> add(@Nonnull FailedAndSuccessfulActions<? extends T> actions) {
            this._successfullyProcessedObjectsBuilder.addAll(actions.getSuccessfullyProcessedObjects());
            this._errorMessagesBuilder.putAll(actions.getErrorMessages());
            return this;
        }

        @Nonnull
        public Builder<T> addErrorMessages(@Nonnull Iterable<? extends T> ids, @Nonnull String message) {
            this.addErrorMessages((Multimap<? extends T, String>)ImmutableMultimap.builder().putAll((Object)message, ids).build().inverse());
            return this;
        }

        @Nonnull
        public Builder<T> addErrorMessages(@Nonnull Multimap<? extends T, String> messages) {
            this._errorMessagesBuilder.putAll(messages);
            return this;
        }

        @Nonnull
        public Builder<T> addErrorMessage(@Nonnull T id, @Nonnull String message) {
            this._errorMessagesBuilder.put(id, (Object)message);
            return this;
        }

        @Nonnull
        public Builder<T> addSuccessfullyProcessedObject(@Nonnull T id) {
            this._successfullyProcessedObjectsBuilder.add(id);
            return this;
        }

        @Nonnull
        public Builder<T> addSuccessfullyProcessedObjects(@Nonnull Iterable<? extends T> ids) {
            this._successfullyProcessedObjectsBuilder.addAll(ids);
            return this;
        }

        @Nonnull
        public FailedAndSuccessfulActions<T> build() {
            return new FailedAndSuccessfulActions(this._successfullyProcessedObjectsBuilder.build(), this._errorMessagesBuilder.build());
        }
    }
}

