/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.util.ValueOfMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class EntityType
implements Type {
    public static final Function<String, EntityType> FROM_NAME = new Function<String, EntityType>(){

        public EntityType apply(String input) {
            return input != null ? BY_NAME.get(input) : null;
        }
    };
    public static final Function<EntityType, String> TO_NAME = new Function<EntityType, String>(){

        public String apply(EntityType input) {
            return input != null ? input.getName() : null;
        }
    };
    private static final long serialVersionUID = 1L;
    private static final ValueOfMap<String, EntityType> BY_NAME = new ValueOfMap<String, EntityType>(){

        @Override
        protected EntityType create(String key) {
            return new EntityType(key);
        }
    };
    public static final EntityType NETWORK = BY_NAME.get("NETWORK");
    public static final EntityType GROUP = BY_NAME.get("GROUP");
    public static final EntityType WIKI = BY_NAME.get("WIKI");
    public static final EntityType APPOINTMENT = BY_NAME.get("APPOINTMENT");
    public static final EntityType PUBLICATION = BY_NAME.get("PUBLICATION");
    public static final EntityType TOPIC = BY_NAME.get("TOPIC");
    public static final EntityType PARTNERSITE = BY_NAME.get("PARTNERSITE");
    public static final EntityType ARTICLE = BY_NAME.get("ARTICLE");
    public static final EntityType TASKS = BY_NAME.get("TASKS");
    public static final EntityType NEUIGKEIT = BY_NAME.get("NEUIGKEIT");
    private static final Map<String, Optional<EntityType>> BY_NAME_FALLBACK = EntityType.createByNameFallbackMap();
    private final String _name;

    private EntityType(@Nonnull String name) {
        this._name = name;
    }

    @Override
    public String name() {
        return this._name;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public static EntityType valueOf(@Nonnull String string) {
        return BY_NAME.get(((String)Preconditions.checkNotNull((Object)string)).trim());
    }

    @CheckForNull
    public static EntityType getEntityTypeByName(@Nullable String name) {
        String trimmed = Strings.nullToEmpty((String)name).trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        return BY_NAME.get(trimmed);
    }

    @CheckForNull
    public static EntityType safeValueOf(@Nullable String s) {
        String trimmed = Strings.nullToEmpty((String)s).trim();
        Optional<EntityType> result = BY_NAME_FALLBACK.get(trimmed);
        return result != null ? (EntityType)result.orNull() : BY_NAME.get(trimmed);
    }

    @Nonnull
    private static ImmutableMap<String, Optional<EntityType>> createByNameFallbackMap() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        result.put((Object)"0", (Object)Optional.of((Object)NETWORK));
        result.put((Object)"1", (Object)Optional.of((Object)GROUP));
        result.put((Object)"2", (Object)Optional.of((Object)WIKI));
        result.put((Object)"3", (Object)Optional.of((Object)APPOINTMENT));
        result.put((Object)"4", (Object)Optional.of((Object)PUBLICATION));
        result.put((Object)"5", (Object)Optional.of((Object)TOPIC));
        result.put((Object)"6", (Object)Optional.of((Object)PARTNERSITE));
        result.put((Object)"7", (Object)Optional.of((Object)ARTICLE));
        result.put((Object)"00", (Object)Optional.absent());
        result.put((Object)"", (Object)Optional.absent());
        return result.build();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof EntityType && Objects.equal((Object)((EntityType)obj)._name, (Object)this._name);
    }

    public int hashCode() {
        return 22 + Objects.hashCode((Object[])new Object[]{this._name});
    }

    public String toString() {
        return this._name;
    }

    @Nonnull
    Object readResolve() {
        return EntityType.valueOf(this._name);
    }
}

