/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.JucoIconType;
import de.justsoftware.onx.common.shared.model.JucoIconTypeImpl;
import de.justsoftware.onx.container.integration.persistence.model.DBEntityStatus;
import de.justsoftware.onx.container.shared.model.AbstractImmutableEqualsObject;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityType;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityStatusImpl
extends AbstractImmutableEqualsObject
implements EntityStatus {
    public static final Function<EntityStatus, EntityStatusImpl> TO_BUSINESS_MODEL = new Function<EntityStatus, EntityStatusImpl>(){

        public EntityStatusImpl apply(EntityStatus origin) {
            if (origin == null) {
                return null;
            }
            return new EntityStatusImpl((EntityStatusId)origin.getId(), origin.getName(), origin.getEntityType(), origin.getIconType(), origin.isDefault(), origin.isArchived(), origin.isPublished());
        }
    };
    private final String _name;
    private final EntityStatusId _id;
    private final EntityType _entityType;
    private final JucoIconType _iconType;
    private final boolean _default;
    private final boolean _published;
    private final boolean _archived;

    public EntityStatusImpl(DBEntityStatus dbStatus) {
        this(dbStatus.getId(), dbStatus.getStatusName(), dbStatus.getEntityType(), new JucoIconTypeImpl(dbStatus.getIconType()), dbStatus.isDefaultStatus(), dbStatus.isArchivedStatus(), dbStatus.isPublishedStatus());
    }

    public EntityStatusImpl(EntityStatusId id, String name, EntityType type, JucoIconType iconType, boolean defaultStatus, boolean archivedStatus, boolean publishedStatus) {
        super(id);
        this._name = name;
        this._id = id;
        this._entityType = type;
        this._iconType = iconType;
        this._default = defaultStatus;
        this._published = publishedStatus;
        this._archived = archivedStatus;
    }

    @Override
    public EntityStatusId getId() {
        return this._id;
    }

    @Override
    public boolean isArchived() {
        return this._archived;
    }

    @Override
    public boolean isPublished() {
        return this._published;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public EntityType getEntityType() {
        return this._entityType;
    }

    @Override
    public boolean isDefault() {
        return this._default;
    }

    @Override
    public JucoIconType getIconType() {
        return this._iconType;
    }

    @Override
    public String getI18nKey() {
        return this._entityType.getName() + "/" + this._name;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("name", (Object)this._name).add("entityType", (Object)this._entityType).add("iconType", (Object)this._iconType).add("default", this._default).add("searchable", this._published).add("archived", this._archived).toString();
    }
}

