/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.JucoIconType;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.io.Serializable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityStatusClientModel
implements EntityStatus,
Serializable {
    public static final Function<EntityStatus, EntityStatusClientModel> TO_CLIENT_MODEL = new Function<EntityStatus, EntityStatusClientModel>(){

        public EntityStatusClientModel apply(EntityStatus origin) {
            if (origin == null) {
                return null;
            }
            return new EntityStatusClientModel((EntityStatusId)origin.getId(), origin.getName(), origin.getEntityType(), origin.getIconType(), origin.isDefault(), origin.isPublished(), origin.isArchived());
        }
    };
    private static final long serialVersionUID = 1L;
    private String _name;
    private EntityStatusId _id;
    private EntityType _entityType;
    private JucoIconType _iconType;
    private boolean _default;
    private boolean _published;
    private boolean _archived;

    @Deprecated
    public EntityStatusClientModel() {
    }

    public EntityStatusClientModel(EntityStatusId id, String name, EntityType type, JucoIconType iconType, boolean defaultStatus, boolean published, boolean archived) {
        this._id = id;
        this._name = name;
        this._entityType = type;
        this._iconType = iconType;
        this._default = defaultStatus;
        this._published = published;
        this._archived = archived;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public EntityStatusId getId() {
        return this._id;
    }

    @Override
    public EntityType getEntityType() {
        return this._entityType;
    }

    @Override
    public JucoIconType getIconType() {
        return this._iconType;
    }

    @Override
    public boolean isDefault() {
        return this._default;
    }

    @Override
    public boolean isPublished() {
        return this._published;
    }

    @Override
    public boolean isArchived() {
        return this._archived;
    }

    @Override
    public String getI18nKey() {
        return this._entityType.getName() + "/" + this._name;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this._name).add("id", (Object)this._id).add("entityType", (Object)this._entityType).add("iconType", (Object)this._iconType).add("default", this._default).add("published", this._published).add("archived", this._archived).toString();
    }
}

