/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import de.justsoftware.onx.common.shared.model.JucoIconType;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.HasEntityType;
import de.justsoftware.onx.container.shared.model.Identifiable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface EntityStatus
extends Identifiable<EntityStatusId>,
HasEntityType {
    public static final Predicate<EntityStatus> IS_PUBLISHED = new Predicate<EntityStatus>(){

        public boolean apply(EntityStatus input) {
            return input != null && input.isPublished();
        }
    };
    public static final Predicate<EntityStatus> IS_ARCHIVED = new Predicate<EntityStatus>(){

        public boolean apply(EntityStatus input) {
            return input != null && input.isArchived();
        }
    };
    public static final Predicate<EntityStatus> IS_DEFAULT = new Predicate<EntityStatus>(){

        public boolean apply(EntityStatus input) {
            return input != null && input.isDefault();
        }
    };
    public static final Function<EntityStatus, String> TO_NAME = new Function<EntityStatus, String>(){

        public String apply(EntityStatus input) {
            return input != null ? input.getName() : null;
        }
    };

    default public boolean hasName(@Nullable String name) {
        return Objects.equal((Object)name, (Object)this.getName());
    }

    @Nonnull
    public String getName();

    public boolean isPublished();

    public boolean isArchived();

    public boolean isDefault();

    @Nonnull
    public JucoIconType getIconType();

    @Nonnull
    public String getI18nKey();

    default public boolean statusEquals(@Nonnull EntityStatus other) {
        return Objects.equal((Object)this.getName(), (Object)other.getName()) && Objects.equal((Object)this.getEntityType(), (Object)other.getEntityType());
    }

    @Nonnull
    default public Action readAction() {
        return this.isPublished() ? StaticEntityAction.ENTITY_READ_DETAILS : StaticEntityAction.ENTITY_READ_PRIVATE;
    }
}

