/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

public final class EntityMemberWithEntityType
implements EntityMember {
    public static final Function<EntityMemberWithEntityType, EntityType> GET_ENTITY_TYPE = new Function<EntityMemberWithEntityType, EntityType>(){

        public EntityType apply(@Nullable EntityMemberWithEntityType input) {
            return input != null ? input.getEntityType() : null;
        }
    };
    private static final long serialVersionUID = 1L;
    private PersonId _personId;
    private EntityId _entityId;
    private ImmutableSet<EntityMemberRole> _roles;
    private EntityType _entityType;
    private EntityMember.InheritanceType _inheritanceType;

    @Deprecated
    public EntityMemberWithEntityType() {
    }

    @ParametersAreNonnullByDefault
    public EntityMemberWithEntityType(PersonId personId, EntityId entityId, Iterable<EntityMemberRole> memberRoles, EntityType entityType, EntityMember.InheritanceType inheritanceType) {
        this._personId = personId;
        this._entityId = entityId;
        this._entityType = entityType;
        this._roles = EntityMemberRoles.filter(memberRoles);
        this._inheritanceType = inheritanceType;
    }

    @Override
    public PersonId getPersonId() {
        return this._personId;
    }

    @Override
    public EntityId getEntityId() {
        return this._entityId;
    }

    @Nonnull
    public EntityType getEntityType() {
        return this._entityType;
    }

    @Override
    public ImmutableSet<EntityMemberRole> getRoles() {
        return this._roles;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("personId", (Object)this._personId).add("entityId", (Object)this._entityId).add("roles", this._roles).add("entityType", (Object)this._entityType).add("inheritanceType", (Object)this._inheritanceType).toString();
    }

    @Override
    public EntityMember.InheritanceType getInheritanceType() {
        return this._inheritanceType;
    }
}

