/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityMemberRoles {
    public static final ImmutableSet<EntityMemberRole> EMPTY = ImmutableSet.of();
    public static final ImmutableSet<EntityMemberRole> VISIBLE_MEMBER = ImmutableSet.of((Object)EntityMemberRole.ADMIN, (Object)EntityMemberRole.CO_ADMIN, (Object)EntityMemberRole.MEMBER, (Object)EntityMemberRole.IS_UNDECIDED, (Object)EntityMemberRole.EVENT_IS_ATTENDING, (Object)EntityMemberRole.EVENT_IS_ON_WAITINGLIST, (Object[])new EntityMemberRole[]{EntityMemberRole.EVENT_IS_NOT_ATTENDING, EntityMemberRole.EVENT_IS_MAYBE_ATTENDING});
    public static final ImmutableSet<EntityMemberRole> HAS_INVITATION = ImmutableSet.of((Object)EntityMemberRole.HAS_INVITATION, (Object)EntityMemberRole.EVENT_IS_INVITED);
    public static final ImmutableSet<EntityMemberRole> IMPLICIT_MEMBER = HAS_INVITATION;
    public static final ImmutableSet<EntityMemberRole> ADMIN_OR_COADMIN = ImmutableSet.of((Object)EntityMemberRole.ADMIN, (Object)EntityMemberRole.CO_ADMIN);
    public static final ImmutableSet<EntityMemberRole> ALL_MEMBER_STATUS = ImmutableSet.of((Object)EntityMemberRole.MEMBER, (Object)EntityMemberRole.IS_UNDECIDED, (Object)EntityMemberRole.HAS_INVITATION, (Object)EntityMemberRole.HAS_REJECTED, (Object)EntityMemberRole.HAS_SENT_JOINREQUEST);
    public static final ImmutableSet<EntityMemberRole> MEMBERSTATUS_EXCEPT_HAS_REJECTED = FluentIterable.from(ALL_MEMBER_STATUS).filter(Predicates.not((Predicate)Predicates.equalTo((Object)EntityMemberRole.HAS_REJECTED))).toSet();
    public static final ImmutableSet<EntityMemberRole> ALL_EVENT_STATUS = ImmutableSet.of((Object)EntityMemberRole.EVENT_IS_ATTENDING, (Object)EntityMemberRole.EVENT_IS_NOT_ATTENDING, (Object)EntityMemberRole.EVENT_IS_INVITED, (Object)EntityMemberRole.EVENT_IS_MAYBE_ATTENDING, (Object)EntityMemberRole.EVENT_IS_ON_WAITINGLIST, (Object)EntityMemberRole.EVENT_HAS_REJECTED_INVITATION, (Object[])new EntityMemberRole[0]);
    public static final Set<EntityMemberRole> ALL_ADMINISTRATION_STATUS = ADMIN_OR_COADMIN;
    public static final ImmutableSet<EntityMemberRole> HAS_MEMBER_RIGHTS = ImmutableSet.builder().addAll(VISIBLE_MEMBER).addAll(IMPLICIT_MEMBER).build();

    @Nonnull
    public static Sets.SetView<EntityMemberRole> getMissingRoles(ImmutableSet<EntityMemberRole> roles, ImmutableSet<EntityMemberRole> otherSet) {
        return Sets.difference(otherSet, roles);
    }

    public static boolean isMember(Set<EntityMemberRole> roles) {
        return roles.contains(EntityMemberRole.MEMBER);
    }

    public static boolean isUndecided(Set<EntityMemberRole> roles) {
        return roles.contains(EntityMemberRole.IS_UNDECIDED);
    }

    public static boolean hasInvitation(Set<EntityMemberRole> roles) {
        return roles.contains(EntityMemberRole.HAS_INVITATION);
    }

    public static boolean hasEventInvitation(ImmutableSet<EntityMemberRole> roles) {
        return roles.contains((Object)EntityMemberRole.EVENT_IS_INVITED);
    }

    public static boolean hasRejected(Set<EntityMemberRole> roles) {
        return roles.contains(EntityMemberRole.HAS_REJECTED);
    }

    public static boolean hasRejectedEventInvitation(ImmutableSet<EntityMemberRole> roles) {
        return roles.contains((Object)EntityMemberRole.EVENT_HAS_REJECTED_INVITATION);
    }

    public static boolean hasSentJoinRequest(Set<EntityMemberRole> roles) {
        return roles.contains(EntityMemberRole.HAS_SENT_JOINREQUEST);
    }

    public static boolean isAdmin(Set<EntityMemberRole> roles) {
        return roles.contains(EntityMemberRole.ADMIN);
    }

    public static boolean isCoAdmin(Set<EntityMemberRole> roles) {
        return roles.contains(EntityMemberRole.CO_ADMIN);
    }

    public static boolean isAdminOrCoAdmin(Set<EntityMemberRole> roles) {
        return EntityMemberRoles.hasAnyRoleOf(roles, ADMIN_OR_COADMIN);
    }

    public static boolean hasMemberRights(Set<EntityMemberRole> roles) {
        return EntityMemberRoles.hasAnyRoleOf(roles, HAS_MEMBER_RIGHTS);
    }

    public static boolean isShownAsMember(ImmutableSet<EntityMemberRole> roles) {
        return EntityMemberRoles.hasAnyRoleOf(roles, VISIBLE_MEMBER);
    }

    public static boolean isInvited(Set<EntityMemberRole> roles) {
        return EntityMemberRoles.hasAnyRoleOf(roles, HAS_INVITATION);
    }

    public static boolean hasStatus(Set<EntityMemberRole> roles) {
        return EntityMemberRoles.hasAnyRoleOf(roles, ALL_MEMBER_STATUS);
    }

    public static boolean isOnWaitinglist(Set<EntityMemberRole> roles) {
        return roles.contains(EntityMemberRole.EVENT_IS_ON_WAITINGLIST);
    }

    public static boolean isAttendingEvent(Set<EntityMemberRole> roles) {
        return roles.contains(EntityMemberRole.EVENT_IS_ATTENDING);
    }

    public static boolean isNotAttendingEvent(Set<EntityMemberRole> roles) {
        return roles.contains(EntityMemberRole.EVENT_IS_NOT_ATTENDING);
    }

    public static boolean isMaybeAttendingEvent(Set<EntityMemberRole> roles) {
        return roles.contains(EntityMemberRole.EVENT_IS_MAYBE_ATTENDING);
    }

    public static boolean hasAnyRoleOf(Set<EntityMemberRole> these, Set<EntityMemberRole> those) {
        return !Sets.intersection(these, those).isEmpty();
    }

    @Nonnull
    public static ImmutableSet<EntityMemberRole> filter(Iterable<EntityMemberRole> roles) {
        ImmutableSet result = EntityMemberRoles.filterInternal(Sets.newHashSet(roles));
        return roles.equals(result) ? ImmutableSet.copyOf(roles) : result;
    }

    @Nonnull
    private static ImmutableSet<EntityMemberRole> filterInternal(HashSet<EntityMemberRole> roles) {
        if (EntityMemberRoles.hasInvitation(roles) && EntityMemberRoles.hasSentJoinRequest(roles)) {
            roles.add(EntityMemberRole.MEMBER);
        }
        if (EntityMemberRoles.isMember(roles)) {
            roles.remove(EntityMemberRole.HAS_INVITATION);
            roles.remove(EntityMemberRole.HAS_SENT_JOINREQUEST);
            roles.remove(EntityMemberRole.HAS_REJECTED);
            roles.remove(EntityMemberRole.IS_UNDECIDED);
        }
        if (EntityMemberRoles.isUndecided(roles)) {
            roles.remove(EntityMemberRole.HAS_REJECTED);
        }
        if (EntityMemberRoles.isAdmin(roles)) {
            roles.remove(EntityMemberRole.CO_ADMIN);
        }
        return ImmutableSet.copyOf(roles);
    }

    @Nonnull
    public static Predicate<Collection<? extends EntityMemberRole>> hasAnyRolePredicate(Collection<? extends EntityMemberRole> roles) {
        return input -> EntityMemberRoles.hasAnyRole(roles, input);
    }

    private static boolean hasAnyRole(Collection<? extends EntityMemberRole> roles, Collection<? extends EntityMemberRole> input) {
        return input != null && roles != null && !Collections.disjoint(roles, input);
    }

    @Nonnull
    public static ImmutableSet<EntityMemberRole> addRoles(Set<EntityMemberRole> roles, Iterable<EntityMemberRole> newRoles) {
        return EntityMemberRoles.filterInternal(Sets.newHashSet((Iterable)Iterables.concat(roles, newRoles)));
    }

    @Nonnull
    public static ImmutableSet<EntityMemberRole> removeRoles(Set<EntityMemberRole> roles, Set<EntityMemberRole> rolesToRemove) {
        HashSet temp = Sets.newHashSet(roles);
        temp.removeAll(rolesToRemove);
        return EntityMemberRoles.filterInternal(temp);
    }

    @Nonnull
    public static ImmutableSet<EntityMemberRole> replaceRoles(Set<EntityMemberRole> roles, Set<EntityMemberRole> rolesToRemove, Set<EntityMemberRole> rolesToAdd) {
        HashSet temp = Sets.newHashSet(roles);
        temp.removeAll(rolesToRemove);
        temp.addAll(rolesToAdd);
        return EntityMemberRoles.filterInternal(temp);
    }

    public static enum Comperators implements Comparator<Set<EntityMemberRole>>
    {
        ADMINS_FIRST{

            @Override
            public int compare(Set<EntityMemberRole> o1, Set<EntityMemberRole> o2) {
                return Ints.compare((int)this.prio(o1), (int)this.prio(o2));
            }

            private int prio(@Nullable Set<EntityMemberRole> o1) {
                if (o1 == null) {
                    return 4;
                }
                if (EntityMemberRoles.isAdmin(o1)) {
                    return 0;
                }
                if (EntityMemberRoles.isCoAdmin(o1)) {
                    return 1;
                }
                if (EntityMemberRoles.isMember(o1)) {
                    return 2;
                }
                return 3;
            }
        };

    }
}

