/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.EntityId;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

public class EntityMemberInternalInvitation {
    public static final Function<EntityMemberInternalInvitation, PersonId> GET_INVITER_ID = new Function<EntityMemberInternalInvitation, PersonId>(){

        public PersonId apply(EntityMemberInternalInvitation input) {
            return input != null ? input.getInviterId() : null;
        }
    };
    public static final Function<EntityMemberInternalInvitation, EntityId> GET_ENTITY_ID = new Function<EntityMemberInternalInvitation, EntityId>(){

        public EntityId apply(EntityMemberInternalInvitation input) {
            return input != null ? input.getEntityId() : null;
        }
    };
    private final Date _invitationDate;
    private final PersonId _inviterId;
    private final String _inviteMessage;
    private final EntityId _entityId;
    private final PersonId _personId;

    @ParametersAreNonnullByDefault
    public EntityMemberInternalInvitation(EntityId entityId, PersonId personId, PersonId inviterId, String invitationMessage) {
        this(entityId, personId, inviterId, invitationMessage, new Date());
    }

    @ParametersAreNonnullByDefault
    public EntityMemberInternalInvitation(EntityId entityId, PersonId personId, PersonId inviterId, String invitationMessage, Date invitationDate) {
        this._entityId = entityId;
        this._personId = personId;
        this._inviterId = inviterId;
        this._inviteMessage = invitationMessage;
        this._invitationDate = Dates.clone(invitationDate);
    }

    @Nonnull
    public EntityId getEntityId() {
        return this._entityId;
    }

    @Nonnull
    public PersonId getPersonId() {
        return this._personId;
    }

    @Nonnull
    public PersonId getInviterId() {
        return this._inviterId;
    }

    @Nonnull
    public String getInviteMessage() {
        return this._inviteMessage;
    }

    @Nonnull
    public Date getInvitationDate() {
        return Dates.clone(this._invitationDate);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityId", (Object)this._entityId).add("personId", (Object)this._personId).add("inviterId", (Object)this._inviterId).add("inviteMessage", (Object)this._inviteMessage).add("invitationDate", (Object)this._invitationDate).toString();
    }
}

