/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.DefaultComponentTypeVisitor;
import de.justsoftware.onx.common.shared.util.Enums2;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum EntityAnchorComponent {
    DESCRIPTION,
    WIKI_EDITOR,
    MULTI_WIKI,
    RAW_EDITOR1,
    RAW_EDITOR2,
    RAW_EDITOR3,
    RAW_EDITOR4;

    private static final ImmutableMap<String, EntityAnchorComponent> MAP;

    @Nonnull
    public static Optional<EntityAnchorComponent> fromComponentType(ComponentType componentType) {
        return componentType.accept(new DefaultComponentTypeVisitor<Optional<EntityAnchorComponent>>(){

            @Override
            protected Optional<EntityAnchorComponent> visitDefault() {
                return Optional.absent();
            }

            @Override
            public Optional<EntityAnchorComponent> visitRawEditor1() {
                return Optional.of((Object)((Object)RAW_EDITOR1));
            }

            @Override
            public Optional<EntityAnchorComponent> visitRawEditor2() {
                return Optional.of((Object)((Object)RAW_EDITOR2));
            }

            @Override
            public Optional<EntityAnchorComponent> visitRawEditor3() {
                return Optional.of((Object)((Object)RAW_EDITOR3));
            }

            @Override
            public Optional<EntityAnchorComponent> visitRawEditor4() {
                return Optional.of((Object)((Object)RAW_EDITOR4));
            }

            @Override
            public Optional<EntityAnchorComponent> visitWikiEditor() {
                return Optional.of((Object)((Object)WIKI_EDITOR));
            }

            @Override
            public Optional<EntityAnchorComponent> visitMultiWiki() {
                return Optional.of((Object)((Object)MULTI_WIKI));
            }
        });
    }

    @CheckForNull
    public static EntityAnchorComponent safeValueOf(@Nullable String s) {
        return (EntityAnchorComponent)((Object)MAP.get((Object)s));
    }

    static {
        MAP = Enums2.index((Enum[])EntityAnchorComponent.values());
    }
}

