/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.shared.model;

import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedId;
import de.justsoftware.onx.container.shared.model.IdParseException;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class AbstractUUIDBasedItemId
extends AbstractUUIDBasedId
implements ItemId {
    private static final long serialVersionUID = 1L;

    @Deprecated
    public AbstractUUIDBasedItemId() {
    }

    public AbstractUUIDBasedItemId(UUID id) {
        super(id);
    }

    @Override
    public final String asString() {
        return this.getType().name() + "," + this.getId();
    }

    @Override
    public final String toString() {
        return this.asString();
    }

    @Override
    public final String getSqlString() {
        return this.asString();
    }

    @Nonnull
    protected static UUID getUUID(String idString, ItemType expectedItemType) throws IdParseException {
        try {
            String[] parts = idString.split(",");
            ItemType itemType = ItemType.valueOf(parts[0]);
            if (itemType != expectedItemType) {
                throw new IdParseException("ID '" + idString + "' is not of expected type " + expectedItemType.name());
            }
            return UUID.fromString(parts[1]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IdParseException("Unable to parse '" + idString + "'", e);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IdParseException(e);
        }
    }
}

