/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.integration.persistence.EntityWaitlistDAO;
import de.justsoftware.onx.container.shared.model.EntityId;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class IbatisEntityWaitlistDAO
implements EntityWaitlistDAO {
    private static final String NAMESPACE = "EntityWaitlist.";
    private final SqlMapClient _sqlMapper;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisEntityWaitlistDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapper) {
        this._sqlMapper = sqlMapper;
    }

    @Override
    public void addToWaitlist(Set<EntityId> entityIds, PersonId personId) {
        if (entityIds.isEmpty()) {
            return;
        }
        HashMap params = Maps.newHashMap();
        params.put("entities", IbatisDAOUtil.toIbatisList(entityIds));
        params.put("personId", personId);
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "EntityWaitlist.addToWaitlist", params);
    }

    @Override
    public void removeFromWaitlist(Set<EntityId> entityIds, PersonId personId) {
        if (entityIds.isEmpty()) {
            return;
        }
        ImmutableMap params = ImmutableMap.of((Object)"entities", IbatisDAOUtil.toIbatisList(entityIds), (Object)"personId", (Object)personId);
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "EntityWaitlist.removeFromWaitlist", params);
    }

    @Override
    public void removeFromWaitlist(Set<PersonId> personIds, EntityId entityId) {
        if (personIds.isEmpty()) {
            return;
        }
        ImmutableMap params = ImmutableMap.of((Object)"persons", IbatisDAOUtil.toIbatisList(personIds), (Object)"entityId", (Object)entityId);
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "EntityWaitlist.removePersonsFromWaitlist", params);
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getParticipantsFromWaitlist(Set<EntityId> entityIds) {
        if (entityIds.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        return IbatisDAOUtil.wrappedQueryForSetMultiMap(this._sqlMapper, "EntityWaitlist.getParticipantsFromWaitlist", "entity_id", "person_id", IbatisDAOUtil.toIbatisList(entityIds));
    }
}

