/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimaps;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.container.integration.persistence.EntityVersionReviewDAO;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionReviewStatus;
import de.justsoftware.onx.container.shared.model.db.DBEntityVersionReview;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class IbatisEntityVersionReviewDAO
implements EntityVersionReviewDAO {
    private static final String NAMESPACE = "EntityVersionReview.";
    private final SqlMapClient _sqlMapClient;
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisEntityVersionReviewDAO(StatementBuilderFactory statementBuilderFactory, @Qualifier(value="sqlMapClient") SqlMapClient sqlMapClient) {
        this._sqlMapClient = sqlMapClient;
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("EntityVersionReview");
    }

    @Override
    public void createReview(DBEntityVersionReview review) {
        IbatisDAOUtil.wrappedInsert(this._sqlMapClient, "EntityVersionReview.insertReview", review);
    }

    @Override
    public ListAndCount<DBEntityVersionReview> getInReviewForPerson(int offset, int limit, PersonId reviewerId) {
        int count = this.getInReviewForPersonCount(reviewerId);
        if (count > offset) {
            List list = IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, "EntityVersionReview.selectInReviewForPerson", reviewerId, offset, limit);
            return new ListAndCount<DBEntityVersionReview>(count, list);
        }
        return new ListAndCount<DBEntityVersionReview>(count, (Collection<DBEntityVersionReview>)ImmutableList.of());
    }

    @Override
    public int getInReviewForPersonCount(PersonId reviewerId) {
        return Numbers.intValue((Number)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapClient, "EntityVersionReview.selectInReviewForPersonCount", reviewerId));
    }

    @Override
    public ImmutableListMultimap<EntityVersionId, DBEntityVersionReview> getReviewsForVersions(Set<EntityVersionId> versionIds) {
        ImmutableList result = IbatisDAOUtil.wrappedPartitionQueryForImmutableList(this._sqlMapClient, "EntityVersionReview.selectReviewsForVersions", versionIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
        return Multimaps.index(result, DBEntityVersionReview.GET_ENTITY_VERSION_ID);
    }

    @Override
    public DBEntityVersionReview getNextReviewWithStatus(EntityVersionId versionId, EntityVersionReviewStatus status) {
        List reviews = IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, "EntityVersionReview.selectReviewsForVersionWithStatus", ImmutableMap.of((Object)"versionId", (Object)versionId, (Object)"reviewStatus", (Object)((Object)status)), 0, 1);
        if (reviews.size() > 0 && reviews.get(0) != null) {
            return (DBEntityVersionReview)reviews.get(0);
        }
        return null;
    }

    @Override
    public DBEntityVersionReview getReviewFromPerson(EntityVersionId versionId, PersonId reviewerId) {
        return (DBEntityVersionReview)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapClient, "EntityVersionReview.selectReviewFromPerson", ImmutableMap.of((Object)"versionId", (Object)versionId, (Object)"reviewerId", (Object)reviewerId));
    }

    @Override
    public void updateReviewStatus(EntityVersionId versionId, PersonId reviewerId, EntityVersionReviewStatus status) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, "EntityVersionReview.updateReviewStatus", ImmutableMap.of((Object)"versionId", (Object)versionId, (Object)"reviewerId", (Object)reviewerId, (Object)"reviewStatus", (Object)((Object)status)));
    }

    @Override
    public void deleteVersionsByEntityId(EntityId entityId) {
        IbatisDAOUtil.wrappedDelete(this._sqlMapClient, "EntityVersionReview.deleteVersionReviewsByEntityId", entityId);
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getEntityVersionReviewer(Set<EntityId> entityIds, Set<EntityStatusId> inReviewStateIds) {
        if (inReviewStateIds.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getEntityReviewers").partition("entityIds", entityIds, "entityStates", ImmutableList.copyOf(inReviewStateIds))).asSetMultimap("entityId", "reviewerId");
    }

    @Override
    public int forAllReviewers(Set<EntityStatusId> inReviewStateIds, BiConsumer<EntityId, PersonId> consumer) {
        return this._statementBuilder.select("getAllReviewers").param(ImmutableList.copyOf(inReviewStateIds)).executeWithBiConsumer("entityId", "reviewerId", consumer);
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getAllPossibleReviewers(Set<EntityId> entities) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getAllPossibleReviewers").partition(entities)).asSetMultimap("entityId", "reviewerId");
    }
}

