/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.ibatis;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.container.integration.persistence.EntityVersionComponentsDao;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionId;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class IbatisEntityVersionComponentsDAO
implements EntityVersionComponentsDao {
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisEntityVersionComponentsDAO(StatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("EntityVersionComponents");
    }

    @Override
    public ImmutableMap<EntityVersionId, MultiWikiVersionId> getMultiWikiVersionsForEntityVersions(Set<EntityVersionId> entityVersionsIds) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("selectMultiWikiVersions").partition(entityVersionsIds)).asMap("entityVersionId", "multiWikiVersionId");
    }

    @Override
    public ImmutableSetMultimap<MultiWikiVersionId, EntityVersionId> getEntityVersionsForMultiWikiVersions(Set<MultiWikiVersionId> multiWikiVersions) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("selectEntityVersionsForMultiWikiVersions").partition(multiWikiVersions)).asSetMultimap("multiWikiVersionId", "entityVersionId");
    }

    @Override
    public void setVersionComponents(EntityVersionId versionId, MultiWikiVersionId wikiVersionId) {
        this._statementBuilder.insert("setVersionComponents").param("entityVersionId", versionId, "multiWikiVersionId", wikiVersionId);
    }

    @Override
    public void deleteVersionComponents(Set<EntityVersionId> versionIds) {
        this._statementBuilder.delete("deleteByVersionIds").partition(versionIds);
    }
}

