/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.integration.persistence.EntityStatusDAO;
import de.justsoftware.onx.container.integration.persistence.model.DBEntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.process.business.model.EntityStatusTemplate;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Repository
public class IbatisEntityStatusDAO
implements EntityStatusDAO {
    private static final String NAMESPACE = "EntityStatus.";
    @Autowired
    @Qualifier(value="sqlMapClient")
    private SqlMapClient _sqlMapClient;
    @Autowired
    private TransactionHelper _transactionHelper;

    @Override
    public ImmutableSet<DBEntityStatus> getStatusForEntityType(Set<? extends EntityType> entityTypes) {
        return IbatisDAOUtil.wrappedPartitionQueryForImmutableSet(this._sqlMapClient, "EntityStatus.selectStatusForTypes", entityTypes, IbatisDAOUtil.OBJECTS_TO_IBATIS_LIST);
    }

    @Override
    public EntityStatusId insert(final DBEntityStatus entityVersionStatus) {
        return this._transactionHelper.doInTransaction(new TransactionCallback<EntityStatusId>(){

            public EntityStatusId doInTransaction(TransactionStatus status) {
                if (entityVersionStatus.isDefaultStatus()) {
                    IbatisDAOUtil.wrappedUpdate(IbatisEntityStatusDAO.this._sqlMapClient, "EntityStatus.resetDefaultStatusForEntityType", entityVersionStatus.getEntityType().getName());
                }
                return (EntityStatusId)IbatisDAOUtil.wrappedInsert(IbatisEntityStatusDAO.this._sqlMapClient, "EntityStatus.insertEntityStatus", entityVersionStatus);
            }
        });
    }

    @Override
    public void deleteStatus(Set<EntityStatusId> ids) {
        if (ids.isEmpty()) {
            return;
        }
        IbatisDAOUtil.wrappedDelete(this._sqlMapClient, "EntityStatus.deleteStatus", IbatisDAOUtil.toIbatisList(ids));
    }

    @Override
    public void updateStatus(final DBEntityStatus entityStatus, final EntityStatusTemplate updateModel) {
        this._transactionHelper.doInTransaction(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                if (updateModel.isDefault()) {
                    IbatisDAOUtil.wrappedUpdate(IbatisEntityStatusDAO.this._sqlMapClient, "EntityStatus.resetDefaultStatusForEntityType", entityStatus.getEntityType().getName());
                }
                IbatisDAOUtil.wrappedUpdate(IbatisEntityStatusDAO.this._sqlMapClient, "EntityStatus.updateStatus", ImmutableMap.of((Object)"status", (Object)updateModel, (Object)"id", (Object)entityStatus.getId()));
            }
        });
    }

    @Override
    public ImmutableSet<DBEntityStatus> getStatusById(Set<EntityStatusId> ids) {
        return IbatisDAOUtil.wrappedQueryForImmutableSet(this._sqlMapClient, "EntityStatus.selectById", IbatisDAOUtil.toIbatisList(ids));
    }
}

