/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntitySortField;
import de.justsoftware.onx.container.integration.persistence.EntityMemberRoleDAO;
import de.justsoftware.onx.container.integration.persistence.model.DBEntityMemberIdAndRole;
import de.justsoftware.onx.container.integration.persistence.model.DBEntityMemberIdAndRoleWithEntityType;
import de.justsoftware.onx.container.integration.persistence.model.DBEntityMemberIdAndRoleWithPerson;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.person.integration.persistence.DBPersonRelation;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service
public class IbatisEntityMemberRoleDAO
implements EntityMemberRoleDAO {
    private static final String NAMESPACE = "EntityMemberRole.";
    private static final String ENTITIES = "entityIds";
    private static final String PERSONS = "personIds";
    private static final String ROLES = "roles";
    private static final ImmutableList<EntityMemberRole> MEMBER_ROLES = ImmutableList.of((Object)EntityMemberRole.MEMBER, (Object)EntityMemberRole.EVENT_IS_ATTENDING);
    private final SqlMapClient _sqlMapper;
    private final TransactionHelper _transactionHelper;
    private final IbatisStatementBuilder _ibatisBuilder;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisEntityMemberRoleDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapper, TransactionHelper transactionHelper, StatementBuilderFactory statementBuilderFactory) {
        this._sqlMapper = sqlMapper;
        this._transactionHelper = transactionHelper;
        this._ibatisBuilder = statementBuilderFactory.ibatistStatementBuilder("EntityMemberRole");
    }

    @Override
    public void persistRoles(final Set<EntityId> entityIds, final Set<PersonId> personIds, final Set<EntityMemberRole> roles) {
        if (this.checkEntitiesPersonsAndRoleExist(entityIds, personIds, roles)) {
            return;
        }
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                IbatisEntityMemberRoleDAO.this.deleteAllRoles(entityIds, personIds);
                IbatisEntityMemberRoleDAO.this.insertRoles(entityIds, personIds, roles);
            }
        });
    }

    @Override
    public void mergeRoles(final Set<EntityId> entityIds, final Set<PersonId> personIds, final Set<EntityMemberRole> rolesToRemove, final Set<EntityMemberRole> rolesToAdd) {
        if (this.checkEntitiesPersonsAndRoleExist(entityIds, personIds, rolesToAdd)) {
            return;
        }
        if (!rolesToRemove.isEmpty() || !rolesToAdd.isEmpty()) {
            this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    IbatisEntityMemberRoleDAO.this.deleteRoles(entityIds, personIds, rolesToRemove);
                    IbatisEntityMemberRoleDAO.this.insertRoles(entityIds, personIds, rolesToAdd);
                }
            });
        }
    }

    @ParametersAreNonnullByDefault
    private void deleteAllRoles(Set<EntityId> entityIds, Set<PersonId> personIds) {
        IbatisDAOUtil.partitionOperation(ENTITIES, entityIds, PERSONS, personIds, new IbatisDAOUtil.PartitionCallback(){

            @Override
            public void apply(HashMap<String, Object> params) throws SQLException {
                IbatisEntityMemberRoleDAO.this._sqlMapper.delete("EntityMemberRole.deleteAllRolesForPersonIdSetAndEntityIdSet", params);
            }
        });
    }

    @ParametersAreNonnullByDefault
    private void deleteRoles(Set<EntityId> entityIds, Set<PersonId> personIds, final Set<EntityMemberRole> roles) {
        if (!roles.isEmpty()) {
            IbatisDAOUtil.partitionOperation(ENTITIES, entityIds, PERSONS, personIds, new IbatisDAOUtil.PartitionCallback(){

                @Override
                public void apply(HashMap<String, Object> params) throws SQLException {
                    params.put(IbatisEntityMemberRoleDAO.ROLES, IbatisDAOUtil.toIbatisList(roles));
                    IbatisEntityMemberRoleDAO.this._sqlMapper.delete("EntityMemberRole.bulkDeleteRoles", params);
                }
            });
        }
    }

    @ParametersAreNonnullByDefault
    private void insertRoles(Set<EntityId> entityIds, Set<PersonId> personIds, final Set<EntityMemberRole> roles) {
        if (!roles.isEmpty()) {
            IbatisDAOUtil.partitionOperation(ENTITIES, entityIds, PERSONS, personIds, new IbatisDAOUtil.PartitionCallback(){

                @Override
                public void apply(HashMap<String, Object> params) throws SQLException {
                    params.put(IbatisEntityMemberRoleDAO.ROLES, IbatisDAOUtil.toIbatisList(roles));
                    IbatisEntityMemberRoleDAO.this._sqlMapper.insert("EntityMemberRole.bulkInsertRoles", params);
                }
            });
        }
    }

    @ParametersAreNonnullByDefault
    private boolean checkEntitiesPersonsAndRoleExist(Set<EntityId> entityIds, Set<PersonId> personIds, Set<EntityMemberRole> roles) {
        if (entityIds.isEmpty() || personIds.isEmpty()) {
            return true;
        }
        if (roles.isEmpty()) {
            return false;
        }
        int entityCount = IbatisDAOUtil.wrappedPartitionQueryForCount(this._sqlMapper, "EntityMemberRole.getExistingCountForEntityIdsInSet", entityIds, IbatisDAOUtil.OBJECTS_TO_IBATIS_LIST);
        if (entityIds.size() != entityCount) {
            throw new DAOException("Can't handle member role updates on missing entities");
        }
        int personCount = IbatisDAOUtil.wrappedPartitionQueryForCount(this._sqlMapper, "EntityMemberRole.getExistingCountForPersonIdsInSet", personIds, IbatisDAOUtil.OBJECTS_TO_IBATIS_LIST);
        if (personIds.size() != personCount) {
            throw new DAOException("Can't handle member role updates on missing persons");
        }
        int rolesCount = IbatisDAOUtil.wrappedPartitionQueryForCount(this._sqlMapper, "EntityMemberRole.getExistingCountForRolesInSet", roles, IbatisDAOUtil.OBJECTS_TO_IBATIS_LIST);
        if (roles.size() != rolesCount) {
            throw new DAOException("Can't handle member role updates on missing roles");
        }
        return false;
    }

    @Override
    public ImmutableList<DBEntityMemberIdAndRoleWithPerson> getByEntityIds(Set<? extends EntityId> entityIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForImmutableList(this._sqlMapper, "EntityMemberRole.getRolesForEntityIdSet", entityIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableList<DBEntityMemberIdAndRoleWithEntityType> getByPersonIds(Set<? extends PersonId> personIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForImmutableList(this._sqlMapper, "EntityMemberRole.getRolesForPersonIdSet", personIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableList<DBPersonRelation> getMembersOfSameEntityOfPersons(Set<? extends PersonId> personIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForImmutableList(this._sqlMapper, "EntityMemberRole.getMemberOfSameEntityForPersonIdSet", personIds, IbatisDAOUtil.createParameterFunctionForIdsWithMapData(PERSONS, ImmutableMap.of((Object)ROLES, IbatisDAOUtil.toIbatisList(EntityMemberRoles.HAS_MEMBER_RIGHTS))));
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getJoinRequests(PersonId personId, Iterable<EntityType> types) {
        if (CollectionUtil.isEmpty(types)) {
            return ImmutableSetMultimap.of();
        }
        return IbatisDAOUtil.wrappedQueryForSetMultiMap(this._sqlMapper, "EntityMemberRole.findJoinRequests", "entityId", "personId", (Object)ImmutableMap.of((Object)"personId", (Object)personId, (Object)"types", IbatisDAOUtil.toIbatisList(types), (Object)"adminRoles", (Object)Lists.newArrayList((Object[])new EntityMemberRole[]{EntityMemberRole.ADMIN, EntityMemberRole.CO_ADMIN}), (Object)"joinRequestStatus", (Object)EntityMemberRole.HAS_SENT_JOINREQUEST));
    }

    @Override
    public ImmutableSet<PersonId> getPersonIdsWithProfileImage(EntityId entityId) {
        return IbatisDAOUtil.wrappedQueryForImmutableSet(this._sqlMapper, "EntityMemberRole.findActiveMemberIdsWithProfileImageAndRole", ImmutableMap.of((Object)"entityId", (Object)entityId, (Object)ROLES, MEMBER_ROLES));
    }

    @Override
    public ImmutableSet<PersonId> getPersonIdsWithoutProfileImage(EntityId entityId) {
        return IbatisDAOUtil.wrappedQueryForImmutableSet(this._sqlMapper, "EntityMemberRole.findActiveMemberIdsWithoutProfileImageAndRole", ImmutableMap.of((Object)"entityId", (Object)entityId, (Object)ROLES, MEMBER_ROLES));
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getEntityMembersByEntityTypesAndPersonIdsAndRoles(Iterable<EntityType> entityTypes, Set<PersonId> personIds, Set<EntityMemberRole> roles) {
        if (!entityTypes.iterator().hasNext() || roles.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        return IbatisDAOUtil.wrappedPartitionQueryForSetMultimap(this._sqlMapper, "EntityMemberRole.findMemberIdsOfRoleByEntityTypesAndPersonIdSet", "entityId", "personId", personIds, IbatisDAOUtil.createParameterFunctionForIdsWithMapData(PERSONS, ImmutableMap.of((Object)"entityTypes", (Object)Lists.newArrayList(entityTypes), (Object)ROLES, IbatisDAOUtil.toIbatisList(roles))));
    }

    @Override
    public ImmutableList<EntityId> getEntityMembersByEntityTypesAndPersonIdAndRoles(Iterable<EntityType> entityTypes, PersonId personId, Set<EntityMemberRole> roles, int offset, int limit) {
        if (!entityTypes.iterator().hasNext() || roles.isEmpty()) {
            return ImmutableList.of();
        }
        return ((IbatisStandardResultBuilder)this._ibatisBuilder.selectDbSpecific("findMemberIdsOfRoleByEntityTypesAndPersonIdRange").param("personId", personId, "entityTypes", Lists.newArrayList(entityTypes), ROLES, IbatisDAOUtil.toIbatisList(roles), "offset", offset, "limit", limit)).asList();
    }

    @Override
    public int getExistingCountForEntityMembersByEntityTypesAndPersonIdAndRoles(Iterable<EntityType> entityTypes, PersonId personId, Set<EntityMemberRole> roles) {
        if (!entityTypes.iterator().hasNext() || roles.isEmpty()) {
            return 0;
        }
        return ((IbatisStandardResultBuilder)this._ibatisBuilder.select("getExistingCountForMemberIdsOfRoleByEntityTypesAndPersonIdSet").param("personId", personId, "entityTypes", IbatisDAOUtil.toIbatisList(entityTypes), ROLES, IbatisDAOUtil.toIbatisList(roles))).asCount();
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getMembersByEntityTypesAndRoles(Set<EntityType> entityTypes, Set<EntityMemberRole> roles) {
        if (!entityTypes.iterator().hasNext() || roles.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        return IbatisDAOUtil.wrappedQueryForSetMultiMap(this._sqlMapper, "EntityMemberRole.findMemberIdsOfRoleByEntityTypes", "entityId", "personId", (Object)ImmutableMap.of((Object)"entityTypes", IbatisDAOUtil.toIbatisList(entityTypes), (Object)ROLES, IbatisDAOUtil.toIbatisList(roles)));
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getEntityMembersByEntityTypesAndEntityIdsAndRoles(Set<EntityType> entityTypes, Set<EntityId> entityIds, Set<EntityMemberRole> roles) {
        if (entityTypes.isEmpty() || entityIds.isEmpty() || roles.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        return IbatisDAOUtil.wrappedPartitionQueryForSetMultimap(this._sqlMapper, "EntityMemberRole.findMemberIdsOfRoleByEntityTypesAndEntityIdSet", "entityId", "personId", entityIds, IbatisDAOUtil.createParameterFunctionForIdsWithMapData(ENTITIES, ImmutableMap.of((Object)"entityTypes", IbatisDAOUtil.toIbatisList(entityTypes), (Object)ROLES, IbatisDAOUtil.toIbatisList(roles))));
    }

    @CheckForNull
    private String convertSortingToParam(@Nullable EntitySortField.EntitySorting sorting) {
        if (sorting == null) {
            return null;
        }
        String sortDirection = sorting.isAsc() ? " ASC" : " DESC";
        switch (sorting.getSortField()) {
            case NAME: {
                return "name" + sortDirection;
            }
            case START_AT: {
                return "start_at" + sortDirection;
            }
        }
        throw new UnsupportedOperationException("All cases of EntitySorting must be handled. Unhandled case:" + sorting.getSortField());
    }

    @Override
    public int forAllEntityMemberRoles(Consumer<DBEntityMemberIdAndRole> consumer) {
        return ((IbatisStandardResultBuilder)this._ibatisBuilder.select("findAllEntityMemberRoles").noParam()).executeWithConsumer(consumer);
    }
}

