/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.integration.persistence.EntityMemberInvitationDAO;
import de.justsoftware.onx.container.integration.persistence.model.DBEntityMemberInvitation;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberInternalInvitation;
import de.justsoftware.onx.container.shared.model.EntityType;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Repository
public class IbatisEntityMemberInvitationDAO
implements EntityMemberInvitationDAO {
    private static final String NAMESPACE = "EntityMemberInvitation.";
    private final SqlMapClient _sqlMapper;
    private final TransactionHelper _transactionHelper;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisEntityMemberInvitationDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapClient, TransactionHelper transactionHelper) {
        this._sqlMapper = sqlMapClient;
        this._transactionHelper = transactionHelper;
    }

    @Override
    public EntityMemberInternalInvitation getInvitationById(EntityId entityId, PersonId personId) {
        DBEntityMemberInvitation dbModel = (DBEntityMemberInvitation)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "EntityMemberInvitation.getInternalInvitationById", ImmutableMap.of((Object)"personId", (Object)personId, (Object)"entityId", (Object)entityId));
        return dbModel != null ? IbatisEntityMemberInvitationDAO.convertInternalInvitation(dbModel) : null;
    }

    @CheckForNull
    private static EntityMemberInternalInvitation convertInternalInvitation(@Nullable DBEntityMemberInvitation invitation) {
        if (invitation == null) {
            return null;
        }
        return new EntityMemberInternalInvitation(invitation.getEntityId(), invitation.getPersonId(), invitation.getInviterId(), invitation.getInviteMessage(), invitation.getCreateDate());
    }

    @Override
    public ImmutableList<EntityMemberInternalInvitation> getInvitationsForUser(PersonId personId, ImmutableSet<EntityType> entityTypes) {
        if (CollectionUtil.isEmpty(entityTypes)) {
            return ImmutableList.of();
        }
        ImmutableList result = IbatisDAOUtil.wrappedQueryForImmutableList(this._sqlMapper, "EntityMemberInvitation.getInvitationsForUser", ImmutableMap.of((Object)"personId", (Object)personId, (Object)"entityTypes", (Object)entityTypes.asList()));
        return (ImmutableList)result.stream().map(IbatisEntityMemberInvitationDAO::convertInternalInvitation).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void insertInvitation(EntityId entityId, PersonId personId, PersonId inviterId, String invitationMessage) {
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "EntityMemberInvitation.insertInternalInvitation", ImmutableMap.of((Object)"entityId", (Object)entityId, (Object)"personId", (Object)personId, (Object)"inviterId", (Object)inviterId, (Object)"message", (Object)invitationMessage));
    }

    @Override
    public void deleteInvitation(EntityId entityId, PersonId personId) {
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "EntityMemberInvitation.deleteInternalInvitation", ImmutableMap.of((Object)"entityId", (Object)entityId, (Object)"personId", (Object)personId));
    }

    @Override
    public void updateInvitation(final EntityId entityId, final PersonId personId, final PersonId inviterId, final String invitationMessage) {
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionstatus) {
                IbatisEntityMemberInvitationDAO.this.deleteInvitation(entityId, personId);
                IbatisEntityMemberInvitationDAO.this.insertInvitation(entityId, personId, inviterId, invitationMessage);
            }
        });
    }
}

