/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.integration.persistence.EntityDAO;
import de.justsoftware.onx.container.server.model.DBPrivacySelection;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityComponent;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.container.shared.model.db.DBEntityLinkedEntityPrivacy;
import de.justsoftware.onx.like.shared.model.SubscriptionType;
import de.justsoftware.onx.news.migration.channel.ChannelMigrationDAO;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.toolbox.clock.Clock;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Repository
public class IbatisEntityDAO
implements EntityDAO,
ChannelMigrationDAO {
    private static final Logger LOG = LoggerFactory.getLogger(IbatisEntityDAO.class);
    private static final String NAMESPACE = "Entity.";
    private final SqlMapClient _sqlMapper;
    private final TransactionHelper _transactionHelper;
    private final IbatisStatementBuilder _ibatisBuilder;
    private final Clock _clock;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisEntityDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapClient, TransactionHelper transactionHelper, Clock clock, StatementBuilderFactory statementBuilderFactory) {
        this._sqlMapper = sqlMapClient;
        this._transactionHelper = transactionHelper;
        this._ibatisBuilder = statementBuilderFactory.ibatistStatementBuilder("Entity");
        this._clock = clock;
    }

    @Override
    public ImmutableMap<EntityId, DBEntity> getEntitiesByIds(Set<EntityId> ids) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getEntityByIds").partition(ids)).asMap("id", null);
    }

    @Override
    public DBEntity getEntityById(EntityId id) {
        return (DBEntity)this.getEntitiesByIds((Set<EntityId>)ImmutableSet.of((Object)id)).get((Object)id);
    }

    @Override
    public ImmutableMap<EntityId, SubscriptionType> getEntitySubscriptionsByTenantId(TenantId tenantId) {
        return this._ibatisBuilder.select("getEntitySubscriptionsByTenantId").param(tenantId).asMap("entity_id", "tenant_subscription_type");
    }

    @Override
    public void deleteEntities(final Set<EntityId> ids) {
        if (ids.isEmpty()) {
            return;
        }
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionstatus) {
                IbatisEntityDAO.this._ibatisBuilder.batch(s -> ids.stream().forEach(id -> IbatisEntityDAO.this._ibatisBuilder.delete("deleteEntity").param(id)));
            }
        });
    }

    @Override
    public void insertEntity(final DBEntity entity) throws ServiceException {
        if (entity.getId() != null) {
            throw new ServiceException("The entity you want to insert into the database already has an entity id");
        }
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionstatus) {
                entity.setCreateDate(IbatisEntityDAO.this._clock.nowDate());
                entity.setModifyDate(IbatisEntityDAO.this._clock.nowDate());
                IbatisDAOUtil.wrappedInsert(IbatisEntityDAO.this._sqlMapper, "Entity.insertEntity", entity);
                EntityId id = entity.getId();
                if (id == null) {
                    throw new ServiceException("Failed to insert the Entity. No Entity Id returned.");
                }
                List<DBEntityLink> linkedEntities = entity.getLinkedEntities();
                if (CollectionUtils.isNotEmpty(linkedEntities)) {
                    IbatisDAOUtil.wrappedInsert(IbatisEntityDAO.this._sqlMapper, "Entity.insertLinkedEntities", ImmutableMap.of((Object)"entityLinks", linkedEntities, (Object)"entityId", (Object)id));
                }
            }
        });
    }

    @Override
    public void updateEntity(final DBEntity entity) {
        final EntityId id = entity.getId();
        if (id == null) {
            throw new ServiceException("The entity you want to update does not have an entity id");
        }
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionstatus) {
                DBEntity oldEntity = IbatisEntityDAO.this.getEntityById(id);
                if (oldEntity == null) {
                    throw new ServiceException("Failed to insert the Entity. No old Entity returned.");
                }
                entity.setModifyDate(IbatisEntityDAO.this._clock.nowDate());
                IbatisEntityDAO.this._ibatisBuilder.update("updateEntity").param(entity);
                IbatisEntityDAO.this._ibatisBuilder.delete("deleteLinkedEntities").param(id);
                List<DBEntityLink> linkedEntities = entity.getLinkedEntities();
                if (!CollectionUtils.isEmpty(linkedEntities)) {
                    IbatisEntityDAO.this._ibatisBuilder.insert("insertLinkedEntities").param("entityLinks", linkedEntities, "entityId", id);
                }
            }
        });
    }

    @Override
    public void saveEntityPrivacies(EntityId entityId, List<DBPrivacySelection> privacies) {
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "Entity.dropEntityPrivacies", entityId);
        if (!CollectionUtil.isEmpty(privacies)) {
            IbatisDAOUtil.wrappedInsert(this._sqlMapper, "Entity.insertEntityPrivacies", ImmutableMap.of((Object)"entityId", (Object)entityId, (Object)"privacies", privacies));
        }
    }

    @Override
    public List<DBPrivacySelection> getEntityPrivacies(Set<? extends EntityId> entityIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForImmutableList(this._sqlMapper, "Entity.getEntityPrivacies", entityIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableTable<EntityId, ComponentType, DBEntityComponent> getComponentsByEntityIds(Set<EntityId> entityIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForTable(this._sqlMapper, "Entity.getComponentsByEntityIds", "parentId", "componentType", entityIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void addComponentToEntities(Iterable<DBEntityComponent> componentsToCreate) {
        ImmutableSet set = FluentIterable.from(componentsToCreate).transform((Function)new NullPermeableFunction<DBEntityComponent, Map<String, ?>>(){

            @Override
            protected Map<String, ?> applySafe(DBEntityComponent input) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                String customizedTitle = input.getCustomizedTitle();
                if (customizedTitle != null) {
                    builder.put((Object)"customizedTitle", (Object)customizedTitle);
                }
                return builder.put((Object)"entityId", (Object)input.getParentId()).put((Object)"componentType", (Object)input.getComponentType().getSqlString()).put((Object)"position", (Object)input.getPosition()).put((Object)"visible", (Object)input.isVisible()).put((Object)"order", (Object)input.getOrder()).build();
            }
        }).toSet();
        this._ibatisBuilder.insert("addComponentToEntities").partition(set);
        this.replaceComponentOpenFors(componentsToCreate);
    }

    @Override
    public void updateComponentPosition(DBEntityComponent dbc) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "Entity.updateComponentPosition", dbc);
        this.replaceComponentOpenFors((Iterable<DBEntityComponent>)ImmutableList.of((Object)dbc));
    }

    private void replaceComponentOpenFors(@Nonnull Iterable<DBEntityComponent> dbcs) {
        ImmutableSet dropSet = FluentIterable.from(dbcs).transform((Function)new NullPermeableFunction<DBEntityComponent, Map<String, ?>>(){

            @Override
            protected Map<String, ?> applySafe(DBEntityComponent input) {
                return ImmutableMap.of((Object)"entityId", (Object)input.getParentId(), (Object)"componentType", (Object)input.getComponentType().getSqlString());
            }
        }).toSet();
        this._ibatisBuilder.delete("dropComponentOpenFor").partition(dropSet);
        ImmutableSet set = FluentIterable.from(dbcs).transformAndConcat((Function)new NullPermeableFunction<DBEntityComponent, Iterable<Map<String, ?>>>(){

            @Override
            protected Iterable<Map<String, ?>> applySafe(final DBEntityComponent input) {
                return FluentIterable.from(input.getOpenForAuthNames()).transform((Function)new NullPermeableFunction<String, Map<String, ?>>(){

                    @Override
                    protected Map<String, ?> applySafe(String role) {
                        return ImmutableMap.of((Object)"entityId", (Object)input.getParentId(), (Object)"componentType", (Object)input.getComponentType().getSqlString(), (Object)"openFor", (Object)role);
                    }
                });
            }
        }).toSet();
        this._ibatisBuilder.insert("insertComponentOpenFor").partition(set);
    }

    @Override
    public ImmutableListMultimap<EntityId, DBEntityLinkedEntityPrivacy> getEntityLinkedEntityPrivacyByEntityIds(Set<? extends EntityId> entityIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForMultimap(this._sqlMapper, "Entity.getEntityLinkedEntityPrivacyByEntityIds", "entityId", entityIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void saveEntityLinkedEntityPrivacy(final EntityId entityId, List<DBEntityLinkedEntityPrivacy> privacyData) {
        final Iterable toInsert = Iterables.filter(privacyData, (Predicate)new Predicate<DBEntityLinkedEntityPrivacy>(){

            public boolean apply(@Nullable DBEntityLinkedEntityPrivacy input) {
                return input != null && CollectionUtils.isNotEmpty(input.getSelectedAuthorityNames());
            }
        });
        if (Iterables.isEmpty((Iterable)toInsert)) {
            IbatisDAOUtil.wrappedDelete(this._sqlMapper, "Entity.deleteEntityLinkedEntityPrivacyByEntityId", entityId);
            return;
        }
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionstatus) {
                IbatisDAOUtil.wrappedDelete(IbatisEntityDAO.this._sqlMapper, "Entity.deleteEntityLinkedEntityPrivacyByEntityId", entityId);
                ImmutableMap params = ImmutableMap.of((Object)"entityPrivacy", IbatisDAOUtil.toIbatisList(toInsert), (Object)"entityId", (Object)entityId);
                IbatisDAOUtil.wrappedInsert(IbatisEntityDAO.this._sqlMapper, "Entity.insertEntityLinkedEntityPrivacy", params);
            }
        });
    }

    @Override
    public ImmutableSet<EntityId> getEntityIdsByType(EntityType type) {
        return this._ibatisBuilder.select("getEntityIdsByType").param(type).asSet();
    }

    @Override
    public ImmutableSet<EntityId> getChildEntityIds(EntityId parentEntityId) {
        return IbatisDAOUtil.wrappedQueryForImmutableSet(this._sqlMapper, "Entity.getChildEntityIds", parentEntityId);
    }

    @Override
    public ImmutableListMultimap<EntityId, DBEntityLink> getDirectChildEntities(Set<EntityId> parentEntityIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getDirectChildEntities").partition(parentEntityIds)).asListMultimap("linkedEntityId", null);
    }

    @Override
    public List<EntityId> getEntityOfType(EntityType type, int offset, int limit) throws ServiceException {
        return IbatisDAOUtil.wrappedQueryForList(this._sqlMapper, "Entity.getEntityTeaserOfType", ImmutableMap.of((Object)"entityType", (Object)type, (Object)"offset", (Object)offset, (Object)"limit", (Object)limit));
    }

    @Override
    public EntityId getEntityIdByNameAndType(String entityName, EntityType entityType) {
        return (EntityId)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "Entity.getEntityIdByNameAndType", ImmutableMap.of((Object)"name", (Object)entityName, (Object)"type", (Object)entityType));
    }

    @Override
    public void synchronizeEntityTypes(Iterable<? extends EntityType> entityTypes) {
        final ImmutableList ibatisEntityTypes = ImmutableSet.copyOf(entityTypes).asList();
        if (ibatisEntityTypes.isEmpty()) {
            throw new DAOException("No EntityTypes defined!");
        }
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    IbatisEntityDAO.this._sqlMapper.startBatch();
                    IbatisEntityDAO.this._sqlMapper.delete("Entity.synchronizeEntityTypesDelete", (Object)ibatisEntityTypes);
                    IbatisEntityDAO.this._sqlMapper.insert("Entity.synchronizeEntityTypesInsert", (Object)ibatisEntityTypes);
                    IbatisEntityDAO.this._sqlMapper.executeBatch();
                }
                catch (SQLException e) {
                    LOG.error("Unable to sync configuration with database, you have to clean up database before changing the configuration!", (Throwable)e);
                    throw new DAOException("You can not delete an entity type which is still in use. Allowed types are: " + ibatisEntityTypes);
                }
            }
        });
    }

    @Override
    public ImmutableSetMultimap<EntityType, EntityId> getIdsByTypes(Iterable<EntityType> types) {
        if (CollectionUtil.isEmpty(types)) {
            return ImmutableSetMultimap.of();
        }
        return IbatisDAOUtil.wrappedQueryForSetMultiMap(this._sqlMapper, "Entity.getIdsByTypes", "entity_type", "id", (Object)ImmutableSet.copyOf(types).asList());
    }

    @Override
    public void updateEntityModifyDate(EntityId entityId, DateTime newModifyDate) {
        this._ibatisBuilder.update("updateEntityModifyDate").param("id", entityId, "modifyDate", newModifyDate);
    }

    @Override
    public void updateEntityDescription(EntityId entityId, String description, DateTime newModifyDate) {
        this._ibatisBuilder.update("updateEntityDescription").param("id", entityId, "description", description, "modifyDate", newModifyDate);
    }

    @Override
    public ImmutableSetMultimap<EntityId, EntityId> getInheritingChildEntities(ImmutableSet<EntityId> parentEntities, ImmutableSet<EntityType> resultTypes, InheritsRole role) {
        if (parentEntities.isEmpty() || resultTypes.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        ImmutableMap params = ImmutableMap.of((Object)"resultTypes", IbatisDAOUtil.toIbatisList(resultTypes), (Object)"inherit", (Object)role.name());
        Function paramFunction = IbatisDAOUtil.createParameterFunctionForIdsWithMapData("parentIds", params);
        return ((IbatisResultBuilder)this._ibatisBuilder.selectDbSpecific("getInheritingEntityChildrenByParentIds").partition((Set)parentEntities, paramFunction)).asSetMultimap("parent_id", "child_id");
    }

    @Override
    public Map<EntityId, Integer> getParticipantsCount(Set<EntityId> entities) {
        if (CollectionUtil.isEmpty(entities)) {
            return ImmutableMap.of();
        }
        return IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapper, "Entity.getParticipantsCount", "entity_id", "participant_count", entities, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void assignEntities(Set<EntityId> entityIds, PersonId assignee, DateTime modifyDate) {
        this._ibatisBuilder.update("assignEntities").partition("entityIds", entityIds, "assignee", assignee, "modifyDate", modifyDate);
    }

    @Override
    public void unassignEntities(Set<EntityId> entityIds, DateTime modifyDate) {
        this._ibatisBuilder.update("unassignEntities").partition("entityIds", entityIds, "modifyDate", modifyDate);
    }

    @Override
    public void setDefaultNavigation(EntityId entityId, boolean defaultNavigation, DateTime modifyDate) {
        this._ibatisBuilder.update("setDefaultNavigation").param("entityId", entityId, "defaultNavigation", defaultNavigation, "modifyDate", modifyDate);
    }

    @Override
    public int forAllAssignedEntities(BiConsumer<EntityId, PersonId> handler) {
        return ((IbatisStandardResultBuilder)this._ibatisBuilder.select("getAllAssignedEntities").noParam()).executeWithBiConsumer("entityId", "assigneeId", (entityId, assigneeId) -> {
            if (entityId != null && assigneeId != null) {
                handler.accept((EntityId)entityId, (PersonId)assigneeId);
            }
        });
    }

    @Override
    public void updateLastDriveChangeVersion(EntityId entityId, int newLastDriveChangeVersion) {
        this._ibatisBuilder.update("updateLastDriveChange").param("entityId", entityId, "newLastDriveChangeVersion", newLastDriveChangeVersion);
    }

    @Override
    public void forAllEntityIds(Consumer<EntityId> consumer) {
        ((IbatisStandardResultBuilder)this._ibatisBuilder.select("getAllEntityIds").noParam()).executeWithConsumer(consumer);
    }

    @Override
    public int forAllEntities(EntityDAO.EntityConsumer consumer) {
        return ((IbatisStandardResultBuilder)this._ibatisBuilder.select("getAllEntities").noParam()).executeWithConsumer(o -> consumer.accept((EntityId)IbatisDAOUtil.probe(o, "id"), (String)IbatisDAOUtil.probe(o, "name"), (EntityType)IbatisDAOUtil.probe(o, "type"), (PersonId)IbatisDAOUtil.probe(o, "admin")));
    }

    @Override
    public ImmutableMap<EntityId, DBEntity> getAllChannels() {
        return ((IbatisStandardResultBuilder)this._ibatisBuilder.select("getAllChannels").noParam()).asMap("id", null);
    }

    @Override
    public ImmutableSet<PersonId> getAllChannelAdmins(EntityId channelId) {
        return this._ibatisBuilder.select("getAllChannelsAdmins").param(channelId).asSet();
    }

    public ImmutableSet<EntityId> getAllForTenant(TenantId tenantId) {
        return this._ibatisBuilder.select("getAllEntityIdsForTenant").param(tenantId).asSet();
    }

    @Override
    public ImmutableSet<PersonId> getAllChannelMembers(EntityId channelId) {
        return this._ibatisBuilder.select("getAllChannelMembers").param(channelId).asSet();
    }
}

