/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.util.RelationUtil;
import de.justsoftware.onx.container.integration.persistence.EntityChildrenDAO;
import de.justsoftware.onx.container.integration.persistence.model.ParentChildEntityType;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class IbatisEntityChildrenDAO
implements EntityChildrenDAO {
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisEntityChildrenDAO(StatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("EntityChildren");
    }

    @Override
    public ImmutableSetMultimap<EntityId, EntityId> getEntityChildren(Set<EntityId> parentIds) {
        return RelationUtil.loadTransitiveRelations(parentIds, new NullPermeableFunction<Set<EntityId>, ImmutableSetMultimap<EntityId, EntityId>>(){

            @Override
            protected ImmutableSetMultimap<EntityId, EntityId> applySafe(Set<EntityId> input) {
                return ((IbatisPartitionResultBuilder)IbatisEntityChildrenDAO.this._statementBuilder.select("getEntityChildrenByParentIds").partition(input)).asSetMultimap("parent_id", "child_id");
            }
        });
    }

    @Override
    public ImmutableSetMultimap<EntityId, EntityId> getInheritedEntityChildren(ImmutableSet<EntityId> parentIds, Collection<ParentChildEntityType> allowedParentChildEntityTypes, ImmutableSet<EntityType> childTypes, InheritsRole inheritsRole) {
        if (allowedParentChildEntityTypes.isEmpty() || childTypes != null && childTypes.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        ImmutableMap.Builder parameterMapBuilder = ImmutableMap.builder().put((Object)"inheritsAdmin", (Object)InheritsRole.INHERIT_ADMINS.equals(inheritsRole)).put((Object)"allowedChildTypes", IbatisDAOUtil.toIbatisList(allowedParentChildEntityTypes));
        if (childTypes != null) {
            parameterMapBuilder.put((Object)"resultChildTypes", IbatisDAOUtil.toIbatisList(childTypes));
        }
        final ImmutableMap parameterMap = parameterMapBuilder.build();
        return RelationUtil.loadTransitiveRelations(parentIds, new NullPermeableFunction<Set<EntityId>, ImmutableSetMultimap<EntityId, EntityId>>(){

            @Override
            protected ImmutableSetMultimap<EntityId, EntityId> applySafe(Set<EntityId> input) {
                return ((IbatisPartitionResultBuilder)IbatisEntityChildrenDAO.this._statementBuilder.select("getInheritedEntityChildren").partition("parentIds", input, (Map<String, ?>)parameterMap)).asSetMultimap("parent_id", "child_id");
            }
        });
    }

    @Override
    public ImmutableSetMultimap<EntityId, EntityId> getAllEntityParents(Set<EntityId> childIds) {
        return RelationUtil.loadTransitiveRelations(childIds, new NullPermeableFunction<Set<EntityId>, ImmutableSetMultimap<EntityId, EntityId>>(){

            @Override
            protected ImmutableSetMultimap<EntityId, EntityId> applySafe(Set<EntityId> input) {
                return ((IbatisPartitionResultBuilder)IbatisEntityChildrenDAO.this._statementBuilder.select("getDirectEntityParents").partition(input)).asSetMultimap("child_id", "parent_id");
            }
        });
    }
}

