/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionReviewStatus;
import de.justsoftware.onx.container.shared.model.db.DBEntityVersionReview;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface EntityVersionReviewDAO {
    public void createReview(DBEntityVersionReview var1);

    @Nonnull
    public ImmutableListMultimap<EntityVersionId, DBEntityVersionReview> getReviewsForVersions(Set<EntityVersionId> var1);

    @CheckForNull
    public DBEntityVersionReview getNextReviewWithStatus(EntityVersionId var1, EntityVersionReviewStatus var2);

    @CheckForNull
    public DBEntityVersionReview getReviewFromPerson(EntityVersionId var1, PersonId var2);

    public void updateReviewStatus(EntityVersionId var1, PersonId var2, EntityVersionReviewStatus var3);

    @Nonnull
    public ListAndCount<DBEntityVersionReview> getInReviewForPerson(int var1, int var2, PersonId var3);

    public int getInReviewForPersonCount(PersonId var1);

    public void deleteVersionsByEntityId(EntityId var1);

    @Nonnull
    public ImmutableSetMultimap<EntityId, PersonId> getEntityVersionReviewer(Set<EntityId> var1, Set<EntityStatusId> var2);

    public int forAllReviewers(Set<EntityStatusId> var1, BiConsumer<EntityId, PersonId> var2);

    @Nonnull
    public ImmutableSetMultimap<EntityId, PersonId> getAllPossibleReviewers(Set<EntityId> var1);
}

