/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.IEntityVersion;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.container.shared.model.db.DBEntityVersion;
import java.util.Date;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public interface EntityVersionDAO {
    @Nonnull
    public ImmutableSet<EntityVersion> getVersionsByIds(@Nonnull Set<? extends EntityVersionId> var1);

    @Nonnull
    public ImmutableList<EntityVersion> getVersionsForEntity(@Nonnull EntityId var1, @Nonnull Iterable<EntityStatus> var2, int var3, int var4);

    @CheckForNull
    public EntityVersionId getLatestVersionByType(@Nonnull EntityId var1, @Nonnull EntityVersionType var2);

    public int countVersionsForEntity(@Nonnull EntityId var1, @Nonnull Iterable<EntityStatus> var2);

    @Nonnull
    public ListAndCount<EntityVersion> getDeclinedForPerson(int var1, int var2, @Nonnull PersonId var3);

    public void updateReadDateByEntityVersionId(@Nonnull EntityVersionId var1, @Nonnull DateWithoutTimezone var2);

    @Nonnull
    public EntityVersionId create(@Nonnull IEntityVersion var1);

    public void update(@Nonnull DBEntityVersion var1);

    public void updateForImport(@Nonnull DBEntityVersion var1);

    public void deleteVersion(@Nonnull EntityVersionId var1);

    public void deleteVersionsById(@Nonnull Set<EntityVersionId> var1);

    @Nonnull
    public ImmutableList<EntityVersion> getReleasedVersions(@Nonnull Date var1);

    @Nonnull
    public ImmutableList<EntityVersion> getPublishedVersionsWithExpirationDate(@Nonnull Date var1);

    @Nonnull
    public ImmutableList<EntityVersion> getPublishedVersionsWithExpirationDateBetween(@Nonnull Date var1, @Nonnull Date var2);

    public void updateStatusForEntityVersions(@Nonnull EntityId var1, @Nonnull Iterable<EntityStatus> var2, @Nonnull EntityStatus var3);

    public void updateStatus(@Nonnull EntityVersionId var1, @Nonnull EntityStatus var2);

    @Nonnull
    public ImmutableSet<EntityVersionId> getAllVersionsForEntity(@Nonnull EntityId var1);

    @Nonnull
    public ListAndCount<EntityId> getEntityDraftsForAuthor(int var1, int var2, @Nonnull PersonId var3);

    public int getDraftCountForAuthor(@Nonnull PersonId var1);

    @Nonnull
    public ImmutableSet<EntityVersion> getNewestVersionsForEntity(@Nonnull Set<? extends EntityId> var1);

    public void updateStatusOfVersionsWithStatus(@Nonnull Set<EntityStatusId> var1, @Nonnull EntityStatus var2);

    @Nonnull
    public ImmutableSet<EntityVersion> getNewestVersionsForEntityType(@Nonnull EntityType var1);

    @CheckForNull
    public EntityVersion getLastNonDraftVersionBefore(@Nonnull EntityVersionId var1);

    @CheckForNull
    public EntityVersionId getFirstVersionForEntity(@Nonnull EntityId var1);
}

