/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.server.model.DBPrivacySelection;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityComponent;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.container.shared.model.db.DBEntityLinkedEntityPrivacy;
import de.justsoftware.onx.like.shared.model.SubscriptionType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public interface EntityDAO {
    @CheckForNull
    public DBEntity getEntityById(EntityId var1);

    public ImmutableMap<EntityId, SubscriptionType> getEntitySubscriptionsByTenantId(TenantId var1);

    @Nonnull
    public ImmutableMap<EntityId, DBEntity> getEntitiesByIds(Set<EntityId> var1);

    public void insertEntity(DBEntity var1);

    default public void deleteEntity(EntityId id) {
        this.deleteEntities(Set.of(id));
    }

    public void deleteEntities(Set<EntityId> var1);

    public void updateEntity(DBEntity var1);

    @Nonnull
    public ImmutableTable<EntityId, ComponentType, DBEntityComponent> getComponentsByEntityIds(Set<EntityId> var1);

    public void addComponentToEntities(Iterable<DBEntityComponent> var1);

    public void updateComponentPosition(DBEntityComponent var1);

    public void saveEntityLinkedEntityPrivacy(EntityId var1, List<DBEntityLinkedEntityPrivacy> var2);

    @Nonnull
    public ImmutableListMultimap<EntityId, DBEntityLinkedEntityPrivacy> getEntityLinkedEntityPrivacyByEntityIds(Set<? extends EntityId> var1);

    @Nonnull
    public ImmutableSet<EntityId> getEntityIdsByType(EntityType var1);

    @Nonnull
    public ImmutableSet<EntityId> getChildEntityIds(EntityId var1);

    @Nonnull
    public ImmutableListMultimap<EntityId, DBEntityLink> getDirectChildEntities(Set<EntityId> var1);

    @Nonnull
    public List<EntityId> getEntityOfType(EntityType var1, int var2, int var3);

    @CheckForNull
    public EntityId getEntityIdByNameAndType(String var1, EntityType var2);

    public void saveEntityPrivacies(EntityId var1, List<DBPrivacySelection> var2);

    @Nonnull
    public List<DBPrivacySelection> getEntityPrivacies(Set<? extends EntityId> var1);

    public void synchronizeEntityTypes(Iterable<? extends EntityType> var1);

    @Nonnull
    public ImmutableSetMultimap<EntityType, EntityId> getIdsByTypes(Iterable<EntityType> var1);

    public void updateEntityModifyDate(EntityId var1, DateTime var2);

    public void updateEntityDescription(EntityId var1, String var2, DateTime var3);

    @Nonnull
    public ImmutableSetMultimap<EntityId, EntityId> getInheritingChildEntities(ImmutableSet<EntityId> var1, ImmutableSet<EntityType> var2, InheritsRole var3);

    @Nonnull
    public Map<EntityId, Integer> getParticipantsCount(Set<EntityId> var1);

    public void assignEntities(Set<EntityId> var1, PersonId var2, DateTime var3);

    public void unassignEntities(Set<EntityId> var1, DateTime var2);

    public void setDefaultNavigation(EntityId var1, boolean var2, DateTime var3);

    public int forAllAssignedEntities(BiConsumer<EntityId, PersonId> var1);

    public void updateLastDriveChangeVersion(EntityId var1, int var2);

    public void forAllEntityIds(Consumer<EntityId> var1);

    public int forAllEntities(EntityConsumer var1);

    @Nonnull
    public Set<EntityId> getAllForTenant(TenantId var1);

    @FunctionalInterface
    @ParametersAreNonnullByDefault
    public static interface EntityConsumer {
        public void accept(EntityId var1, String var2, EntityType var3, PersonId var4);
    }
}

