/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.DriveChangeId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.drive.business.model.DriveChangePurpose;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class NewDriveChangeEntityVersionModel {
    private final EntityId _entityId;
    private final DriveChangeId _driveChangeId;
    private final int _version;
    private final PersonId _executedBy;
    private final DriveChangePurpose _purpose;
    private final DateTime _changeDate;

    public NewDriveChangeEntityVersionModel(EntityId entityId, DriveChangeId driveChangeId, PersonId executedBy, int version, @Nullable DriveChangePurpose purpose, @Nullable DateTime changeDate) {
        this._entityId = entityId;
        this._driveChangeId = driveChangeId;
        this._executedBy = executedBy;
        this._version = version;
        this._purpose = purpose;
        this._changeDate = changeDate;
    }

    public int getVersion() {
        return this._version;
    }

    @Nonnull
    public PersonId getExecutedBy() {
        return this._executedBy;
    }

    @Nonnull
    public DriveChangeId getDriveChangeId() {
        return this._driveChangeId;
    }

    @Nonnull
    public EntityId getEntityId() {
        return this._entityId;
    }

    @CheckForNull
    public DriveChangePurpose getPurpose() {
        return this._purpose;
    }

    @Nonnull
    public Optional<DateTime> getChangeDate() {
        return Optional.fromNullable((Object)this._changeDate);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityId", (Object)this._entityId).add("driveChangeId", (Object)this._driveChangeId).add("version", this._version).add("executedBy", (Object)this._executedBy).add("purpose", (Object)this._purpose).add("changeDate", (Object)this._changeDate).toString();
    }
}

