/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EventWaitlistService;
import de.justsoftware.onx.container.integration.persistence.EntityDAO;
import de.justsoftware.onx.container.integration.persistence.EntityWaitlistDAO;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service(value="eventWaitlistService")
public class EventWaitlistServiceImpl
implements EventWaitlistService {
    private final EntityWaitlistDAO _entityWaitlistDAO;
    private final EntityDAO _entityDAO;
    private final EntityService _entityService;

    @Autowired
    public EventWaitlistServiceImpl(EntityDAO entityDAO, EntityWaitlistDAO entityWaitlistDAO, EntityService entityService) {
        this._entityWaitlistDAO = entityWaitlistDAO;
        this._entityDAO = entityDAO;
        this._entityService = entityService;
    }

    @Override
    public void addToWaitlist(Set<EntityId> entities, PersonId personId) {
        this._entityWaitlistDAO.addToWaitlist(entities, personId);
    }

    @Override
    public void removeFromWaitlist(Set<EntityId> entities, PersonId personId) {
        this._entityWaitlistDAO.removeFromWaitlist(entities, personId);
    }

    @Override
    public int getFreeEntityParticipantSlots(DBEntity entity) {
        return Numbers.intValue((Number)this.getFreeEntityParticipantSlots((Map<EntityId, DBEntity>)ImmutableMap.of((Object)entity.getId(), (Object)entity)).get((Object)entity.getId()));
    }

    @Override
    public int getFreeEntityParticipantSlots(EntityId entityId) {
        DBEntity entity = this._entityService.getById(entityId);
        return this.getFreeEntityParticipantSlots(entity);
    }

    @Override
    public ImmutableMap<EntityId, Integer> getFreeEntityParticipantSlots(Map<EntityId, DBEntity> entities) {
        final Map<EntityId, Integer> participantsCounts = this._entityDAO.getParticipantsCount(entities.keySet());
        return ImmutableMap.copyOf((Map)Maps.transformValues(entities, (Function)new Function<DBEntity, Integer>(){

            public Integer apply(DBEntity input) {
                if (input == null) {
                    return -1;
                }
                int participantLimit = input.getParticipantLimit();
                if (participantLimit < 0) {
                    return participantLimit;
                }
                if (participantLimit == 0) {
                    return 0;
                }
                int participantCount = Numbers.intValue((Number)participantsCounts.get(input.getId()), 0);
                return Math.max(participantLimit - participantCount, 0);
            }
        }));
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getParticipantsFromWaitlist(Set<EntityId> entityIds) {
        return this._entityWaitlistDAO.getParticipantsFromWaitlist(entityIds);
    }
}

