/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import de.justsoftware.onx.analytics.business.AnalyticsService;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
@ParametersAreNonnullByDefault
public class EntityViewCountConsumerImpl
extends AbstractKafkaConsumer<String, String> {
    @VisibleForTesting
    static final String TOPIC = "tracking";
    private static final Pattern ENTITY_TOKEN_PATTERN = Pattern.compile("^(?:#)?(?:/)?(?:!)?entity\\.(\\d+)(#.*)?$");
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityViewCountConsumerImpl.class);
    private final AnalyticsService _analyticsService;

    @Autowired
    public EntityViewCountConsumerImpl(AnalyticsService analyticsService, TransactionHelper transactionHelper, KafkaConfigurationProvider kafkaConfigurationProvider) {
        this(kafkaConfigurationProvider.stringConsumer("just.toro.EntityViewCountConsumer"), analyticsService, transactionHelper);
    }

    @VisibleForTesting
    EntityViewCountConsumerImpl(@Nullable Consumer<String, String> consumer, AnalyticsService analyticsService, TransactionHelper transactionHelper) {
        super(consumer, transactionHelper, TOPIC);
        this._analyticsService = analyticsService;
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) {
        ImmutableMultiset.Builder entityIds = ImmutableMultiset.builder();
        for (ConsumerRecord record : records) {
            EntityId entityId = this.parseEntity((ConsumerRecord<String, String>)record);
            if (entityId == null) continue;
            LOGGER.debug("Tracking Entity ID view: " + entityId);
            entityIds.add((Object)entityId);
        }
        this._analyticsService.increaseViewCounters((Multiset<? extends ItemId>)entityIds.build());
    }

    @CheckForNull
    private EntityId parseEntity(ConsumerRecord<String, String> record) {
        try {
            JsonNode value = this.parseJson((String)record.value());
            if (value == null || !value.isObject()) {
                return null;
            }
            JsonNode targetNode = value.path("target");
            String hash = targetNode.path("hash").asText();
            String trackingType = targetNode.path("type").asText();
            if (hash == null || trackingType == null || !"PAGE_VIEW".equals(trackingType)) {
                return null;
            }
            Matcher matcher = ENTITY_TOKEN_PATTERN.matcher(hash);
            if (!matcher.matches()) {
                return null;
            }
            return new EntityId(Long.parseLong(matcher.group(1)));
        }
        catch (RuntimeException e) {
            LOGGER.warn("exception during parsing JSON, ignoring record " + record, (Throwable)e);
            return null;
        }
    }

    @Override
    protected Logger getLog() {
        return LOGGER;
    }
}

