/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.BasePersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.PersonIndependentAuthorizationContext;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.EntityVersionReviewerConfig;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.attributes.Range;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.EntityVersionValidationService;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.server.model.validation.validator.AbstractServerValidator;
import de.justsoftware.onx.container.shared.i18n.EntityVersionConstants;
import de.justsoftware.onx.container.shared.model.EntityVersionReleaseDataOption;
import de.justsoftware.onx.container.shared.model.EntityVersionReviewData;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.EntityVersionReleaseData;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.ConstraintValidatorContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityVersionValidationServiceImpl
extends AbstractServerValidator
implements EntityVersionValidationService {
    private static final long ONE_DAY_MILLIS = TimeUnit.DAYS.toMillis(1L);
    private static final String RELEASE_DATE_FIELD = "releaseDate";
    private static final String EXPIRATION_DATE_FIELD = "expirationDate";
    private static final String REVIEWER_FIELD = "reviewer";
    private static final String DECLINE_MESSAGE_FIELD = "declineMessage";
    private static final String CHANGE_MESSAGE_FIELD = "changeMessage";
    private static final String COMMENT_FOR_REVIEWER_FIELD = "commentForReviewer";
    @Autowired
    private EntityConfigService _entityConfigService;
    @Autowired
    private EntityService _entityService;
    @Autowired
    private EntityVersionService _entityVersionService;
    @Autowired
    private AuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private PersonService _personService;
    @Autowired
    private Clock _clock;

    @Override
    public boolean isValidReleaseData(EntityVersionReleaseData releaseData, ConstraintValidatorContext context) {
        if (releaseData == null) {
            return false;
        }
        EntityVersion version = this._entityVersionService.getVersionByIdNonNull(releaseData.getVersionId());
        DBEntity entity = this._entityService.getByIdNotNull(version.getEntityId());
        EntityVersionType typeToRelease = releaseData.getVersionType();
        EntityVersionReleaseDataOption versionTypeVisibility = this._entityConfigService.getReleaseVersionTypeVisibility(entity.getType());
        if (versionTypeVisibility == EntityVersionReleaseDataOption.NOT_VISIBLE && typeToRelease != EntityVersionType.MAJOR) {
            return false;
        }
        switch (typeToRelease) {
            case DRAFT: {
                return false;
            }
            case MINOR: 
            case MAJOR: {
                return this.validatePublicVersion(releaseData, context);
            }
        }
        return false;
    }

    @Override
    public boolean isValidReviewData(EntityVersionReviewData data, ConstraintValidatorContext context) {
        boolean result;
        boolean bl = result = data != null;
        if (result) {
            EntityVersionConstants validationMessages = this.getValidationMessages();
            boolean datesValid = this.validateVersionDates(data, context, validationMessages);
            boolean declineMessageValid = this.validateDeclineMessageLength(data, validationMessages, context);
            result &= declineMessageValid && datesValid;
        }
        return result;
    }

    @Override
    public boolean isValidReviewDataForAccept(EntityVersionReviewData data, ConstraintValidatorContext context) {
        boolean result;
        boolean bl = result = data != null;
        if (result) {
            EntityVersionConstants validationMessages = this.getValidationMessages();
            result = this.validateVersionDates(data, context, validationMessages);
        }
        return result;
    }

    @Override
    public boolean isValidReviewDataForDecline(EntityVersionReviewData data, ConstraintValidatorContext context) {
        boolean result;
        boolean bl = result = data != null;
        if (result) {
            EntityVersionConstants validationMessages = this.getValidationMessages();
            boolean declineMessagePresent = this.validateDeclineMessagePresent(data, validationMessages, context);
            boolean declineMessageValid = this.validateDeclineMessageLength(data, validationMessages, context);
            result &= declineMessagePresent && declineMessageValid;
        }
        return result;
    }

    private boolean validatePublicVersion(@Nonnull EntityVersionReleaseData releaseData, @Nonnull ConstraintValidatorContext context) {
        EntityVersion version = this._entityVersionService.getVersionByIdNonNull(releaseData.getVersionId());
        DBEntity entity = this._entityService.getByIdNotNull(version.getEntityId());
        EntityVersionType typeToRelease = releaseData.getVersionType();
        int maxDaysAsActiveVersion = this._entityConfigService.maxDaysAsActiveVersion(entity.getType());
        boolean releaseExpirationDayMandatory = this._entityConfigService.getReleaseExpirationDateVisibility(entity.getType()) == EntityVersionReleaseDataOption.MANDATORY;
        EntityVersionReleaseDataOption changeMessageConfig = this._entityConfigService.getReleaseChangeMessageVisibility(entity.getType());
        EntityVersionConstants validationMessages = this.getValidationMessages();
        boolean isValid = this.validateVersionDates(releaseData.getReleaseDate(), releaseData.getExpirationDate(), releaseExpirationDayMandatory, maxDaysAsActiveVersion, validationMessages, context);
        isValid = this.validateChangeMessage(releaseData.getChangeMessage(), changeMessageConfig, validationMessages, context) && isValid;
        switch (typeToRelease) {
            case MAJOR: {
                return this.validateMajorVersion(entity, releaseData, context) && isValid;
            }
            case MINOR: {
                return isValid;
            }
            case DRAFT: {
                return false;
            }
        }
        return false;
    }

    private boolean validateChangeMessage(@Nullable String changeMessage, @Nonnull EntityVersionReleaseDataOption changeMessageConfig, @Nonnull EntityVersionConstants messages, @Nonnull ConstraintValidatorContext context) {
        if (changeMessageConfig == EntityVersionReleaseDataOption.MANDATORY) {
            if (changeMessage == null) {
                this.addViolation(CHANGE_MESSAGE_FIELD, messages.changeMessageMandatory(), context);
                return false;
            }
            if (!this.validateChangeMessageLength(changeMessage, messages, context)) {
                return false;
            }
        }
        if (changeMessageConfig == EntityVersionReleaseDataOption.VISIBLE && changeMessage != null && !this.validateChangeMessageLength(changeMessage, messages, context)) {
            return false;
        }
        if (changeMessageConfig == EntityVersionReleaseDataOption.NOT_VISIBLE && changeMessage != null) {
            this.addViolation(CHANGE_MESSAGE_FIELD, messages.invisibleChangeMessageMustBeNull(), context);
            return false;
        }
        return true;
    }

    private boolean validateChangeMessageLength(@Nonnull String message, @Nonnull EntityVersionConstants messages, @Nonnull ConstraintValidatorContext context) {
        boolean result;
        int length = message.trim().length();
        boolean bl = result = length <= 500;
        if (!result) {
            this.addViolation(CHANGE_MESSAGE_FIELD, messages.changeMessageRange(500), context);
        }
        return result;
    }

    private boolean validateCommentForReviewer(@Nullable String comment, @Nonnull EntityVersionReleaseDataOption commentForReviewerConfig, @Nonnull EntityVersionConstants messages, @Nonnull ConstraintValidatorContext context) {
        if (commentForReviewerConfig == EntityVersionReleaseDataOption.MANDATORY) {
            if (comment == null) {
                this.addViolation(COMMENT_FOR_REVIEWER_FIELD, messages.commentForReviewerMandatory(), context);
                return false;
            }
            if (!this.validateCommentForReviewerLength(comment)) {
                this.addViolation(COMMENT_FOR_REVIEWER_FIELD, messages.commentForReviewerMaxSize(), context);
                return false;
            }
        }
        if (commentForReviewerConfig == EntityVersionReleaseDataOption.VISIBLE && comment != null && !this.validateCommentForReviewerLength(comment)) {
            this.addViolation(COMMENT_FOR_REVIEWER_FIELD, messages.commentForReviewerMaxSize(), context);
            return false;
        }
        if (commentForReviewerConfig == EntityVersionReleaseDataOption.NOT_VISIBLE && comment != null) {
            this.addViolation(COMMENT_FOR_REVIEWER_FIELD, messages.invisibleCommentForReviewerMustBeNull(), context);
            return false;
        }
        return true;
    }

    private boolean validateCommentForReviewerLength(@Nonnull String comment) {
        return comment.trim().length() <= 250;
    }

    private boolean validateMajorVersion(@Nonnull DBEntity entity, @Nonnull EntityVersionReleaseData releaseData, @Nonnull ConstraintValidatorContext context) {
        if (!this._entityConfigService.isReviewMandatoryForRelease(entity.getType())) {
            return true;
        }
        EntityVersionReleaseDataOption commentForReviewerConfig = this._entityConfigService.getReleaseCommentForReviewerVisibility(entity.getType());
        if (!this.validateCommentForReviewer(releaseData.getCommentForReviewer(), commentForReviewerConfig, this.getValidationMessages(), context)) {
            return false;
        }
        List<PersonId> reviewerList = releaseData.getReviewer();
        if (!this.validateReviewerSelection(reviewerList, entity, context)) {
            context.disableDefaultConstraintViolation();
            return false;
        }
        return true;
    }

    private boolean validateReviewerSelection(@Nonnull List<PersonId> reviewerList, @Nonnull DBEntity entity, @Nonnull ConstraintValidatorContext context) {
        EntityVersionConstants messages = this.getValidationMessages();
        EntityVersionReviewerConfig reviewerConfig = this._entityConfigService.getVersionReleaseReviewerConfig(entity.getType());
        Range range = reviewerConfig.getReviewerRange();
        int rangeMin = range.getMin().intValue();
        Long max = range.getMax();
        boolean result = true;
        if (reviewerList.isEmpty()) {
            this.addViolation(REVIEWER_FIELD, messages.noReviewerSelected(), context);
            return false;
        }
        if (max != null && reviewerList.size() > max.intValue()) {
            return false;
        }
        HashSet<PersonId> idSet = new HashSet<PersonId>();
        for (int reviewStage = 0; reviewStage < reviewerList.size(); ++reviewStage) {
            PersonId reviewerId = reviewerList.get(reviewStage);
            if (reviewerId != null) {
                boolean isValidReviewer = this.isValidReviewerForReviewStage(entity, reviewerId, reviewStage, reviewerConfig);
                if (!isValidReviewer) {
                    context.buildConstraintViolationWithTemplate(messages.reviewerInvalid()).addPropertyNode(REVIEWER_FIELD).addPropertyNode("personId").inIterable().atIndex(Integer.valueOf(reviewStage)).addConstraintViolation();
                    result = false;
                }
                if (idSet.add(reviewerId)) continue;
                context.buildConstraintViolationWithTemplate(messages.reviewerIsAlreadyAssigned()).addPropertyNode(REVIEWER_FIELD).addPropertyNode("personId").inIterable().atIndex(Integer.valueOf(reviewStage)).addConstraintViolation();
                result = false;
                continue;
            }
            if (reviewStage < rangeMin) {
                context.buildConstraintViolationWithTemplate(messages.selectReviewer()).addPropertyNode(REVIEWER_FIELD).addPropertyNode("personId").inIterable().atIndex(Integer.valueOf(reviewStage)).addConstraintViolation();
            } else {
                context.buildConstraintViolationWithTemplate(messages.removeOrSelectReviewer()).addPropertyNode(REVIEWER_FIELD).addPropertyNode("personId").inIterable().atIndex(Integer.valueOf(reviewStage)).addConstraintViolation();
            }
            result = false;
        }
        return result;
    }

    @Override
    public boolean isValidReviewerForReviewStage(DBEntity entity, PersonId reviewerId, int reviewStage, EntityVersionReviewerConfig reviewerConfig) {
        if (reviewerId == null) {
            return false;
        }
        DBPerson reviewer = this._personService.getPersonById(reviewerId);
        if (reviewer == null) {
            return false;
        }
        PersonIndependentAuthorizationContext personIndependentAuthorizationContext = this._authorizationContextProvider.getPersonIndependentAuthorizationContext();
        if (reviewerConfig.hasPredefinedReviewerRolesForStage(reviewStage)) {
            return EntityVersionValidationServiceImpl.validateReviewerByConfiguredRoles(personIndependentAuthorizationContext, entity, reviewer, reviewStage, reviewerConfig);
        }
        return EntityVersionValidationServiceImpl.validateReviewerByAuthorization(personIndependentAuthorizationContext, entity, reviewer);
    }

    private static boolean validateReviewerByConfiguredRoles(@Nonnull PersonIndependentAuthorizationContext personIndependentAuthorizationContext, @Nonnull DBEntity entity, @Nonnull DBPerson reviewer, int reviewStage, @Nonnull EntityVersionReviewerConfig reviewerConfig) {
        ImmutableList<ImmutableSet<Role>> reviewerRoles = reviewerConfig.getReviewers();
        if (reviewStage > reviewerRoles.size()) {
            return false;
        }
        ImmutableSet stageReviewerRoles = (ImmutableSet)reviewerRoles.get(reviewStage);
        return !personIndependentAuthorizationContext.hasAuthorities(new EntityItem(entity), reviewer, (ImmutableSet<? extends Role>)BasePersonIndependentAuthorizationContext.NO_ROLES, stageReviewerRoles).isEmpty();
    }

    private static boolean validateReviewerByAuthorization(@Nonnull PersonIndependentAuthorizationContext personIndependentAuthorizationContext, @Nonnull DBEntity entity, @Nonnull DBPerson reviewer) {
        return personIndependentAuthorizationContext.may(new EntityItem(entity), (Action)StaticEntityAction.ENTITY_BECOME_VERSION_REVIEWER, reviewer);
    }

    @Nonnull
    private EntityVersionConstants getValidationMessages() {
        return this._i18nService.createProxy(EntityVersionConstants.class, this.getLanguage());
    }

    private boolean validateVersionDates(@Nullable DateWithoutTimezone releaseDate, @Nullable DateWithoutTimezone expirationDate, boolean releaseExpirationDayMandatory, int maxDaysAsActiveVersion, @Nonnull EntityVersionConstants messages, @Nonnull ConstraintValidatorContext context) {
        boolean isValid = this.validateReleaseDate(releaseDate, messages, context);
        boolean bl = isValid = this.validateExpirationDate(expirationDate, releaseExpirationDayMandatory, messages, context) && isValid;
        if (isValid && expirationDate != null) {
            isValid = this.validatePublicationDuration(releaseDate, expirationDate, maxDaysAsActiveVersion, messages, context);
        }
        return isValid;
    }

    private boolean validateReleaseDate(@Nullable DateWithoutTimezone releaseDate, @Nonnull EntityVersionConstants messages, @Nonnull ConstraintValidatorContext context) {
        if (releaseDate != null && releaseDate.before(new DateWithoutTimezone(this._clock.now().minusMinutes(5).getMillis()))) {
            this.addViolation(RELEASE_DATE_FIELD, messages.releaseDateInPast(), context);
            return false;
        }
        return true;
    }

    private boolean validateExpirationDate(@Nullable DateWithoutTimezone expirationDate, boolean mandatory, @Nonnull EntityVersionConstants messages, @Nonnull ConstraintValidatorContext context) {
        if (mandatory && expirationDate == null) {
            this.addViolation(EXPIRATION_DATE_FIELD, messages.expirationDateMandatory(), context);
            return false;
        }
        return true;
    }

    private boolean validatePublicationDuration(@Nullable DateWithoutTimezone releaseDate, @Nonnull DateWithoutTimezone expirationDate, int maxDays, @Nonnull EntityVersionConstants messages, @Nonnull ConstraintValidatorContext context) {
        Date maxExp = new Date();
        DateWithoutTimezone assumedReleaseDate = releaseDate != null ? releaseDate : new DateWithoutTimezone();
        long time = assumedReleaseDate.getTime();
        long dayDiff = time % ONE_DAY_MILLIS;
        maxExp.setTime(time - dayDiff + (long)(maxDays + 1) * ONE_DAY_MILLIS);
        if (expirationDate.before(assumedReleaseDate) || expirationDate.after(maxExp)) {
            this.addViolation(EXPIRATION_DATE_FIELD, messages.expirationDateNotInRange(maxDays), context);
            return false;
        }
        return true;
    }

    private boolean validateDeclineMessagePresent(@Nonnull EntityVersionReviewData data, @Nonnull EntityVersionConstants messages, @Nonnull ConstraintValidatorContext context) {
        String declineMessage = data.getDeclineMessage();
        if (declineMessage == null || declineMessage.trim().length() < 10) {
            this.addViolation(DECLINE_MESSAGE_FIELD, messages.declineMessageMandatoryTooltip(), context);
            return false;
        }
        return true;
    }

    private boolean validateDeclineMessageLength(@Nonnull EntityVersionReviewData data, @Nonnull EntityVersionConstants messages, @Nonnull ConstraintValidatorContext context) {
        String declineMessage = data.getDeclineMessage();
        if (declineMessage == null) {
            return true;
        }
        if (declineMessage.length() > 250) {
            this.addViolation(DECLINE_MESSAGE_FIELD, messages.declineMessageToLongTooltip(), context);
            return false;
        }
        return true;
    }

    private boolean validateVersionDates(@Nonnull EntityVersionReviewData data, @Nonnull ConstraintValidatorContext context, @Nonnull EntityVersionConstants messages) {
        return this.validateVersionDates(data.getReleaseDate(), data.getExpirationDate(), data.getExpirationDateMandatory(), data.getMaxDaysAsActiveVersion(), messages, context);
    }

    private void addViolation(@Nonnull String field, @Nonnull String template, @Nonnull ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(template).addNode(field).addConstraintViolation();
    }
}

