/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.ServiceException;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityVersionReadWriteDataService;
import de.justsoftware.onx.container.business.EntityVersionUpdateService;
import de.justsoftware.onx.container.business.events.EntityVersionReleaseEvent;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.container.shared.model.db.DBEntityVersion;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EntityVersionUpdateServiceImpl
implements EntityVersionUpdateService {
    @Autowired
    private EntityVersionReadWriteDataService _entityVersionDataService;
    @Autowired
    private EntityConfigService _entityConfigService;

    @Nonnull
    private EntityVersion getVersionByIdNonNull(EntityVersionId id) {
        return InvalidIdServiceException.check(this._entityVersionDataService.getById(id));
    }

    @Override
    public EntityVersionReleaseEvent releaseVersion(EntityVersionId entityVersionId, EntityStatusId targetStatusId, EntityVersionType targetType, PersonId releaser, boolean notifyAuthor) {
        EntityVersion version = this.getVersionByIdNonNull(entityVersionId);
        DBEntityVersion dbVersion = new DBEntityVersion(version);
        EntityStatus releaseStatus = InvalidIdServiceException.check(this._entityConfigService.getEntityStatusById(targetStatusId));
        dbVersion.setStatus(releaseStatus);
        dbVersion.setVersionType(targetType);
        switch (targetType) {
            case MINOR: {
                dbVersion.setMinorVersion(version.getMinorVersion() + 1);
                dbVersion.setDraftVersion(0);
                break;
            }
            case MAJOR: {
                dbVersion.setMinorVersion(0);
                dbVersion.setDraftVersion(0);
                dbVersion.setMajorVersion(version.getMajorVersion() + 1);
                break;
            }
            default: {
                throw new ServiceException();
            }
        }
        if (dbVersion.getReleaseDate() == null) {
            dbVersion.setReleaseDate(new DateWithoutTimezone());
        }
        this._entityVersionDataService.update(dbVersion);
        return new EntityVersionReleaseEvent(this.getVersionByIdNonNull(version.getId()), releaser, notifyAuthor);
    }
}

