/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.deletion.DeletionService;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.EntityVersionReviewerConfig;
import de.justsoftware.onx.common.shared.model.IEntityVersion;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityReadDataService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityVersionImportService;
import de.justsoftware.onx.container.business.EntityVersionReadWriteDataService;
import de.justsoftware.onx.container.business.EntityVersionUpdateService;
import de.justsoftware.onx.container.business.EntityVersionValidationService;
import de.justsoftware.onx.container.business.events.DriveChangesConnectedEvent;
import de.justsoftware.onx.container.business.events.EntityPrivacyChangedEvent;
import de.justsoftware.onx.container.business.events.EntityReviewerChangedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionAcceptedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionAcceptedNoticedByAuthorEvent;
import de.justsoftware.onx.container.business.events.EntityVersionArchivedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionCreatedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionDeclinedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionDeclinedNoticedByAuthorEvent;
import de.justsoftware.onx.container.business.events.EntityVersionDeletedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionPublishedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionReviewRequestEvent;
import de.justsoftware.onx.container.business.events.EntityVersionStatusUpdateEvent;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.business.model.NewDriveChangeEntityVersionModel;
import de.justsoftware.onx.container.integration.persistence.EntityVersionArchiveNoticeDAO;
import de.justsoftware.onx.container.integration.persistence.EntityVersionComponentsDao;
import de.justsoftware.onx.container.integration.persistence.EntityVersionDriveChangeDAO;
import de.justsoftware.onx.container.integration.persistence.EntityVersionReviewDAO;
import de.justsoftware.onx.container.shared.i18n.EntityVersionConstants;
import de.justsoftware.onx.container.shared.model.ConcurrentUpdateException;
import de.justsoftware.onx.container.shared.model.DriveChangeId;
import de.justsoftware.onx.container.shared.model.EntityBadge;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusClientModel;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionAlreadyArchivedException;
import de.justsoftware.onx.container.shared.model.EntityVersionException;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionInReviewException;
import de.justsoftware.onx.container.shared.model.EntityVersionReleaseClientModel;
import de.justsoftware.onx.container.shared.model.EntityVersionReleaseDataOption;
import de.justsoftware.onx.container.shared.model.EntityVersionReviewData;
import de.justsoftware.onx.container.shared.model.EntityVersionReviewStatus;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ReleaseProcessStatus;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityVersion;
import de.justsoftware.onx.container.shared.model.db.DBEntityVersionReview;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import de.justsoftware.onx.container.shared.model.validation.group.AcceptVersionValidationGroup;
import de.justsoftware.onx.container.shared.model.validation.group.DeclineVersionValidationGroup;
import de.justsoftware.onx.container.shared.model.validation.group.ServerGroup;
import de.justsoftware.onx.container.shared.server.model.EntityVersionReleaseData;
import de.justsoftware.onx.drive.business.DriveInternalApiConnector;
import de.justsoftware.onx.drive.business.model.DriveChangePurpose;
import de.justsoftware.onx.drive.business.model.DriveRestoreChangeResponse;
import de.justsoftware.onx.drive.business.model.DriveRestorePurpose;
import de.justsoftware.onx.multiwiki.business.MultiWikiService;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.person.shared.model.PersonTeaserWithEntityVersionReviewStatusModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.validation.JucoValidator;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolation;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolationException;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.validation.groups.Default;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@ParametersAreNonnullByDefault
@Service
public class EntityVersionServiceImpl
implements ServerEventHandler,
EntityVersionImportService {
    private static final Logger LOG = LoggerFactory.getLogger(EntityVersionServiceImpl.class);
    @Autowired
    private EntityVersionReviewDAO _entityVersionReviewDAO;
    @Autowired
    private EntityVersionComponentsDao _entityVersionComponentsDao;
    @Autowired
    private EntityVersionDriveChangeDAO _entityVersionDriveChangeDAO;
    @Autowired
    private AuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private EntityConfigService _entityConfigService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private EntityService _entityService;
    @Autowired
    private EntityReadDataService _entityReadDataService;
    @Autowired
    private MultiWikiService _multiWikiService;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private JCEventBus _eventBus;
    @Autowired
    private JucoValidator _validator;
    @Autowired
    private TransactionHelper _transactionHelper;
    @Autowired
    private Clock _clock;
    @Autowired
    private DeletionService _deletionService;
    @Autowired
    private EntityVersionValidationService _entityVersionValidationService;
    @Autowired
    private EntityVersionReadWriteDataService _entityVersionReadWriteDataService;
    @Autowired
    private EntityVersionUpdateService _entityVersionUpdateService;
    @Autowired
    private EntityVersionArchiveNoticeDAO _archiveNoticeDao;
    @Autowired
    private DriveInternalApiConnector _driveInternalApiConnector;

    @Override
    public EntityVersion createInitialEntityVersion(EntityId entityId, PersonId authorId, EntityStatus status, ServerEventCollector eventCollector) {
        DBEntityVersion versionToCreate = new DBEntityVersion();
        versionToCreate.setEntityId(entityId);
        versionToCreate.setMajorVersion(0);
        versionToCreate.setMinorVersion(0);
        versionToCreate.setDraftVersion(1);
        versionToCreate.setVersionType(EntityVersionType.DRAFT);
        versionToCreate.setAuthorId(authorId);
        versionToCreate.setStatus(status);
        this._entityVersionReadWriteDataService.create(versionToCreate);
        EntityVersion createdVersion = this.getVersionByIdNonNull(versionToCreate.getId());
        eventCollector.add(new EntityVersionCreatedEvent(createdVersion));
        return createdVersion;
    }

    @Override
    public EntityVersion getCurrentEntityVersionForUser(EntityId entityId, AuthorizationCheckContext authCtx) {
        ImmutableMap<EntityId, EntityVersion> currentEntityVersions = this.getCurrentEntityVersions((Set<EntityId>)ImmutableSet.of((Object)entityId), authCtx);
        return (EntityVersion)currentEntityVersions.get((Object)entityId);
    }

    @Override
    public ImmutableMap<EntityId, EntityVersion> getCurrentEntityVersions(Set<EntityId> entities, AuthorizationCheckContext authCtx) {
        ImmutableSetMultimap<EntityId, EntityVersion> versionMap = this._entityVersionReadWriteDataService.getNewestVersions(entities);
        ImmutableSetMultimap.Builder actionPerItemsBuilder = ImmutableSetMultimap.builder();
        for (EntityId entityId : entities) {
            for (EntityVersion version : versionMap.get((Object)entityId)) {
                actionPerItemsBuilder.put((Object)entityId, (Object)version.getStatus().readAction());
            }
        }
        ImmutableSetMultimap actionsPerItem = actionPerItemsBuilder.build();
        ImmutableSetMultimap allowed = authCtx.may(actionsPerItem);
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        block2: for (EntityId entityId : entities) {
            ImmutableList sortedVersions = EntityVersion.ENTITY_VERSION_ID_ORDERING.reverse().immutableSortedCopy((Iterable)versionMap.get((Object)entityId));
            for (EntityVersion version : sortedVersions) {
                if (!allowed.containsEntry((Object)entityId, (Object)version.getStatus().readAction())) continue;
                resultBuilder.put((Object)entityId, (Object)version);
                continue block2;
            }
        }
        return resultBuilder.build();
    }

    @Override
    public ImmutableMap<EntityId, EntityVersion> getNewestVersionsWithStatus(Set<EntityId> entityIds, Set<EntityStatus> status) {
        ImmutableMultimap<EntityId, EntityVersion> versionMultiMap = this._entityVersionReadWriteDataService.getNewestVersionByStatus(entityIds, status);
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (EntityId entityId : entityIds) {
            ImmutableCollection entityVersions = versionMultiMap.get((Object)entityId);
            if (entityVersions.isEmpty()) continue;
            mapBuilder.put((Object)entityId, (Object)((EntityVersion)EntityVersion.ENTITY_VERSION_ID_ORDERING.max((Iterable)entityVersions)));
        }
        return mapBuilder.build();
    }

    @Override
    public ImmutableMultimap<EntityId, EntityVersion> getNewestVersionByStatus(Set<EntityId> entityIds) {
        return this._entityVersionReadWriteDataService.getNewestVersions(entityIds);
    }

    @Override
    public EntityVersion getNewestVersionWithStatus(EntityId entityId, Set<EntityStatus> status) {
        return (EntityVersion)this.getNewestVersionsWithStatus((Set<EntityId>)ImmutableSet.of((Object)entityId), status).get((Object)entityId);
    }

    @Override
    public ImmutableMap<EntityId, EntityVersion> getNewestVersion(Set<EntityId> entityIds) {
        return this.getNewestVersionsWithStatus(entityIds, (Set<EntityStatus>)ImmutableSet.of());
    }

    @Override
    public ImmutableMap<EntityId, EntityVersion> getVersionsCurrentlyInReview(Set<EntityId> entityIds) {
        ImmutableSet<EntityStatus> entityStatus = this.getInReviewStates();
        if (entityStatus.isEmpty()) {
            return ImmutableMap.of();
        }
        return this.getNewestVersionsWithStatus(entityIds, (Set<EntityStatus>)entityStatus);
    }

    @Nonnull
    private ImmutableSet<EntityStatus> getInReviewStates() {
        return this._entityConfigService.getAllEntityStatusForPredicate((Predicate<? super EntityStatus>)((Predicate)ReleaseProcessStatus.IN_REVIEW::equalsEntityStatus));
    }

    @Override
    public EntityVersion createNewDraftVersionForTest(EntityVersionId parentId, AuthorizationCheckContextWithUserId auth) {
        EntityVersion version = InvalidIdServiceException.check(this.getVersionById(parentId));
        return this.newDraftFromVersionWithoutPermissionCheck(version, auth);
    }

    @CheckForNull
    private EntityVersion getNewestVersion(EntityId entityId) {
        return (EntityVersion)this.getNewestVersion((Set<EntityId>)ImmutableSet.of((Object)entityId)).get((Object)entityId);
    }

    @Nonnull
    private EntityVersion newDraftFromVersionWithoutPermissionCheck(EntityVersion version, AuthorizationCheckContextWithUserId auth) {
        PersonId authorId = auth.getUserId();
        EntityVersion latestVersion = this.getNewestVersion(version.getEntityId());
        if (latestVersion == null) {
            throw new IllegalArgumentException("no version for id " + version.getEntityId());
        }
        if (latestVersion.getStatus().getName().equals(ReleaseProcessStatus.IN_REVIEW.getName())) {
            throw new PermissionDeniedException(this._i18nService.createProxy(BasicConstants.class, auth.getLocale()).editingForbiddenDuringReview());
        }
        EntityType entityType = version.getStatus().getEntityType();
        EntityVersionId newVersionId = this.createNewVersion(latestVersion, authorId, this.draftStatus(entityType)).getId();
        return this.getVersionByIdNonNull(newVersionId);
    }

    @Nonnull
    private DBEntityVersion createNewVersion(IEntityVersion latestVersion, PersonId authorId, EntityStatus draftStatus) {
        DBEntityVersion versionToCreate = new DBEntityVersion();
        versionToCreate.setEntityId(latestVersion.getEntityId());
        versionToCreate.setStatus(draftStatus);
        this.setNextVersion(latestVersion, EntityVersionType.DRAFT, versionToCreate);
        versionToCreate.setAuthorId(authorId);
        this._entityVersionReadWriteDataService.create(versionToCreate);
        return versionToCreate;
    }

    @Nonnull
    private DBEntityVersion setNextVersion(IEntityVersion lastVersion, EntityVersionType typeToRelease, DBEntityVersion versionToSet) {
        versionToSet.setVersionType(typeToRelease);
        switch (typeToRelease) {
            case MAJOR: {
                versionToSet.setDraftVersion(0);
                versionToSet.setMinorVersion(0);
                versionToSet.setMajorVersion(lastVersion.getMajorVersion() + 1);
                return versionToSet;
            }
            case MINOR: {
                versionToSet.setDraftVersion(0);
                versionToSet.setMinorVersion(lastVersion.getMinorVersion() + 1);
                versionToSet.setMajorVersion(lastVersion.getMajorVersion());
                return versionToSet;
            }
            case DRAFT: {
                versionToSet.setDraftVersion(lastVersion.getDraftVersion() + 1);
                versionToSet.setMinorVersion(lastVersion.getMinorVersion());
                versionToSet.setMajorVersion(lastVersion.getMajorVersion());
                return versionToSet;
            }
        }
        throw new UnsupportedOperationException("unknow versionType to set: " + typeToRelease);
    }

    @Override
    public DBEntityVersionReview getReviewFromPerson(EntityVersionId versionId, PersonId reviewerId) {
        return this._entityVersionReviewDAO.getReviewFromPerson(versionId, reviewerId);
    }

    @Override
    public boolean isReviewerForVersion(EntityVersionId versionId, PersonId personId) {
        return this.getReviewFromPerson(versionId, personId) != null;
    }

    @Override
    public EntityVersion stageVersionForReview(EntityVersionReleaseClientModel releaseData, AuthorizationCheckContextWithUserId auth) {
        return this.stageVersionForReview(releaseData, auth, true);
    }

    @Override
    public EntityVersion stageVersionForReview(EntityVersionReleaseClientModel releaseData, AuthorizationCheckContextWithUserId auth, boolean selfReleasePermitted) {
        ImmutableList.Builder events = ImmutableList.builder();
        EntityVersion result = (EntityVersion)this._transactionHelper.doInTransaction(t -> this.stageVersionForReview(releaseData, auth, selfReleasePermitted, arg_0 -> ((ImmutableList.Builder)events).add(arg_0)));
        this._eventBus.post((Iterable<? extends ServerEvent>)events.build());
        return result;
    }

    @Nonnull
    private EntityVersion stageVersionForReview(EntityVersionReleaseClientModel releaseData, AuthorizationCheckContextWithUserId auth, boolean selfReleasePermitted, Consumer<? super ServerEvent> eventConsumer) {
        boolean reviewMandatoryForRelease;
        DBEntityVersion dbVersionToStage = this.createVersionAndValidate(releaseData, auth, eventConsumer);
        EntityVersion versionToStage = new EntityVersion(dbVersionToStage);
        DBEntity entity = this._entityService.getByIdNotNull(dbVersionToStage.getEntityId());
        this._entityVersionReadWriteDataService.update(dbVersionToStage);
        boolean bl = reviewMandatoryForRelease = dbVersionToStage.getTargetType() == EntityVersionType.MAJOR && this._entityConfigService.isReviewMandatoryForRelease(entity.getType());
        if (!reviewMandatoryForRelease) {
            boolean notifyAuthor = !releaseData.getAuthor().equals(auth.getUserId());
            this.releaseVersion(versionToStage, notifyAuthor, auth, eventConsumer);
        } else {
            boolean selfRelease;
            int reviewStage = 0;
            List<PersonId> reviewers = releaseData.getReviewer();
            for (PersonId reviewerId : reviewers) {
                if (reviewerId == null) continue;
                this.addEntityVersionReview(dbVersionToStage.getId(), reviewerId, reviewStage, auth);
                ++reviewStage;
            }
            eventConsumer.accept(new EntityReviewerChangedEvent(dbVersionToStage.getEntityId()));
            boolean bl2 = selfRelease = selfReleasePermitted && ImmutableSet.copyOf(reviewers).equals(Collections.singleton(auth.getUserId()));
            if (selfRelease) {
                this.internalAcceptVersion(dbVersionToStage.getId(), auth, eventConsumer);
            } else {
                this.markNextReviewer(versionToStage, eventConsumer);
            }
        }
        return versionToStage;
    }

    @Nonnull
    private DBEntityVersion createVersionAndValidate(EntityVersionReleaseClientModel releaseData, AuthorizationCheckContextWithUserId auth, Consumer<? super DriveChangesConnectedEvent> eventConsumer) throws JucoConstraintViolationException {
        EntityVersion versionById = this._entityVersionReadWriteDataService.getById(releaseData.getVersionId());
        if (versionById == null) {
            throw new EntityVersionException();
        }
        EntityId entityId = versionById.getEntityId();
        auth.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_VERSION_EDIT_DRAFT);
        JucoConstraintViolationException.check(this.validateReleaseData(releaseData, auth));
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        if (this._entityConfigService.isAuthorChangeableOnRelease(entity.getType())) {
            AuthorizationContext authorAuthCtx = this._authorizationContextProvider.getAuthorizationContextForUser(releaseData.getAuthor());
            authorAuthCtx.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_BECOME_VERSION_AUTHOR);
        }
        this.checkLatestVersion(versionById);
        EntityVersion versionToStage = this.getVersionForReview(auth, versionById, true, eventConsumer);
        return this.fillFromReleaseData(releaseData, versionToStage, this.getStatusForStaticStatus(entity.getType(), ReleaseProcessStatus.IN_REVIEW));
    }

    @Nonnull
    private DBEntityVersion createVersionWithoutValidation(EntityVersion versionById, EntityVersionReleaseClientModel releaseData, EntityStatus status, AuthorizationCheckContextWithUserId auth, Consumer<? super DriveChangesConnectedEvent> eventConsumer) {
        this.checkLatestVersion(versionById);
        EntityVersion versionToStage = this.getVersionForReview(auth, versionById, false, eventConsumer);
        return this.fillFromReleaseData(releaseData, versionToStage, status);
    }

    @Nonnull
    private DBEntityVersion fillFromReleaseData(EntityVersionReleaseClientModel releaseData, EntityVersion version, EntityStatus status) {
        DBEntityVersion versionToStage = new DBEntityVersion(version);
        versionToStage.setAuthorId(releaseData.getAuthor());
        versionToStage.setStatus(status);
        versionToStage.setTargetType(releaseData.getVersionType());
        versionToStage.setExpirationDate(releaseData.getExpirationDate());
        versionToStage.setReleaseDate(releaseData.getReleaseDate());
        versionToStage.setCommentForReviewers(releaseData.getCommentForReviewer());
        versionToStage.setChangeMessage(releaseData.getChangeMessage());
        return versionToStage;
    }

    private void checkLatestVersion(EntityVersion versionById) {
        EntityVersion latestVersion = this.getNewestVersion(versionById.getEntityId());
        if (latestVersion == null) {
            throw new EntityVersionException();
        }
        if (!latestVersion.getId().equals(versionById.getId())) {
            throw new ConcurrentUpdateException();
        }
    }

    @Nonnull
    private EntityVersion getVersionForReview(AuthorizationCheckContextWithUserId auth, EntityVersion entityVersion, boolean requireAuthorizationCheck, Consumer<? super DriveChangesConnectedEvent> eventConsumer) {
        if (entityVersion.getStatus().getName().equals(ReleaseProcessStatus.DRAFT.getName())) {
            return entityVersion;
        }
        if (entityVersion.getStatus().getName().equals(ReleaseProcessStatus.IN_REVIEW.getName())) {
            throw new EntityVersionInReviewException(this._i18nService.createProxy(EntityVersionConstants.class, auth.getLocale()).theCurrentVersionIsInReview());
        }
        return this.restoreVersionInternal(entityVersion, auth, requireAuthorizationCheck, eventConsumer);
    }

    private void markNextReviewer(EntityVersion version, Consumer<? super EntityVersionReviewRequestEvent> eventConsumer) {
        DBEntityVersionReview review = this.getCurrentNonDeclinedReview(version.getId());
        if (review != null) {
            this._entityVersionReviewDAO.updateReviewStatus(version.getId(), review.getReviewerId(), EntityVersionReviewStatus.IN_REVIEW);
            eventConsumer.accept(new EntityVersionReviewRequestEvent(version, review.getReviewerId()));
        }
    }

    @CheckForNull
    private DBEntityVersionReview getCurrentNonDeclinedReview(EntityVersionId versionId) {
        DBEntityVersionReview currentReview = this._entityVersionReviewDAO.getNextReviewWithStatus(versionId, EntityVersionReviewStatus.IN_REVIEW);
        if (currentReview == null) {
            return this._entityVersionReviewDAO.getNextReviewWithStatus(versionId, EntityVersionReviewStatus.NEW);
        }
        return currentReview;
    }

    private void releaseVersion(EntityVersion version, boolean notifyAuthor, AuthorizationCheckContextWithUserId auth, Consumer<? super ServerEvent> eventConsumer) {
        EntityVersionType targetType = version.getTargetType();
        if (targetType == null) {
            throw new ServiceException("version can not be released");
        }
        eventConsumer.accept(this._entityVersionUpdateService.releaseVersion(version.getId(), (EntityStatusId)this.getStatusForStaticStatus(version.getStatus().getEntityType(), ReleaseProcessStatus.RELEASED).getId(), targetType, auth.getUserId(), notifyAuthor));
        eventConsumer.accept(new EntityReviewerChangedEvent(version.getEntityId()));
        auth.invalidate();
    }

    @Override
    public ImmutableSet<JucoConstraintViolation> validateReleaseData(EntityVersionReleaseClientModel releaseData, AuthorizationCheckContextWithUserId authCtx) {
        return this._validator.validate(authCtx, new EntityVersionReleaseData(releaseData), Default.class, ServerGroup.class);
    }

    private void addEntityVersionReview(EntityVersionId versionId, PersonId reviewerId, int reviewStage, AuthorizationCheckContextWithUserId auth) {
        EntityVersion version = this.getVersionById(versionId);
        if (version == null) {
            throw new EntityVersionException();
        }
        if (!version.getStatus().getName().equals(ReleaseProcessStatus.IN_REVIEW.getName())) {
            throw new ServiceException("Version is not in review process");
        }
        auth.check((ItemId)version.getEntityId(), (Action)StaticEntityAction.ENTITY_VERSION_EDIT_DRAFT);
        if (!this.mayReviewEntity(version.getEntityId(), reviewStage, reviewerId)) {
            throw new PermissionDeniedException("Person " + reviewerId + " is not allowed to review " + version.getEntityId() + " as " + reviewStage + ". reviewer.");
        }
        if (this.isReviewerForVersion(versionId, reviewerId)) {
            throw new EntityVersionException();
        }
        ImmutableList currentReviews = this._entityVersionReviewDAO.getReviewsForVersions((Set<EntityVersionId>)ImmutableSet.of((Object)versionId)).get((Object)versionId);
        DBEntityVersionReview review = new DBEntityVersionReview();
        review.setEntityVersionId(versionId);
        review.setReviewerId(reviewerId);
        review.setInviterId(auth.getUserId());
        review.setReviewStatus(EntityVersionReviewStatus.NEW);
        review.setReviewOrder(currentReviews.size());
        this._entityVersionReviewDAO.createReview(review);
        auth.invalidate();
    }

    private boolean mayReviewEntity(EntityId entityId, int reviewStage, PersonId reviewerId) {
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        EntityVersionReviewerConfig reviewerConfig = this._entityConfigService.getVersionReleaseReviewerConfig(entity.getType());
        return this._entityVersionValidationService.isValidReviewerForReviewStage(entity, reviewerId, reviewStage, reviewerConfig);
    }

    private void internalAcceptVersion(EntityVersionId versionId, AuthorizationCheckContextWithUserId auth, Consumer<? super ServerEvent> eventConsumer) {
        EntityVersion updatedVersion = (EntityVersion)Preconditions.checkNotNull((Object)this._entityVersionReadWriteDataService.getById(versionId));
        this._entityVersionReviewDAO.updateReviewStatus(versionId, auth.getUserId(), EntityVersionReviewStatus.ACCEPTED);
        eventConsumer.accept(new EntityVersionAcceptedEvent(updatedVersion, auth.getUserId()));
        DBEntityVersionReview nextReview = this._entityVersionReviewDAO.getNextReviewWithStatus(versionId, EntityVersionReviewStatus.NEW);
        if (nextReview == null) {
            this.releaseVersion(updatedVersion, true, auth, eventConsumer);
        } else {
            this.markNextReviewer(updatedVersion, eventConsumer);
        }
    }

    @Override
    public EntityVersion acceptVersion(EntityVersionId versionId, DateWithoutTimezone newVersionReleaseDate, DateWithoutTimezone newVersionExpirationDate, AuthorizationCheckContextWithUserId auth) {
        EntityVersion version = this._entityVersionReadWriteDataService.getById(versionId);
        if (version == null) {
            throw new ServiceException("No such version");
        }
        auth.check((ItemId)version.getEntityId(), (Action)StaticEntityAction.ENTITY_VERSION_REVIEW);
        this.checkIfUserCanUpdateReview(versionId, auth);
        DBEntityVersion validatedVersion = this.validateVersionReviewUpdates(version, newVersionReleaseDate, newVersionExpirationDate, "", auth, new Class[]{AcceptVersionValidationGroup.class});
        ImmutableList.Builder events = ImmutableList.builder();
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            this._entityVersionReadWriteDataService.update(validatedVersion);
            this.internalAcceptVersion(versionId, auth, arg_0 -> ((ImmutableList.Builder)events).add(arg_0));
        });
        this._eventBus.post((Iterable<? extends ServerEvent>)events.build());
        return this.getVersionByIdNonNull(versionId);
    }

    @Nonnull
    private DBEntityVersion validateVersionReviewUpdates(EntityVersion version, @Nullable DateWithoutTimezone newVersionReleaseDate, @Nullable DateWithoutTimezone newVersionExpirationDate, @Nullable String declineMessage, AuthorizationCheckContextWithUserId auth, Class<?>[] validationGroups) {
        EntityVersionReviewData reviewForPerson;
        DBEntityVersion dbVersion = new DBEntityVersion(version);
        dbVersion.setReleaseDate(newVersionReleaseDate);
        if (newVersionExpirationDate != null) {
            dbVersion.setExpirationDate(newVersionExpirationDate);
        }
        if (declineMessage != null) {
            dbVersion.setDeclineMessage(declineMessage);
        }
        if ((reviewForPerson = this.getReviewForPerson(auth, dbVersion.getId())) == null) {
            throw new PermissionDeniedException();
        }
        EntityVersionReviewData validationModel = reviewForPerson.getValidationModel(dbVersion.getReleaseDate(), dbVersion.getExpirationDate(), dbVersion.getDeclineMessage());
        JucoConstraintViolationException.check(this.validateReviewData(validationModel, validationGroups, auth));
        return dbVersion;
    }

    @Nonnull
    private ImmutableSet<JucoConstraintViolation> validateReviewData(EntityVersionReviewData validationModel, Class<?>[] validationGroups, AuthorizationCheckContextWithUserId authCtx) {
        return this._validator.validate(authCtx, validationModel, validationGroups);
    }

    private void checkIfUserCanUpdateReview(EntityVersionId versionId, AuthorizationCheckContextWithUserId auth) {
        DBEntityVersionReview review = this._entityVersionReviewDAO.getNextReviewWithStatus(versionId, EntityVersionReviewStatus.IN_REVIEW);
        if (review == null) {
            throw new PermissionDeniedException();
        }
        if (!auth.getUserId().equals(review.getReviewerId())) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    public EntityVersion declineVersion(EntityVersionId versionId, String declineMessage, AuthorizationCheckContextWithUserId authCtx) {
        EntityVersion version = this._entityVersionReadWriteDataService.getById(versionId);
        if (version == null) {
            throw new ServiceException("No such version");
        }
        authCtx.check((ItemId)version.getEntityId(), (Action)StaticEntityAction.ENTITY_READ_PRIVATE);
        DBEntityVersion validatedVersion = this.validateVersionReviewUpdates(version, version.getReleaseDate(), version.getExpirationDate(), declineMessage, authCtx, new Class[]{DeclineVersionValidationGroup.class});
        EntityStatus declinedStatus = this.getStatusForStaticStatus(version.getStatus().getEntityType(), ReleaseProcessStatus.DECLINED);
        validatedVersion.setStatus(declinedStatus);
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            this._entityVersionReadWriteDataService.update(validatedVersion);
            this._entityVersionReviewDAO.updateReviewStatus(versionId, authCtx.getUserId(), EntityVersionReviewStatus.DECLINED);
        });
        this._eventBus.post(new EntityVersionDeclinedEvent(new EntityVersion(validatedVersion), authCtx.getUserId()));
        this._eventBus.post(new EntityReviewerChangedEvent(version.getEntityId()));
        return this.getVersionByIdNonNull(versionId);
    }

    @Override
    public EntityVersion getVersionById(EntityVersionId id) {
        return this._entityVersionReadWriteDataService.getById(id);
    }

    @Override
    public EntityVersion getVersionByIdNonNull(EntityVersionId id) {
        return InvalidIdServiceException.check(this.getVersionById(id));
    }

    @Override
    public ImmutableMap<EntityVersionId, EntityVersion> getVersionsByIds(Set<EntityVersionId> versionIds) {
        return this._entityVersionReadWriteDataService.getByIdsAsMap(versionIds);
    }

    @Nonnull
    private ImmutableMap<EntityVersionId, EntityVersionReviewData> getEntityVersionReviewData(Iterable<EntityVersion> entityVersions, ListMultimap<EntityVersionId, DBEntityVersionReview> entityVersionReviewDatas, AuthorizationCheckContextWithUserId auth) {
        ImmutableSet entityIds = FluentIterable.from(entityVersions).transform(IEntityVersion.GET_ENTITY_ID).toSet();
        Map<EntityId, DBEntity> entities = this._entityService.getByIds((Set<EntityId>)entityIds);
        ImmutableMap<EntityId, EntityInfo> entityInfos = this._entityService.createInfos(entities.values(), auth);
        ImmutableMap<EntityId, EntityVersion> publicVersions = this.getPublicVersions((ImmutableSet<EntityId>)entityIds, auth);
        ImmutableSet personIds = FluentIterable.from((Iterable)entityVersionReviewDatas.values()).transformAndConcat(DBEntityVersionReview.GET_INVITER_AND_REVIEWER).append((Object[])new PersonId[]{auth.getUserId()}).toSet();
        ImmutableMap<PersonId, PersonTeaserModel> personTeasers = this._profileTeaserService.getPersonTeasersByIds((Set<PersonId>)personIds, auth);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (EntityVersion entityVersion : entityVersions) {
            EntityVersionId versionId = entityVersion.getId();
            EntityInfo entityInfo = InvalidIdServiceException.check((EntityInfo)entityInfos.get((Object)entityVersion.getEntityId()));
            DBEntity entity = InvalidIdServiceException.check(entities.get(entityVersion.getEntityId()));
            EntityVersion entityLastPublicVersion = (EntityVersion)publicVersions.get((Object)entityVersion.getEntityId());
            result.put((Object)versionId, (Object)this.getEntityVersionReviewData(entityVersion, entityVersionReviewDatas.get((Object)versionId), auth, (Map<PersonId, PersonTeaserModel>)personTeasers, entity, entityInfo, entityLastPublicVersion));
        }
        return result.build();
    }

    @Nonnull
    private EntityVersionReviewData getEntityVersionReviewData(EntityVersion entityVersionData, List<DBEntityVersionReview> entityVersionReviewData, AuthorizationCheckContextWithUserId auth, Map<PersonId, PersonTeaserModel> personTeasers, DBEntity dbEntity, EntityInfo entityInfo, @Nullable EntityVersion entityLastPublicVersion) {
        PersonId currentPerson;
        ImmutableList.Builder reviewers = ImmutableList.builder();
        PersonId inviterId = currentPerson = auth.getUserId();
        boolean isFinished = false;
        boolean mayAccept = false;
        boolean mayNotDecline = false;
        for (DBEntityVersionReview inReviewData : entityVersionReviewData) {
            PersonId reviewerId = inReviewData.getReviewerId();
            PersonTeaserModel personTeaserById = personTeasers.get(reviewerId);
            if (personTeaserById != null) {
                reviewers.add((Object)new PersonTeaserWithEntityVersionReviewStatusModel(personTeaserById, inReviewData.getReviewStatus()));
            }
            switch (inReviewData.getReviewStatus()) {
                case DECLINED: {
                    isFinished = true;
                    mayNotDecline = reviewerId.equals(currentPerson);
                    break;
                }
                case IN_REVIEW: {
                    mayAccept |= reviewerId.equals(currentPerson);
                    break;
                }
                case ACCEPTED: 
                case NEW: {
                    mayNotDecline = reviewerId.equals(currentPerson);
                }
            }
            inviterId = inReviewData.getInviterId();
        }
        mayAccept &= !isFinished;
        boolean mayDecline = !mayNotDecline && !isFinished;
        EntityType entityType = (EntityType)entityInfo.getType();
        int maxDaysAsActiveVersion = this._entityConfigService.maxDaysAsActiveVersion(entityType);
        boolean releaseActivationDateMandatory = this._entityConfigService.getReleaseActivationDateVisibility(entityType) == EntityVersionReleaseDataOption.MANDATORY;
        boolean releaseExpirationDateMandatory = this._entityConfigService.getReleaseExpirationDateVisibility(entityType) == EntityVersionReleaseDataOption.MANDATORY;
        String changeMessage = entityVersionData.getChangeMessage();
        boolean mayReview = this.userMayReviewFirstStage(entityVersionData, auth, dbEntity);
        return new EntityVersionReviewData(entityVersionData.getId(), (EntityStatusClientModel)EntityStatusClientModel.TO_CLIENT_MODEL.apply((Object)entityVersionData.getStatus()), (PersonTeaserModel)Preconditions.checkNotNull((Object)personTeasers.get(inviterId)), entityInfo, (ImmutableList<PersonTeaserWithEntityVersionReviewStatusModel>)reviewers.build(), entityVersionData.getReleaseDate(), entityVersionData.getExpirationDate(), entityLastPublicVersion != null ? entityLastPublicVersion.getExpirationDate() : null, Strings.nullToEmpty((String)changeMessage), entityVersionData.getCommentForReviewers(), entityVersionData.getDeclineMessage(), entityVersionData.getVersionType(), mayDecline, mayAccept, mayReview, releaseActivationDateMandatory, releaseExpirationDateMandatory, maxDaysAsActiveVersion);
    }

    private boolean userMayReviewFirstStage(EntityVersion entityVersionData, AuthorizationCheckContextWithUserId auth, DBEntity dbEntity) {
        if (!ReleaseProcessStatus.IN_REVIEW.equalsEntityStatus(entityVersionData.getStatus())) {
            return this._entityVersionValidationService.isValidReviewerForReviewStage(dbEntity, auth.getUserId(), 0, this._entityConfigService.getVersionReleaseReviewerConfig(dbEntity.getType()));
        }
        return false;
    }

    @Override
    public ListAndCount<EntityVersionReviewData> getInReviewForPerson(int offset, int limit, AuthorizationCheckContextWithUserId authorizationContext) {
        ListAndCount<DBEntityVersionReview> inReviews = this._entityVersionReviewDAO.getInReviewForPerson(offset, limit, authorizationContext.getUserId());
        ListAndCount<EntityVersionReviewData> inReviewForPerson = new ListAndCount<EntityVersionReviewData>();
        inReviewForPerson.setMaxCount(inReviews.getMaxCount());
        ImmutableSet versionIds = ImmutableSet.copyOf((Iterable)Iterables.transform(inReviews, DBEntityVersionReview.GET_ENTITY_VERSION_ID));
        ImmutableMap<EntityVersionId, EntityVersion> versionsByIds = this._entityVersionReadWriteDataService.getByIdsAsMap((Set<EntityVersionId>)versionIds);
        ImmutableListMultimap<EntityVersionId, DBEntityVersionReview> reviews = this._entityVersionReviewDAO.getReviewsForVersions((Set<EntityVersionId>)versionIds);
        ImmutableMap<EntityVersionId, EntityVersionReviewData> entityVersionReviewDatas = this.getEntityVersionReviewData((Iterable<EntityVersion>)versionsByIds.values(), (ListMultimap<EntityVersionId, DBEntityVersionReview>)reviews, authorizationContext);
        for (DBEntityVersionReview inReview : inReviews) {
            inReviewForPerson.add((EntityVersionReviewData)entityVersionReviewDatas.get((Object)inReview.getEntityVersionId()));
        }
        return inReviewForPerson;
    }

    @Override
    public ImmutableMap<EntityVersionId, EntityVersionReviewData> getInReviewForPersonByVersionId(AuthorizationCheckContextWithUserId authorizationContext) {
        ListAndCount<DBEntityVersionReview> inReviews = this._entityVersionReviewDAO.getInReviewForPerson(0, Integer.MAX_VALUE, authorizationContext.getUserId());
        ImmutableSet versionIds = ImmutableSet.copyOf((Iterable)Iterables.transform(inReviews, DBEntityVersionReview.GET_ENTITY_VERSION_ID));
        ImmutableListMultimap<EntityVersionId, DBEntityVersionReview> reviews = this._entityVersionReviewDAO.getReviewsForVersions((Set<EntityVersionId>)versionIds);
        ImmutableMap<EntityVersionId, EntityVersion> versionsByIds = this.getVersionsByIds((Set<EntityVersionId>)versionIds);
        return this.getEntityVersionReviewData((Iterable<EntityVersion>)versionsByIds.values(), (ListMultimap<EntityVersionId, DBEntityVersionReview>)reviews, authorizationContext);
    }

    @Override
    public ImmutableMap<EntityVersionId, EntityVersionReviewData> getDeclinedForPersonById(AuthorizationCheckContextWithUserId authorizationContext) {
        ListAndCount<EntityVersion> declinedList = this._entityVersionReadWriteDataService.getDeclinedForPerson(0, Integer.MAX_VALUE, authorizationContext.getUserId());
        ImmutableSet versionIds = ImmutableSet.copyOf((Iterable)Iterables.transform(declinedList, IEntityVersion.GET_ID));
        ImmutableListMultimap<EntityVersionId, DBEntityVersionReview> reviews = this._entityVersionReviewDAO.getReviewsForVersions((Set<EntityVersionId>)versionIds);
        return this.getEntityVersionReviewData((Iterable<EntityVersion>)declinedList, (ListMultimap<EntityVersionId, DBEntityVersionReview>)reviews, authorizationContext);
    }

    @Override
    public ImmutableListMultimap<EntityVersionId, DBEntityVersionReview> getDBReviewForVersion(ImmutableSet<EntityVersionId> versionIds) {
        return this._entityVersionReviewDAO.getReviewsForVersions((Set<EntityVersionId>)versionIds);
    }

    @Override
    public EntityVersionReviewData getReviewForPerson(AuthorizationCheckContextWithUserId auth, EntityVersionId versionId) {
        EntityVersion entityVersionData = this.getVersionById(versionId);
        if (entityVersionData != null) {
            ImmutableListMultimap<EntityVersionId, DBEntityVersionReview> reviews = this._entityVersionReviewDAO.getReviewsForVersions((Set<EntityVersionId>)ImmutableSet.of((Object)versionId));
            return (EntityVersionReviewData)this.getEntityVersionReviewData((Iterable<EntityVersion>)ImmutableList.of((Object)entityVersionData), (ListMultimap<EntityVersionId, DBEntityVersionReview>)reviews, auth).get((Object)entityVersionData.getId());
        }
        return null;
    }

    @Override
    public void updateReadDateByEntityVersionId(EntityVersionId id, DateWithoutTimezone readDate) {
        ReleaseProcessStatus status;
        this._entityVersionReadWriteDataService.updateReadDateByEntityVersionId(id, readDate);
        EntityVersion updatedVersion = this.getVersionById(id);
        if (updatedVersion != null && (status = ReleaseProcessStatus.fromStatusIfExists(updatedVersion.getStatus())) != null) {
            switch (status) {
                case DECLINED: {
                    this._eventBus.post(new EntityVersionDeclinedNoticedByAuthorEvent(updatedVersion));
                    break;
                }
                case PUBLISHED: 
                case RELEASED: 
                case ARCHIVED: {
                    this._eventBus.post(new EntityVersionAcceptedNoticedByAuthorEvent(updatedVersion));
                    break;
                }
            }
        }
    }

    @Override
    public ImmutableSetMultimap<EntityVersionId, PersonId> getReviewersForVersions(Set<EntityVersionId> versionIds) {
        if (versionIds.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        ImmutableListMultimap<EntityVersionId, DBEntityVersionReview> entityVersionReviewData = this._entityVersionReviewDAO.getReviewsForVersions(versionIds);
        ListMultimap transformed = Multimaps.transformValues(entityVersionReviewData, DBEntityVersionReview.REVIEWER_TO_PERSON_ID);
        return ImmutableSetMultimap.copyOf((Multimap)transformed);
    }

    @Override
    public ImmutableMap<EntityVersionId, MultiWikiVersionId> getMultiWikiVersionsForEntityVersions(Set<EntityVersionId> entityVersionsIds) {
        return this._entityVersionComponentsDao.getMultiWikiVersionsForEntityVersions(entityVersionsIds);
    }

    @Override
    public ImmutableSetMultimap<MultiWikiVersionId, EntityVersionId> getEntityVersionsForMultiWikiVersions(Set<MultiWikiVersionId> versionIds) {
        return this._entityVersionComponentsDao.getEntityVersionsForMultiWikiVersions(versionIds);
    }

    @Override
    public void createNewDraftVersionForMultiWikiVersion(EntityId parentId, MultiWikiVersionId currentMultiWikiVersionId, final MultiWikiVersionId newMultiWikiVersionId, final AuthorizationCheckContextWithUserId auth, final Consumer<? super DriveChangesConnectedEvent> eventConsumer) {
        EntityVersion newestVersion;
        ImmutableSet entityVersionIds = this._entityVersionComponentsDao.getEntityVersionsForMultiWikiVersions((Set<MultiWikiVersionId>)ImmutableSet.of((Object)currentMultiWikiVersionId)).get((Object)currentMultiWikiVersionId);
        if (!entityVersionIds.isEmpty() && (newestVersion = this.getNewestVersion(parentId)) != null) {
            EntityVersionId newestVersionId = newestVersion.getId();
            if (!entityVersionIds.contains((Object)newestVersionId)) {
                throw new ConcurrentUpdateException();
            }
            final DriveChangeId currentDriveChange = (DriveChangeId)this._entityVersionDriveChangeDAO.getDriveChangesForEntityVersions((Set<EntityVersionId>)ImmutableSet.of((Object)newestVersionId)).get((Object)newestVersionId);
            this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    EntityVersion newVersion = EntityVersionServiceImpl.this.newDraftFromVersionWithoutPermissionCheck(newestVersion, auth);
                    EntityVersionServiceImpl.this.setEntityVersionComponents(newVersion.getId(), newMultiWikiVersionId, currentDriveChange, eventConsumer);
                }
            });
        }
    }

    @Override
    public void createEntityVersionComponents(MultiWikiVersionId multiWikiVersionId, EntityVersionId entityVersionId, Consumer<? super DriveChangesConnectedEvent> eventConsumer) {
        this.setEntityVersionComponents(entityVersionId, multiWikiVersionId, null, eventConsumer);
    }

    @Override
    public void createEntityVersionComponents(MultiWikiVersionId multiWikiVersionId, EntityId parentId, Consumer<? super DriveChangesConnectedEvent> eventConsumer) {
        EntityVersion currentVersion = this.getNewestVersion(parentId);
        if (currentVersion != null) {
            this.createEntityVersionComponents(multiWikiVersionId, currentVersion.getId(), eventConsumer);
        }
    }

    private void setEntityVersionComponents(EntityVersionId entityVersionId, @Nullable MultiWikiVersionId multiWikiVersionId, @Nullable DriveChangeId driveChangeId, Consumer<? super DriveChangesConnectedEvent> eventConsumer) {
        if (multiWikiVersionId != null) {
            this._entityVersionComponentsDao.setVersionComponents(entityVersionId, multiWikiVersionId);
        }
        if (driveChangeId != null) {
            this._entityVersionDriveChangeDAO.setDriveChangeForVersion(entityVersionId, driveChangeId);
            eventConsumer.accept(new DriveChangesConnectedEvent((ImmutableMap<DriveChangeId, Optional<DateTime>>)ImmutableMap.of((Object)driveChangeId, (Object)Optional.absent())));
        }
    }

    @Override
    public ListAndCount<EntityVersion> getEntityVersions(EntityId entityId, int offset, int limit, AuthorizationCheckContext authCtx) {
        ImmutableSet<EntityStatus> visibleStatus = this.getEntityVersionStatusVisibleForUser(entityId, authCtx);
        return new ListAndCount<EntityVersion>(this._entityVersionReadWriteDataService.countVersionsForEntity(entityId, (Iterable<EntityStatus>)visibleStatus), (Collection<EntityVersion>)this._entityVersionReadWriteDataService.getVersionsForEntity(entityId, (Iterable<EntityStatus>)visibleStatus, offset, limit));
    }

    @Override
    public ImmutableSetMultimap<EntityVersionId, Action> getActionsForVersions(EntityId entityId, Iterable<EntityVersionId> versionIds, AuthorizationCheckContext authCtx) {
        ImmutableSet<Action> may = authCtx.may((ItemId)entityId, (ImmutableSet<? extends Action>)ImmutableSet.of((Object)StaticEntityAction.ENTITY_VERSION_DELETE_VERSION, (Object)StaticEntityAction.ENTITY_VERSION_EDIT_DRAFT));
        int count = this.getNumberOfVersions(entityId, authCtx);
        EntityVersionId latestPublishedVersion = this._entityVersionReadWriteDataService.getLatestVersionByType(entityId, EntityVersionType.MAJOR);
        ImmutableSetMultimap.Builder actionsForVersions = ImmutableSetMultimap.builder();
        for (EntityVersionId versionId : versionIds) {
            if (may.contains((Object)StaticEntityAction.ENTITY_VERSION_EDIT_DRAFT)) {
                actionsForVersions.put((Object)versionId, (Object)StaticEntityAction.ENTITY_VERSION_EDIT_DRAFT);
            }
            if (count <= 1 || versionId.equals(latestPublishedVersion) || !may.contains((Object)StaticEntityAction.ENTITY_VERSION_DELETE_VERSION)) continue;
            actionsForVersions.put((Object)versionId, (Object)StaticEntityAction.ENTITY_VERSION_DELETE_VERSION);
        }
        return actionsForVersions.build();
    }

    @Nonnull
    private ImmutableSet<EntityStatus> getEntityVersionStatusVisibleForUser(EntityId entityId, AuthorizationCheckContext authCtx) {
        ImmutableSet<EntityVersion> versions = this._entityVersionReadWriteDataService.getNewestVersions(entityId);
        FluentIterable allEntityStatus = FluentIterable.from(versions).transform(EntityVersion::getStatus);
        ImmutableSet actions = allEntityStatus.transform(EntityStatus::readAction).toSet();
        ImmutableSet<Action> allowed = authCtx.may((ItemId)entityId, (ImmutableSet<? extends Action>)actions);
        return allEntityStatus.filter(s -> allowed.contains((Object)s.readAction())).toSet();
    }

    private int getNumberOfVersions(EntityId entityId, AuthorizationCheckContext authCtx) {
        ImmutableSet<EntityStatus> visibleStatus = this.getEntityVersionStatusVisibleForUser(entityId, authCtx);
        return this._entityVersionReadWriteDataService.countVersionsForEntity(entityId, (Iterable<EntityStatus>)visibleStatus);
    }

    @Override
    public EntityId deleteVersion(EntityVersionId versionId, AuthorizationCheckContextWithUserId authCtx) {
        EntityVersion version = this.getVersionByIdNonNull(versionId);
        EntityId entityId = version.getEntityId();
        authCtx.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_VERSION_DELETE_VERSION);
        int count = this.getNumberOfVersions(entityId, authCtx);
        if (count == 1) {
            throw new PermissionDeniedException("It is not allowed to delete all versions of an entity");
        }
        if (versionId.equals(this._entityVersionReadWriteDataService.getLatestVersionByType(entityId, EntityVersionType.MAJOR))) {
            throw new PermissionDeniedException("It is not allowed to delete the latest major version of an entity");
        }
        PersonId actorId = authCtx.getUserId();
        ImmutableSet reviewers = this.getAllPossibleReviewers((Set<EntityId>)ImmutableSet.of((Object)entityId)).get((Object)entityId);
        this._deletionService.deleteInTransactionWithDeleteAction(versionId, actorId, (status, deleteAction) -> {
            this._entityVersionReadWriteDataService.delete(versionId);
            return this;
        });
        this._eventBus.post(new EntityVersionDeletedEvent(version));
        this._eventBus.post(new EntityReviewerChangedEvent(entityId, (ImmutableSet<PersonId>)reviewers));
        if (this.wasLastPublicVersion(version)) {
            this._eventBus.post(new EntityPrivacyChangedEvent(entityId, (ImmutableSet<DBPrivacyType>)ImmutableSet.copyOf((Object[])DBPrivacyType.values())));
        }
        return version.getEntityId();
    }

    private boolean wasLastPublicVersion(EntityVersion version) {
        if (version.getStatus().getName().equals(ReleaseProcessStatus.PUBLISHED.getName())) {
            return this.getNewestVersionWithStatus(version.getEntityId(), (Set<EntityStatus>)this._entityConfigService.getPublishedEntityStatus(version.getStatus().getEntityType())) == null;
        }
        return false;
    }

    @Override
    public EntityVersion restoreVersion(EntityVersionId versionId, AuthorizationCheckContextWithUserId authCtx) {
        ImmutableList.Builder events = ImmutableList.builder();
        EntityVersion result = this.restoreVersionInternal(this.getVersionByIdNonNull(versionId), authCtx, true, arg_0 -> ((ImmutableList.Builder)events).add(arg_0));
        this._eventBus.post((Iterable<? extends ServerEvent>)events.build());
        return result;
    }

    @Nonnull
    private EntityVersion restoreVersionInternal(EntityVersion version, AuthorizationCheckContextWithUserId authCtx, boolean requireAuthorizationCheck, Consumer<? super DriveChangesConnectedEvent> eventConsumer) {
        if (requireAuthorizationCheck) {
            authCtx.check((ItemId)version.getEntityId(), (Action)StaticEntityAction.ENTITY_VERSION_EDIT_DRAFT);
        }
        EntityVersionId versionId = version.getId();
        MultiWikiVersionId wikiVersionIdToRestore = (MultiWikiVersionId)this.getMultiWikiVersionsForEntityVersions((Set<EntityVersionId>)ImmutableSet.of((Object)versionId)).get((Object)versionId);
        DriveChangeId driveChange = (DriveChangeId)this._entityVersionDriveChangeDAO.getDriveChangesForEntityVersions((Set<EntityVersionId>)ImmutableSet.of((Object)versionId)).get((Object)versionId);
        return (EntityVersion)this._transactionHelper.doInTransaction(status -> {
            Integer newLastDriveChangeVersion;
            DriveChangeId restoredDriveChangeId;
            MultiWikiVersionId restoredWikiVersionId = this.restoreMultiWiki(version.getEntityId(), authCtx, wikiVersionIdToRestore);
            if (driveChange != null) {
                DriveRestoreChangeResponse restoredDriveChange = this._driveInternalApiConnector.restoreDriveChange(driveChange, authCtx.getUserId(), DriveRestorePurpose.RESTORE_ENTITY_VERSION);
                restoredDriveChangeId = restoredDriveChange.getChangeId();
                newLastDriveChangeVersion = restoredDriveChange.getVersion();
            } else {
                restoredDriveChangeId = null;
                newLastDriveChangeVersion = null;
            }
            EntityVersion restoredVersion = this.newDraftFromVersionWithoutPermissionCheck(version, authCtx);
            this.setEntityVersionComponents(restoredVersion.getId(), restoredWikiVersionId, restoredDriveChangeId, eventConsumer);
            if (newLastDriveChangeVersion != null) {
                this._entityService.updateLastDriveChangeVersion(version.getEntityId(), newLastDriveChangeVersion);
            }
            return restoredVersion;
        });
    }

    @CheckForNull
    private MultiWikiVersionId restoreMultiWiki(EntityId entityId, AuthorizationCheckContextWithUserId authCtx, @Nullable MultiWikiVersionId wikiVersionIdToRestore) {
        if (wikiVersionIdToRestore == null) {
            return null;
        }
        try {
            MultiWikiId wikiId = this._multiWikiService.getWikiIdByParentId(entityId);
            MultiWikiVersionId currentWikiVersionId = this._multiWikiService.getCurrentWikiVersionId(wikiId, authCtx);
            return this._multiWikiService.restoreVersion(wikiId, currentWikiVersionId, wikiVersionIdToRestore, authCtx);
        }
        catch (InvalidIDException e) {
            LOG.error("Trying to restore a multiWikiVersion, but no MultiWiki for wikiVersionId: " + wikiVersionIdToRestore, (Throwable)e);
            throw new InvalidIdServiceException("Trying to restore a multiWikiVersion, but no MultiWiki found");
        }
    }

    @CheckForNull
    private DriveChangeId getNewestDriveChange(EntityId entityId) {
        EntityVersion newestVersion = this.getNewestVersion(entityId);
        if (newestVersion == null) {
            return null;
        }
        return (DriveChangeId)this._entityVersionDriveChangeDAO.getDriveChangesForEntityVersions((Set<EntityVersionId>)ImmutableSet.of((Object)newestVersion.getId())).get((Object)newestVersion.getId());
    }

    @Override
    public EntityVersion releaseVersionForImport(EntityId entityId, MultiWikiVersionId wikiVersionId, String versionInfo, PersonId authorId, Date releaseDate, Date modifyDate, Date expirationDate, Date createDate, EntityVersionImportService.EntityImportType importType) {
        EntityVersion newestVersion = this.getNewestVersion(entityId);
        if (newestVersion == null) {
            return null;
        }
        DBEntityVersion version = new DBEntityVersion();
        version.setEntityId(entityId);
        version.setStatus(this.getStatusForStaticStatus(newestVersion.getStatus().getEntityType(), ReleaseProcessStatus.PUBLISHED));
        version.setAuthorId(authorId);
        version.setTargetType(EntityVersionType.MAJOR);
        version.setDeclineMessage(null);
        version.setReleaseDate(releaseDate != null ? DateWithoutTimezone.clone(releaseDate) : new DateWithoutTimezone());
        version.setCreateDate(createDate != null ? createDate : new Date());
        version.setModifyDate(modifyDate != null ? modifyDate : new Date());
        version.setExpirationDate(DateWithoutTimezone.clone(expirationDate));
        version.setChangeMessage(versionInfo);
        switch (importType) {
            case CREATE: {
                this._entityVersionComponentsDao.deleteVersionComponents((Set<EntityVersionId>)ImmutableSet.of((Object)newestVersion.getId()));
                version.setId(newestVersion.getId());
                version.setVersionType(EntityVersionType.MAJOR);
                version.setMinorVersion(0);
                version.setDraftVersion(0);
                version.setMajorVersion(1);
                break;
            }
            case UPDATE: {
                this.setNextVersion(newestVersion, EntityVersionType.MAJOR, version);
                this._entityVersionReadWriteDataService.create(version);
            }
        }
        ImmutableList.Builder events = ImmutableList.builder();
        this._transactionHelper.doInTransactionWithoutResult(t -> {
            this.setEntityVersionComponents(version.getId(), wikiVersionId, this.getNewestDriveChange(entityId), arg_0 -> ((ImmutableList.Builder)events).add(arg_0));
            this._entityVersionReadWriteDataService.updateForImport(version);
        });
        EntityVersion entityVersion = new EntityVersion(version);
        events.add((Object)new EntityVersionPublishedEvent(entityVersion, (ImmutableSet<PersonId>)ImmutableSet.of()));
        this._eventBus.post((Iterable<? extends ServerEvent>)events.build());
        return entityVersion;
    }

    @Override
    public void deleteDependentVersions(ImmutableSet<EntityVersionId> versionsToDelete) {
        this._entityVersionReadWriteDataService.deleteVersions((Set<EntityVersionId>)versionsToDelete);
    }

    @Override
    public void markAsArchived(final EntityVersionId versionId, final EntityStatus archivedStatus) {
        EntityVersionArchivedEvent event = this._transactionHelper.doInTransaction(new TransactionCallback<EntityVersionArchivedEvent>(){

            public EntityVersionArchivedEvent doInTransaction(TransactionStatus status) {
                EntityVersion version = EntityVersionServiceImpl.this._entityVersionReadWriteDataService.getById(versionId);
                if (version == null || version.getStatus().isArchived()) {
                    return null;
                }
                DBEntityVersion dbVersion = new DBEntityVersion(version);
                dbVersion.setStatus(archivedStatus);
                dbVersion.setModifyDate(EntityVersionServiceImpl.this._clock.now().toDate());
                EntityVersionServiceImpl.this._entityVersionReadWriteDataService.update(dbVersion);
                EntityVersionServiceImpl.this._archiveNoticeDao.deleteById(versionId);
                return new EntityVersionArchivedEvent(EntityVersionServiceImpl.this.getVersionByIdNonNull(versionId));
            }
        });
        if (event != null) {
            this._eventBus.post(event);
        }
    }

    @Override
    public void publishVersion(final EntityVersionId versionId) {
        final CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        Optional<DBEntityVersion> publishedVersion = this._transactionHelper.doInTransaction(new TransactionCallback<Optional<DBEntityVersion>>(){

            public Optional<DBEntityVersion> doInTransaction(TransactionStatus status) {
                EntityVersion version = EntityVersionServiceImpl.this._entityVersionReadWriteDataService.getById(versionId);
                if (version == null) {
                    return Optional.absent();
                }
                if (!version.getStatus().getName().equals(ReleaseProcessStatus.RELEASED.getName())) {
                    return Optional.absent();
                }
                EntityVersion newestPublicVersion = EntityVersionServiceImpl.this.getNewestVersionWithStatus(version.getEntityId(), (Set<EntityStatus>)EntityVersionServiceImpl.this._entityConfigService.getPublishedEntityStatus(version.getStatus().getEntityType()));
                if (newestPublicVersion != null && version.getId().before(newestPublicVersion.getId())) {
                    LOG.warn("stopped publishing of version: " + versionId + " as newer version " + newestPublicVersion.getId() + " is already published with status: " + newestPublicVersion.getStatus().getName() + "-" + newestPublicVersion.getId());
                    return Optional.absent();
                }
                EntityType entityType = version.getStatus().getEntityType();
                EntityVersionServiceImpl.this._entityVersionReadWriteDataService.updateStatusForEntityVersions(version.getEntityId(), (Set<EntityStatus>)ImmutableSet.of((Object)EntityVersionServiceImpl.this.getStatusForStaticStatus(entityType, ReleaseProcessStatus.PUBLISHED)), EntityVersionServiceImpl.this.getStatusForStaticStatus(entityType, ReleaseProcessStatus.ARCHIVED));
                DBEntityVersion dbVersion = new DBEntityVersion(version);
                dbVersion.setStatus(EntityVersionServiceImpl.this.getStatusForStaticStatus(entityType, ReleaseProcessStatus.PUBLISHED));
                dbVersion.setModifyDate(EntityVersionServiceImpl.this._clock.now().toDate());
                EntityVersionServiceImpl.this._entityVersionReadWriteDataService.update(dbVersion);
                ImmutableList reviews = EntityVersionServiceImpl.this._entityVersionReviewDAO.getReviewsForVersions((Set<EntityVersionId>)ImmutableSet.of((Object)versionId)).get((Object)versionId);
                ImmutableSet.Builder reviewers = ImmutableSet.builder();
                for (DBEntityVersionReview review : reviews) {
                    if (review == null) continue;
                    reviewers.add((Object)review.getReviewerId());
                }
                eventCollector.add(new EntityVersionPublishedEvent(new EntityVersion(dbVersion), (ImmutableSet<PersonId>)reviewers.build()));
                if (newestPublicVersion == null) {
                    eventCollector.add(new EntityPrivacyChangedEvent(dbVersion.getEntityId(), (ImmutableSet<DBPrivacyType>)ImmutableSet.of((Object)((Object)DBPrivacyType.VISIBILITY))));
                }
                return Optional.of((Object)dbVersion);
            }
        });
        if (publishedVersion.isPresent()) {
            this._entityVersionReadWriteDataService.clearIdCacheForVersions((Set<EntityVersionId>)ImmutableSet.of((Object)((DBEntityVersion)publishedVersion.get()).getId()));
            this._entityVersionReadWriteDataService.clearCacheForEntityId((Set<EntityId>)ImmutableSet.of((Object)((DBEntityVersion)publishedVersion.get()).getEntityId()));
        }
        eventCollector.fireEvents(this._eventBus);
    }

    @Override
    public ImmutableMap<EntityId, EntityVersion> getPublicVersions(ImmutableSet<EntityId> entityIds, AuthorizationCheckContext authCtx) {
        ImmutableSet<EntityId> publicVersionIds = authCtx.filterAllowedIds(entityIds, StaticEntityAction.ENTITY_READ_DETAILS);
        return this.getNewestVersionsWithStatus((Set<EntityId>)publicVersionIds, (Set<EntityStatus>)this._entityConfigService.getPublishedEntityStatus());
    }

    @Override
    public EntityVersion getLastPublicVersionBefore(EntityVersionId versionId) {
        return this._entityVersionReadWriteDataService.getLastNonDraftVersionBefore(versionId);
    }

    @Override
    public ListAndCount<EntityBadge> listDraftsForAuthor(int offset, int limit, AuthorizationCheckContextWithUserId auth) {
        ListAndCount<EntityId> draftsForPerson = this._entityVersionReadWriteDataService.getEntityDraftsForAuthor(offset, limit, auth.getUserId());
        return new ListAndCount<EntityBadge>(draftsForPerson.getMaxCount(), (Collection<EntityBadge>)CollectionUtil.mapToSortedList(this._entityService.getBadgesByIds(Sets.newHashSet(draftsForPerson), auth), draftsForPerson));
    }

    @Override
    public int getDraftCountForAuthor(AuthorizationCheckContextWithUserId auth) {
        return this._entityVersionReadWriteDataService.getDraftCountForAuthor(auth.getUserId());
    }

    @Override
    public ImmutableSet<JucoConstraintViolation> validateReviewDataForDefaultGroup(EntityVersionReviewData data, AuthorizationContext auth) {
        return this.validateReviewData(data, new Class[]{Default.class}, auth);
    }

    @Override
    public EntityVersion archiveEntity(EntityId entityId, EntityVersionId entityVersionId, AuthorizationContext auth) {
        auth.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_ARCHIVE);
        PersonId author = auth.getUserId();
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        EntityVersionReleaseDataOption changeMessageConfig = this._entityConfigService.getReleaseChangeMessageVisibility(entity.getType());
        String changeMessage = changeMessageConfig.isVisibleOption() ? this._i18nService.createProxy(EntityVersionConstants.class, auth.getLocale()).thisEntityHasBeenArchived(entity.getType()) : null;
        EntityVersionReleaseClientModel releaseData = new EntityVersionReleaseClientModel(author, entityVersionId, EntityVersionType.MAJOR, (List<PersonId>)ImmutableList.of((Object)author), changeMessage, null, new DateWithoutTimezone(), new DateWithoutTimezone());
        EntityVersion versionById = this._entityVersionReadWriteDataService.getById(entityVersionId);
        if (versionById == null) {
            throw new EntityVersionException();
        }
        if (versionById.getStatus().isArchived()) {
            throw new EntityVersionAlreadyArchivedException(this._i18nService.createProxy(EntityVersionConstants.class, auth.getLocale()).thisEntityHasAlreadyBeenArchived(entity.getType()));
        }
        ImmutableList.Builder events = ImmutableList.builder();
        DBEntityVersion result = (DBEntityVersion)this._transactionHelper.doInTransaction(t -> {
            DBEntityVersion versionToStage = this.createVersionWithoutValidation(versionById, releaseData, this.getStatusForStaticStatus(entity.getType(), ReleaseProcessStatus.IN_REVIEW), auth, arg_0 -> ((ImmutableList.Builder)events).add(arg_0));
            DBEntityVersionReview review = new DBEntityVersionReview();
            review.setEntityVersionId(versionToStage.getId());
            review.setReviewerId(author);
            review.setInviterId(author);
            review.setReviewStatus(EntityVersionReviewStatus.ACCEPTED);
            review.setReviewOrder(0);
            this._entityVersionReadWriteDataService.update(versionToStage);
            this._entityVersionReviewDAO.createReview(review);
            events.add((Object)new EntityReviewerChangedEvent(entityId));
            this.releaseVersion(new EntityVersion(versionToStage), false, auth, arg_0 -> ((ImmutableList.Builder)events).add(arg_0));
            return versionToStage;
        });
        this._eventBus.post((Iterable<? extends ServerEvent>)events.build());
        return this.getVersionByIdNonNull(result.getId());
    }

    @Override
    public ImmutableSet<EntityId> mayArchiveEntities(Set<EntityId> entities, AuthorizationCheckContext auth) {
        ImmutableSet<EntityId> allowed = auth.filterAllowedIds(entities, StaticEntityAction.ENTITY_ARCHIVE);
        ImmutableMap<EntityId, EntityVersion> currentVersions = this.getCurrentEntityVersions((Set<EntityId>)allowed, auth);
        Map notArchivedAndNotInReview = Maps.filterValues(currentVersions, (Predicate)new NullIsFalsePredicate<EntityVersion>(){

            @Override
            protected boolean applySafe(EntityVersion currentVersion) {
                return !currentVersion.getStatus().isArchived() && EntityVersionServiceImpl.this._entityConfigService.releaseProcessMandatory(currentVersion.getStatus().getEntityType()) && !currentVersion.getStatus().getName().equals(ReleaseProcessStatus.IN_REVIEW.getName());
            }
        });
        return ImmutableSet.copyOf(notArchivedAndNotInReview.keySet());
    }

    @Override
    public ImmutableMap<EntityId, DateWithoutTimezone> getPublicationDates(Set<EntityId> entityIds) {
        Predicate<DBEntity> isReleaseProcessMandatory = new Predicate<DBEntity>(){

            public boolean apply(@Nullable DBEntity input) {
                return input != null && EntityVersionServiceImpl.this._entityConfigService.releaseProcessMandatory(input.getType());
            }
        };
        Map<EntityId, DBEntity> entities = this._entityService.getByIds(entityIds);
        Set versionedEntities = Maps.filterValues(entities, (Predicate)isReleaseProcessMandatory).keySet();
        ImmutableMap<EntityId, EntityVersion> activePublicVersions = this.getNewestVersionsWithStatus(entityIds, (Set<EntityStatus>)this._entityConfigService.getPublishedEntityStatus());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EntityId entityId : entityIds) {
            if (versionedEntities.contains(entityId)) {
                DateWithoutTimezone releaseDate;
                EntityVersion version = (EntityVersion)activePublicVersions.get((Object)entityId);
                if (version == null || (releaseDate = version.getReleaseDate()) == null) continue;
                builder.put((Object)entityId, (Object)releaseDate);
                continue;
            }
            DBEntity dbEntity = entities.get(entityId);
            if (dbEntity == null) continue;
            builder.put((Object)entityId, (Object)new DateWithoutTimezone(dbEntity.getCreateDate()));
        }
        return builder.build();
    }

    @Override
    public ImmutableMap<EntityStatus, EntityVersion> getLatestVersionForStatus(EntityId entityId, Set<EntityStatus> status) {
        return this._entityVersionReadWriteDataService.getNewestVersionByStatus(entityId, status);
    }

    @Override
    public EntityStatus getStatusForStaticStatus(EntityType type, ReleaseProcessStatus staticStatus) {
        return (EntityStatus)FluentIterable.from(this._entityConfigService.getAvailableEntityStatus(type)).firstMatch(staticStatus::equalsEntityStatus).or((Object)this._entityConfigService.getDefaultStatusForEntityType(type));
    }

    @Override
    public void updateStatus(EntityVersionId entityVersionId, EntityStatus targetStatus, ImmutableSet<PersonId> personsToNotify, AuthorizationCheckContextWithUserId auth) {
        EntityVersion version = this.getVersionByIdNonNull(entityVersionId);
        if (version.getStatus().equals(targetStatus)) {
            return;
        }
        auth.check((ItemId)version.getEntityId(), (Action)StaticEntityAction.ENTITY_MODIFY);
        this._entityVersionReadWriteDataService.updateStatus(entityVersionId, targetStatus);
        this._eventBus.post(new EntityReviewerChangedEvent(version.getEntityId()));
        this._eventBus.post(new EntityVersionStatusUpdateEvent(this.getVersionByIdNonNull(entityVersionId), auth.getUserId(), personsToNotify));
    }

    @Override
    public void createEntityVersionsForDriveChanges(Iterable<NewDriveChangeEntityVersionModel> newChanges, Consumer<ServerEvent> eventConsumer) {
        ImmutableListMultimap perEntity = FluentIterable.from(newChanges).filter(c -> !DriveRestorePurpose.RESTORE_ENTITY_VERSION.equals(c.getPurpose())).index(NewDriveChangeEntityVersionModel::getEntityId);
        ImmutableMap<EntityId, Optional<Integer>> lastDriveChangeVersions = this._entityReadDataService.getLastDriveChangeVersions((Set<EntityId>)perEntity.keySet());
        Map entityTypes = Maps.transformValues(this._entityService.getByIds((Set<EntityId>)perEntity.keySet()), DBEntity::getType);
        ImmutableMap<EntityId, EntityVersion> newestVersions = this.getNewestVersion(entityTypes.keySet());
        ImmutableSet entityVersionsIds = FluentIterable.from((Iterable)newestVersions.values()).transform(EntityVersion::getId).toSet();
        ImmutableMap<EntityVersionId, MultiWikiVersionId> wikiVersions = this._entityVersionComponentsDao.getMultiWikiVersionsForEntityVersions((Set<EntityVersionId>)entityVersionsIds);
        HashMap<DriveChangeId, Optional<DateTime>> changes = new HashMap<DriveChangeId, Optional<DateTime>>();
        MigrationRunner migrationRunner = new MigrationRunner(changes);
        for (Map.Entry entry : perEntity.asMap().entrySet()) {
            EntityId entityId = (EntityId)entry.getKey();
            EntityType entityType = (EntityType)entityTypes.get(entityId);
            IEntityVersion lastVersion = (IEntityVersion)newestVersions.get((Object)entityId);
            if (entityType != null && lastVersion != null) {
                MultiWikiVersionId wikiVersion = (MultiWikiVersionId)wikiVersions.get((Object)lastVersion.getId());
                EntityStatus draftStatus = this.draftStatus(entityType);
                Optional lastDriveChangeFromDB = lastDriveChangeVersions.getOrDefault(entityId, (Optional)Optional.absent());
                Integer lastDriveChange = (Integer)lastDriveChangeFromDB.orNull();
                for (NewDriveChangeEntityVersionModel change : (Collection)entry.getValue()) {
                    DriveChangeId driveChangeId = change.getDriveChangeId();
                    changes.put(driveChangeId, change.getChangeDate());
                    if (lastDriveChange == null) {
                        migrationRunner.disconnectChanges();
                        lastDriveChange = change.getVersion();
                        this._entityVersionDriveChangeDAO.setInitialDriveChangeVersion(entityId, driveChangeId);
                        continue;
                    }
                    if (change.getVersion() <= lastDriveChange) continue;
                    if (DriveChangePurpose.DOCUMENT_TO_DRIVE_MIGRATION.equals(change.getPurpose())) {
                        lastDriveChange = change.getVersion();
                        migrationRunner.addMigratedChange(entityId, driveChangeId);
                        continue;
                    }
                    migrationRunner.disconnectChanges();
                    lastDriveChange = change.getVersion();
                    lastVersion = this.createNewVersion(lastVersion, change.getExecutedBy(), draftStatus);
                    if (wikiVersion != null) {
                        this._entityVersionComponentsDao.setVersionComponents(lastVersion.getId(), wikiVersion);
                    }
                    this._entityVersionDriveChangeDAO.setDriveChangeForVersion(lastVersion.getId(), driveChangeId);
                }
                if (!Objects.equals(lastDriveChange, lastDriveChangeFromDB.orNull())) {
                    this._entityService.updateLastDriveChangeVersion(entityId, lastDriveChange);
                }
            }
            migrationRunner.disconnectChanges();
        }
        eventConsumer.accept(new DriveChangesConnectedEvent((ImmutableMap<DriveChangeId, Optional<DateTime>>)ImmutableMap.copyOf(changes)));
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getEntityVersionReviewer(Set<EntityId> entities) {
        ImmutableSet<EntityStatus> inReviewStates = this.getInReviewStates();
        ImmutableSet inReviewStateIds = FluentIterable.from(inReviewStates).transform(Identifiable::getId).toSet();
        return this._entityVersionReviewDAO.getEntityVersionReviewer(entities, (Set<EntityStatusId>)inReviewStateIds);
    }

    @Override
    public int forAllReviewers(BiConsumer<EntityId, PersonId> consumer) {
        ImmutableSet<EntityStatus> entityStatus = this._entityConfigService.getAllEntityStatusForPredicate((Predicate<? super EntityStatus>)((Predicate)ReleaseProcessStatus.IN_REVIEW::equalsEntityStatus));
        if (entityStatus.isEmpty()) {
            return 0;
        }
        ImmutableSet inReviewStateIds = FluentIterable.from(entityStatus).transform(Identifiable::getId).toSet();
        return this._entityVersionReviewDAO.forAllReviewers((Set<EntityStatusId>)inReviewStateIds, consumer);
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getAllPossibleReviewers(Set<EntityId> entities) {
        return this._entityVersionReviewDAO.getAllPossibleReviewers(entities);
    }

    @Override
    public ImmutableSet<ComponentType> getChangedComponents(EntityVersionId version1, EntityVersionId version2) {
        ImmutableMap<EntityVersionId, MultiWikiVersionId> wikiVersions;
        if (version1.equals(version2)) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder componentBuilder = ImmutableSet.builder();
        ImmutableSet versions = ImmutableSet.of((Object)version1, (Object)version2);
        ImmutableMap<EntityVersionId, DriveChangeId> driveChanges = this._entityVersionDriveChangeDAO.getDriveChangesForEntityVersions((Set<EntityVersionId>)versions);
        if (!Objects.equals(driveChanges.get((Object)version1), driveChanges.get((Object)version2))) {
            componentBuilder.add((Object)StaticComponentType.DOCUMENT);
        }
        if (!Objects.equals((wikiVersions = this._entityVersionComponentsDao.getMultiWikiVersionsForEntityVersions((Set<EntityVersionId>)versions)).get((Object)version1), wikiVersions.get((Object)version2))) {
            componentBuilder.add((Object)StaticComponentType.MULTI_WIKI);
        }
        return componentBuilder.build();
    }

    @Override
    public EntityVersionId getFirstVersionForEntity(EntityId entityId) {
        return this._entityVersionReadWriteDataService.getFirstVersionForEntity(entityId);
    }

    @ParametersAreNonnullByDefault
    private class MigrationRunner {
        private final HashMap<DriveChangeId, Optional<DateTime>> _disconnectedChanges;
        private final HashMap<EntityId, DriveChangeId> _migratedChanges = new HashMap();

        MigrationRunner(HashMap<DriveChangeId, Optional<DateTime>> disconnectedChanges) {
            this._disconnectedChanges = disconnectedChanges;
        }

        void addMigratedChange(EntityId entityId, DriveChangeId driveChangeId) {
            this._migratedChanges.put(entityId, driveChangeId);
        }

        void disconnectChanges() {
            if (!this._migratedChanges.isEmpty()) {
                ImmutableSetMultimap<EntityId, DriveChangeId> changesToDisconnect = EntityVersionServiceImpl.this._entityVersionDriveChangeDAO.getDriveChangesForEntity(this._migratedChanges.keySet());
                changesToDisconnect.values().forEach(changeId -> this._disconnectedChanges.putIfAbsent((DriveChangeId)changeId, (Optional<DateTime>)Optional.absent()));
                this._migratedChanges.forEach(EntityVersionServiceImpl.this._entityVersionDriveChangeDAO::updateDriveChangeForAllEntityVersions);
                this._migratedChanges.clear();
            }
        }
    }
}

