/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.container.business.EntityAdministrationWorkflowService;
import de.justsoftware.onx.container.business.EntityVersionPublisherForTest;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.events.EntityVersionReleaseEvent;
import de.justsoftware.onx.container.business.events.EntityVersionWillGetArchivedEvent;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.integration.persistence.EntityVersionArchiveNoticeDAO;
import de.justsoftware.onx.container.integration.persistence.EntityVersionDAO;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.ReleaseProcessStatus;
import de.justsoftware.onx.server.business.ClusterConfiguration;
import de.justsoftware.toolbox.clock.Clock;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.TaskScheduler;

@Lazy(value=false)
@ParametersAreNonnullByDefault
public class EntityVersionPublisherImpl
implements ServerEventHandler,
EntityVersionPublisherForTest {
    public static final Logger LOG = LoggerFactory.getLogger(EntityVersionPublisherImpl.class);
    protected static final int DAYS_BEFORE_EXPIRATION_NOTICE = 30;
    protected static final long DEFAULT_REFRESH_RATE = TimeUnit.HOURS.toMillis(1L);
    protected static final int SCHEDULE_OFFSET_IN_SECONDS = 30;
    private final EntityVersionDAO _entityVersionDao;
    private final EntityVersionService _entityVersionService;
    private final Clock _clock;
    private final TaskScheduler _taskScheduler;
    private final EntityAdministrationWorkflowService _entityAdministrationService;
    private final ClusterConfiguration _clusterConfiguration;
    private final EntityVersionArchiveNoticeDAO _archiveNoticeDAO;
    private final JCEventBus _eventBus;
    private long _refreshIntervalInMillis = DEFAULT_REFRESH_RATE;

    @Autowired
    public EntityVersionPublisherImpl(EntityVersionDAO entityVersionDao, EntityVersionService entityVersionService, Clock clock, @Qualifier(value="jucoScheduler") TaskScheduler taskScheduler, EntityAdministrationWorkflowService entityAdministrationService, ClusterConfiguration clusterConfiguration, EntityVersionArchiveNoticeDAO entityVersionArchiveNoticeDAO, JCEventBus eventBus) {
        this._entityVersionDao = entityVersionDao;
        this._entityVersionService = entityVersionService;
        this._clock = clock;
        this._taskScheduler = taskScheduler;
        this._entityAdministrationService = entityAdministrationService;
        this._clusterConfiguration = clusterConfiguration;
        this._archiveNoticeDAO = entityVersionArchiveNoticeDAO;
        this._eventBus = eventBus;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        if (this._refreshIntervalInMillis > 0L) {
            this._taskScheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    EntityVersionPublisherImpl.this.refresh();
                }
            }, this._clock.now().toDate(), this._refreshIntervalInMillis);
        }
    }

    @Override
    public void refresh() {
        if (!this._clusterConfiguration.isMaster()) {
            return;
        }
        DateTime nextRefresh = this._clock.now().plus(this._refreshIntervalInMillis);
        ImmutableList<EntityVersion> versions = this._entityVersionDao.getReleasedVersions(nextRefresh.toDate());
        for (EntityVersion version : versions) {
            this.scheduleEntityVersionPublishing(version, true);
        }
        ImmutableList<EntityVersion> pubishedVersions = this._entityVersionDao.getPublishedVersionsWithExpirationDate(nextRefresh.toDate());
        for (EntityVersion version : pubishedVersions) {
            this.scheduleEntityVersionArchiving(version, true);
        }
        DateTime earliestArchiveTimeForNotification = this._clock.now().plusDays(30);
        DateTime latestArchiveTimeForNotification = earliestArchiveTimeForNotification.plus(this._refreshIntervalInMillis);
        ImmutableList<EntityVersion> versionsForArchiveNotifications = this._entityVersionDao.getPublishedVersionsWithExpirationDateBetween(earliestArchiveTimeForNotification.toDate(), latestArchiveTimeForNotification.toDate());
        for (EntityVersion version : versionsForArchiveNotifications) {
            this.scheduleArchiveNoticeNotification(version, true);
        }
    }

    private void scheduleEntityVersionPublishing(EntityVersion version, boolean withOffset) {
        DateWithoutTimezone releaseDate = version.getReleaseDate();
        if (releaseDate != null) {
            DateTime now = this._clock.now();
            DateTime releaseTime = new DateTime((Object)releaseDate);
            final EntityVersionId versionId = version.getId();
            if (now.isBefore((ReadableInstant)releaseTime)) {
                this.schedule(new Runnable(){

                    @Override
                    public void run() {
                        EntityVersionPublisherImpl.this._entityVersionService.publishVersion(versionId);
                    }
                }, releaseTime, withOffset);
                return;
            }
        }
        this._entityVersionService.publishVersion(version.getId());
    }

    private void schedule(Runnable task, DateTime time, boolean withOffset) {
        this._taskScheduler.schedule(task, withOffset ? time.plusSeconds(30).toDate() : time.toDate());
    }

    private void scheduleEntityVersionArchiving(EntityVersion version, boolean withOffset) {
        DateTime now = this._clock.now();
        DateTime expireTime = new DateTime(Preconditions.checkNotNull((Object)version.getExpirationDate()));
        final EntityVersionId versionId = version.getId();
        final EntityStatus archiveStatus = this._entityVersionService.getStatusForStaticStatus(version.getStatus().getEntityType(), ReleaseProcessStatus.ARCHIVED);
        if (now.isBefore((ReadableInstant)expireTime)) {
            this.schedule(new Runnable(){

                @Override
                public void run() {
                    EntityVersionPublisherImpl.this._entityVersionService.markAsArchived(versionId, archiveStatus);
                }
            }, expireTime, withOffset);
        } else {
            this._entityVersionService.markAsArchived(versionId, archiveStatus);
        }
    }

    private void scheduleArchiveNoticeNotification(EntityVersion version, boolean withOffset) {
        DateTime now = this._clock.now();
        DateTime expireTime = new DateTime((Object)version.getExpirationDate());
        DateTime archiveNotificationTime = expireTime.minusDays(30);
        if (archiveNotificationTime.isEqual((ReadableInstant)now) || archiveNotificationTime.isAfter((ReadableInstant)now)) {
            this.schedule(new ArchiveNotificationRunnable(version.getId()), archiveNotificationTime, withOffset);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleEntityVersionReleaseEvent(EntityVersionReleaseEvent event) {
        this.scheduleEntityVersionPublishing(event.getVersion(), false);
        if (event.getVersion().getExpirationDate() != null) {
            this.scheduleEntityVersionArchiving(event.getVersion(), false);
            this.scheduleArchiveNoticeNotification(event.getVersion(), false);
        }
    }

    public void setRefreshIntervalInMinutes(int refreshIntervalInMinutes) {
        this._refreshIntervalInMillis = TimeUnit.MINUTES.toMillis(refreshIntervalInMinutes);
    }

    @ParametersAreNonnullByDefault
    private final class ArchiveNotificationRunnable
    implements Runnable {
        private final EntityVersionId _versionId;

        public ArchiveNotificationRunnable(EntityVersionId versionId) {
            this._versionId = versionId;
        }

        @Override
        public void run() {
            EntityMember admin;
            if (EntityVersionPublisherImpl.this._archiveNoticeDAO.exists(this._versionId)) {
                return;
            }
            EntityVersion version = EntityVersionPublisherImpl.this._entityVersionService.getVersionById(this._versionId);
            if (version != null && version.getStatus().getName().equals(ReleaseProcessStatus.PUBLISHED.getName()) && (admin = EntityVersionPublisherImpl.this._entityAdministrationService.getAdmin(version.getEntityId())) != null) {
                EntityVersionPublisherImpl.this._archiveNoticeDAO.insert(this._versionId);
                EntityVersionPublisherImpl.this._eventBus.post(new EntityVersionWillGetArchivedEvent(admin.getPersonId(), version, 30));
            }
        }
    }
}

