/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityVersionPublishedStreamHandler;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.business.AbstractSingleWorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.EntityVersionPublished;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="entityVersionPublishedStreamHandler")
public class EntityVersionPublishedStreamHandlerImpl
extends AbstractSingleWorkstreamMessageHandler<EntityVersionPublished>
implements EntityVersionPublishedStreamHandler {
    @Autowired
    private EntityVersionService _entityVersionService;
    @Autowired
    private EntityService _entityService;

    @Override
    public ImmutableSetMultimap<String, String> attributesToDelete(Set<? extends ItemId> itemIds) {
        return EntityVersionPublishedStreamHandlerImpl.attributesToDelete(itemIds, "VERSION_ID_KEY", EntityVersionId.class);
    }

    @Override
    public EntityVersionPublished aggregate(EntityVersionPublished oldEntry, EntityVersionPublished newEntry) {
        return newEntry;
    }

    @Override
    public boolean isAggregatePossible() {
        return true;
    }

    @Override
    public EntityVersionPublished convert(DBWorkstreamMessage m, PersonTeaserModel author, ImmutableSet<Action> may, AuthorizationCheckContextWithLocale authorizationContext) {
        String versionStringId = m.getAttribute("VERSION_ID_KEY");
        EntityVersionId entityVersionId = EntityVersionId.parse(versionStringId);
        if (entityVersionId == null) {
            return null;
        }
        EntityVersion version = this._entityVersionService.getVersionById(entityVersionId);
        if (version == null) {
            return null;
        }
        DBEntity entity = this._entityService.getById(version.getEntityId());
        if (entity == null) {
            return null;
        }
        return new EntityVersionPublished(new EntityVersionClientModel(version), entity, m, author, may);
    }
}

