/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.deletion.CascadeDeleteService;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityVersionDeletionHandler;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.integration.persistence.EntityVersionDAO;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.ItemId;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityVersionDeletionHandlerImpl
implements EntityVersionDeletionHandler {
    @Autowired
    private EntityVersionService _entityVersionService;
    @Autowired
    private EntityVersionDAO _entityVersionDAO;
    @Autowired
    private CascadeDeleteService _cascadeDeleteService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        Iterable entityIds = Iterables.filter(parentIds, EntityId.class);
        if (!CollectionUtil.isEmpty(entityIds)) {
            ImmutableSet.Builder versionBuilder = ImmutableSet.builder();
            for (EntityId entityId : entityIds) {
                versionBuilder.addAll(deletionContext.filterItemsNotYetDeleted(this._entityVersionDAO.getAllVersionsForEntity(entityId)));
            }
            ImmutableSet versionsToDelete = versionBuilder.build();
            if (!versionsToDelete.isEmpty()) {
                this._cascadeDeleteService.cascadeDelete((Set<? extends ItemId>)versionsToDelete, deletionContext);
                this._entityVersionService.deleteDependentVersions((ImmutableSet<EntityVersionId>)versionsToDelete);
            }
        }
    }
}

