/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.cache.AbstractMapLoadingCacheAccessor;
import de.justsoftware.onx.container.business.EntityTypeAppMappingService;
import de.justsoftware.onx.container.integration.persistence.EntityTypeAppMappingDAO;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.toolbox.stream.EntryCollectors;
import de.justsoftware.toolbox.stream.EntryStream;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityTypeAppMappingServiceImpl
implements EntityTypeAppMappingService {
    private final EntityConfigService _entityConfigService;
    private final EntityTypeAppMappingCacheAccessor _entityTypeAppMappingCacheAccessor;
    private final EntityTypeAppMappingDAO _entityTypeAppMappingDAO;

    @Autowired
    public EntityTypeAppMappingServiceImpl(EntityConfigService entityConfigService, EhcacheClient ehCache, EntityTypeAppMappingDAO entityTypeAppMappingDAO) {
        this._entityConfigService = entityConfigService;
        this._entityTypeAppMappingDAO = entityTypeAppMappingDAO;
        this._entityTypeAppMappingCacheAccessor = new EntityTypeAppMappingCacheAccessor(ehCache, entityTypeAppMappingDAO);
    }

    @Override
    public ImmutableSet<EntityType> getEntityTypesForApp(CoreApp app) {
        return (ImmutableSet)this.getMappingForAllActivatedTypes().entrySet().stream().filter(entry -> ((CoreApp)((Object)((Object)entry.getValue()))).equals((Object)app)).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private ImmutableMap<EntityType, CoreApp> getMappingForAllActivatedTypes() {
        return this._entityTypeAppMappingCacheAccessor.getMap(this._entityConfigService.getOrderedActivatedEntityTypes());
    }

    @Override
    public CoreApp getAppForEntityType(EntityType entityType) {
        CoreApp app = (CoreApp)((Object)this._entityTypeAppMappingCacheAccessor.getSingle(entityType));
        return app == null ? CoreApp.ENTITY_DEFAULT : app;
    }

    @Override
    public void setAppForEntityType(EntityType entityType, AppId appId) {
        if (CoreApp.byAppId(appId) == null) {
            throw new IllegalArgumentException("Invalid core app with id " + appId);
        }
        this._entityTypeAppMappingDAO.setMapping(entityType, appId);
        this._entityTypeAppMappingCacheAccessor.invalidateKeyAndWait(entityType);
    }

    private static class EntityTypeAppMappingCacheAccessor
    extends AbstractMapLoadingCacheAccessor<EntityTypeAppMappingEhcacheName, EntityType, CoreApp> {
        private final EntityTypeAppMappingDAO _dao;

        EntityTypeAppMappingCacheAccessor(@Nonnull EhcacheClient cache, EntityTypeAppMappingDAO entityTypeAppMappingDAO) {
            super(cache, EntityTypeAppMappingEhcacheName.ENTITY_TYPE_APP_MAPPING);
            this._dao = entityTypeAppMappingDAO;
        }

        @Override
        protected Map<? extends EntityType, ? extends CoreApp> getFromDatabaseMulti(Set<? extends EntityType> inputs) {
            ImmutableMap entityTypeMappings = (ImmutableMap)EntryStream.from(this._dao.getMapping(inputs)).mapValue(CoreApp::byAppId).collect(EntryCollectors.toImmutableMap());
            return (Map)inputs.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), entityType -> (CoreApp)((Object)((Object)entityTypeMappings.getOrDefault(entityType, (Object)CoreApp.ENTITY_DEFAULT)))));
        }

        @Override
        protected String keyToString(EntityType input) {
            return input.toString();
        }
    }

    public static enum EntityTypeAppMappingEhcacheName implements EhCacheName
    {
        ENTITY_TYPE_APP_MAPPING;


        @Override
        public String getCacheName() {
            return this.name();
        }
    }
}

