/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.cache.AbstractSetMultiMapCacheAccessor;
import de.justsoftware.onx.container.business.EntityStatusReadWriteDataService;
import de.justsoftware.onx.container.integration.persistence.EntityStatusDAO;
import de.justsoftware.onx.container.integration.persistence.model.DBEntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.process.business.model.EntityStatusTemplate;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EntityStatusReadWriteDataServiceImpl
implements EntityStatusReadWriteDataService {
    private final EntityStatusDAO _entityStatusDAO;
    private final EntityStatusByEntityTypeCacheAccessor _entityStatusCache;

    @Autowired
    public EntityStatusReadWriteDataServiceImpl(EhcacheClient ehcacheClient, EntityStatusDAO entityStatusDAO) {
        this._entityStatusDAO = entityStatusDAO;
        this._entityStatusCache = new EntityStatusByEntityTypeCacheAccessor(ehcacheClient, this._entityStatusDAO);
    }

    @Override
    public ImmutableMultimap<EntityType, EntityStatus> getStatusForEntityTypes(Set<EntityType> types) {
        return this._entityStatusCache.getMultiMap(types);
    }

    @Override
    public ImmutableSet<EntityStatus> getStatusForEntityType(EntityType type) {
        return (ImmutableSet)this._entityStatusCache.getSingle(type);
    }

    @Override
    public EntityStatusId insertStatus(DBEntityStatus status) {
        EntityStatusId id = this._entityStatusDAO.insert(status);
        this._entityStatusCache.invalidateKeyAndWait(status.getEntityType());
        return id;
    }

    @Override
    public void deleteStatus(Set<EntityStatusId> ids) {
        this._entityStatusDAO.deleteStatus(ids);
        this._entityStatusCache.invalidateAll();
    }

    @Override
    public void updateStatus(EntityStatus status, EntityStatusTemplate updateModel) {
        this._entityStatusDAO.updateStatus((DBEntityStatus)DBEntityStatus.TO_DB_STATUS.apply((Object)status), updateModel);
        this._entityStatusCache.invalidateAll();
    }

    @ParametersAreNonnullByDefault
    private static class EntityStatusByEntityTypeCacheAccessor
    extends AbstractSetMultiMapCacheAccessor<EntityStatusEhCacheName, EntityType, EntityStatus> {
        private final EntityStatusDAO _dao;

        protected EntityStatusByEntityTypeCacheAccessor(CacheClient<? super EntityStatusEhCacheName> cache, EntityStatusDAO dao) {
            super(cache, EntityStatusEhCacheName.STATUS_BY_TYPE);
            this._dao = dao;
        }

        @Override
        protected EntityType objectToKey(EntityStatus dbResult) {
            return dbResult.getEntityType();
        }

        @Override
        protected Iterable<EntityStatus> getListFromDatabase(Set<? extends EntityType> inputs) {
            return FluentIterable.from(this._dao.getStatusForEntityType(inputs)).transform(DBEntityStatus.TO_BUSINESS_STATUS).toList();
        }

        @Override
        protected String keyToString(EntityType key) {
            return key.getName();
        }
    }

    public static enum EntityStatusEhCacheName implements EhCacheName
    {
        STATUS_BY_TYPE("EntityStatus.entityType");

        private final String _prefix;

        private EntityStatusEhCacheName(String prefix) {
            this._prefix = prefix;
        }

        @Override
        public String getCacheName() {
            return this._prefix;
        }
    }
}

