/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.authorization.business.Roles;
import de.justsoftware.onx.authorization.business.StaticPredefinedRole;
import de.justsoftware.onx.authorization.business.StaticRole;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityRolePublisher;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.events.EntityAdminChangedEvent;
import de.justsoftware.onx.container.business.events.EntityMemberRolesChangedEvent;
import de.justsoftware.onx.container.business.events.EntityMembershipChangedEvent;
import de.justsoftware.onx.container.business.events.EntityReviewerChangedEvent;
import de.justsoftware.onx.container.integration.persistence.EntityDAO;
import de.justsoftware.onx.container.integration.persistence.EntityMemberRoleDAO;
import de.justsoftware.onx.container.integration.persistence.model.DBEntityMemberIdAndRole;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.person.business.JustRolesKafkaProducer;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EntityRolePublisherImpl
implements ServerEventHandler,
EntityRolePublisher {
    private final JustRolesKafkaProducer _personRolePublisher;
    private final EntityMemberRoleDAO _entityMemberRoleDAO;
    private final EntityDAO _entityDAO;
    private final EntityVersionService _entityVersionService;

    @Autowired
    public EntityRolePublisherImpl(JustRolesKafkaProducer personRolePublisher, EntityMemberRoleDAO entityMemberRoleDao, EntityDAO entityDao, EntityVersionService entityVersionService) {
        this._personRolePublisher = personRolePublisher;
        this._entityMemberRoleDAO = entityMemberRoleDao;
        this._entityDAO = entityDao;
        this._entityVersionService = entityVersionService;
    }

    private void publish(PersonId personId, EntityId entityId, Set<EntityMemberRole> newRoles, Set<EntityMemberRole> oldRoles) {
        ImmutableSet newStaticRoles = FluentIterable.from(newRoles).transformAndConcat(arg_0 -> ((ImmutableSetMultimap)Roles.STATIC_ROLE_MAPPING.inverse()).get(arg_0)).toSet();
        ImmutableSet allRoles = FluentIterable.from(oldRoles).transformAndConcat(arg_0 -> ((ImmutableSetMultimap)Roles.STATIC_ROLE_MAPPING.inverse()).get(arg_0)).append((Iterable)newStaticRoles).toSet();
        allRoles.forEach(r -> this.publish(personId, (StaticRole)r, entityId, newStaticRoles.contains(r)));
    }

    private void publish(PersonId personId, StaticRole role, EntityId entityId, boolean added) {
        this._personRolePublisher.publishRole(personId, role.getName() + "," + entityId.getId(), added);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityMemberRolesChangedEvent(EntityMemberRolesChangedEvent ev) {
        this.publish(ev.getPersonId(), ev.getEntityId(), (Set<EntityMemberRole>)ev.getNewRoles(), (Set<EntityMemberRole>)ev.getOldRoles());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityMembershipChanged(EntityMembershipChangedEvent ev) {
        Sets.union((Set)ev.getNewRoles().keySet(), (Set)ev.getOldRoles().keySet()).forEach(personId -> this.publish((PersonId)personId, ev.getEntityId(), (Set<EntityMemberRole>)ev.getNewRoles().get(personId), (Set<EntityMemberRole>)ev.getOldRoles().get(personId)));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityAdminChanged(EntityAdminChangedEvent ev) {
        this.publish(ev.getPersonId(), ev.getEntityId(), (Set<EntityMemberRole>)ev.getNewRoles(), (Set<EntityMemberRole>)ev.getOldRoles());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityReviewerChangedEvent(EntityReviewerChangedEvent e) {
        EntityId entityId = e.getEntityId();
        ImmutableSet oldReviewersFromEvent = e.getOldReviewers();
        ImmutableSet oldReviewers = oldReviewersFromEvent != null ? oldReviewersFromEvent : this._entityVersionService.getAllPossibleReviewers((Set<EntityId>)ImmutableSet.of((Object)entityId)).get((Object)entityId);
        ImmutableSet reviewers = this._entityVersionService.getEntityVersionReviewer((Set<EntityId>)ImmutableSet.of((Object)entityId)).get((Object)entityId);
        Sets.union((Set)oldReviewers, (Set)reviewers).forEach(reviewer -> this.publish((PersonId)reviewer, StaticPredefinedRole.ENTITY_VERSION_REVIEWER, entityId, reviewers.contains(reviewer)));
    }

    @Override
    public int publishAllMemberRoles() {
        return this._entityMemberRoleDAO.forAllEntityMemberRoles(this::publishEntityMemberRow);
    }

    private void publishEntityMemberRow(DBEntityMemberIdAndRole row) {
        this.publish(row.getPersonId(), row.getEntityId(), (Set<EntityMemberRole>)ImmutableSet.of((Object)row.getRole()), (Set<EntityMemberRole>)ImmutableSet.of());
    }

    @Override
    public int publishAllEntityAssignees() {
        return this._entityDAO.forAllAssignedEntities((entityId, assigneeId) -> this.publish((PersonId)assigneeId, StaticPredefinedRole.ENTITY_ASSIGNEE, (EntityId)entityId, true));
    }

    @Override
    public int publishAllEntityReviewers() {
        return this._entityVersionService.forAllReviewers((entityId, reviewer) -> this.publish((PersonId)reviewer, StaticPredefinedRole.ENTITY_VERSION_REVIEWER, (EntityId)entityId, true));
    }
}

