/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityRecommendationReadWriteDataService;
import de.justsoftware.onx.container.business.impl.EntityRecommendationDeletionHandler;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityRecommendationDeletionHandlerImpl
implements EntityRecommendationDeletionHandler {
    private final EntityRecommendationReadWriteDataService _recommendationDataService;

    @Autowired
    public EntityRecommendationDeletionHandlerImpl(@Nonnull EntityRecommendationReadWriteDataService recommendationDataService) {
        this._recommendationDataService = recommendationDataService;
    }

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        if (!CollectionUtil.isEmpty(parentIds)) {
            Iterable entityIds = Iterables.filter(parentIds, EntityId.class);
            this._recommendationDataService.removeRecommendationsByEntityIds((Set<EntityId>)ImmutableSet.copyOf((Iterable)entityIds));
            Iterable profileIds = Iterables.filter(parentIds, ProfileId.class);
            ImmutableSet personIds = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)profileIds, ProfileId.TO_PERSON_ID));
            this._recommendationDataService.removeRecommendationsByPersonIds((Set<PersonId>)personIds);
        }
    }
}

