/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.container.business.EntityChildrenService;
import de.justsoftware.onx.container.business.EntityPermissionService;
import de.justsoftware.onx.container.business.EntityPrivacySettingsPublisher;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityTypeAppMappingService;
import de.justsoftware.onx.container.business.events.EntityComponentPositionsChangedEvent;
import de.justsoftware.onx.container.business.events.EntityCreatedEvent;
import de.justsoftware.onx.container.business.events.EntityParentsChangedEvent;
import de.justsoftware.onx.container.business.events.EntityPrivacyChangedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionUpdateEvent;
import de.justsoftware.onx.container.business.events.ItemDeletedEvent;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import de.justsoftware.onx.drive.business.DriveAction;
import de.justsoftware.onx.drive.business.ItemPrivacyProducer;
import de.justsoftware.onx.workstream.business.WorkstreamMessageVisibilityPublisher;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EntityPrivacySettingsPublisherImpl
implements EntityPrivacySettingsPublisher,
ServerEventHandler {
    static final ImmutableSet<DriveAction> ALL_DRIVE_ACTIONS = ImmutableSet.copyOf((Object[])DriveAction.values());
    private static final int PARTITION_SIZE = 100;
    private final EntityChildrenService _entityChildrenService;
    private final EntityConfigService _entityConfigService;
    private final EntityService _entityService;
    private final ItemPrivacyProducer _itemPrivacyProducer;
    private final WorkstreamMessageVisibilityPublisher _workstreamMessageVisibilityPublisher;
    private final EntityPermissionService _entityPermissionsService;
    private final EntityTypeAppMappingService _entityTypeAppMappingService;

    @Autowired
    public EntityPrivacySettingsPublisherImpl(ItemPrivacyProducer itemPrivacyProducer, EntityChildrenService entityChildrenService, EntityConfigService entityConfigService, EntityService entityService, WorkstreamMessageVisibilityPublisher workstreamMessageVisibilityPublisher, EntityPermissionService entityPermissionsService, EntityTypeAppMappingService entityTypeAppMappingService) {
        this._itemPrivacyProducer = itemPrivacyProducer;
        this._entityChildrenService = entityChildrenService;
        this._entityConfigService = entityConfigService;
        this._entityService = entityService;
        this._workstreamMessageVisibilityPublisher = workstreamMessageVisibilityPublisher;
        this._entityPermissionsService = entityPermissionsService;
        this._entityTypeAppMappingService = entityTypeAppMappingService;
    }

    private void send(Set<EntityId> entityIds) {
        if (!this._itemPrivacyProducer.isReady() || entityIds.isEmpty()) {
            return;
        }
        Function<EntityId, ImmutableMap<DriveAction, BoolExpr>> expressionsForEntity = this._entityPermissionsService.expressionsForEntityFunction(entityIds, (Set<DriveAction>)ALL_DRIVE_ACTIONS);
        for (EntityId id : entityIds) {
            this._itemPrivacyProducer.send(id, (Map)expressionsForEntity.apply(id));
        }
        this._workstreamMessageVisibilityPublisher.publishVisibilityForScheduledPosts(entityIds);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onEntityParentsChanged(EntityParentsChangedEvent e) {
        if (this._itemPrivacyProducer.isReady()) {
            ImmutableSet.Builder toUpdate = ImmutableSet.builder();
            if (e.isAdminInheritanceChanged()) {
                toUpdate.addAll((Iterable)this._entityChildrenService.getAdminInheritedEntityChildrenByParentIds((ImmutableSet<EntityId>)ImmutableSet.of((Object)e.getEntityId())).values());
            }
            if (e.isAdminInheritanceChanged() || e.isMemberInheritanceChanged()) {
                toUpdate.add((Object)e.getEntityId());
                toUpdate.addAll((Iterable)this._entityChildrenService.getMemberInheritedEntityChildrenByParentIds((ImmutableSet<EntityId>)ImmutableSet.of((Object)e.getEntityId())).values());
            }
            this.send((Set<EntityId>)toUpdate.build());
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onComponentSettingsChanged(EntityComponentPositionsChangedEvent e) {
        this.send((Set<EntityId>)ImmutableSet.of((Object)e.getEntityId()));
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onPrivacySettingsChanged(EntityPrivacyChangedEvent e) {
        if (e.getChangedPrivacies().contains((Object)DBPrivacyType.VISIBILITY) || e.getChangedPrivacies().contains((Object)DBPrivacyType.ENTITY_EDIT)) {
            this.send((Set<EntityId>)ImmutableSet.of((Object)e.getEntityId()));
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onEntityCreated(EntityCreatedEvent e) {
        this.send((Set<EntityId>)ImmutableSet.of((Object)e.getEntityId()));
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onEntityVersionUpdateEvent(EntityVersionUpdateEvent e) {
        this.send((Set<EntityId>)ImmutableSet.of((Object)e.getVersion().getEntityId()));
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onItemDeleted(ItemDeletedEvent e) {
        GlobalId itemId = e.getItemId();
        if (itemId instanceof EntityId) {
            this._itemPrivacyProducer.sendDelete(itemId);
        }
    }

    @Override
    public void republishAllEntities() {
        this._itemPrivacyProducer.republish(() -> {
            for (EntityType t : this._entityConfigService.getOrderedActivatedEntityTypes()) {
                CoreApp appForEntityType = this._entityTypeAppMappingService.getAppForEntityType(t);
                for (List ids : Iterables.partition(this._entityService.getEntityIdsByType(t), (int)100)) {
                    ImmutableSet entityIds = ImmutableSet.copyOf((Collection)ids);
                    this.send((Set<EntityId>)entityIds);
                    if (appForEntityType != CoreApp.ARCHIVED_NEWS) continue;
                    this._workstreamMessageVisibilityPublisher.publishVisibilitiesForPublishedPosts((Set<EntityId>)entityIds);
                }
            }
        });
    }
}

