/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.ItemIdAndAction;
import de.justsoftware.onx.authorization.business.StaticPredefinedRole;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.common.shared.model.Authority;
import de.justsoftware.onx.common.shared.model.NameAndParam;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.business.EntityChildrenService;
import de.justsoftware.onx.container.business.EntityPermissionService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.drive.business.DriveAction;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.toolbox.guava.collect.Multimaps2;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class EntityPermissionServiceImpl
implements EntityPermissionService {
    private static final Logger LOG = LoggerFactory.getLogger(EntityPermissionServiceImpl.class);
    private static final ImmutableSet<Role> ENTITY_ROLES = ImmutableSet.of((Object)StaticPredefinedRole.ENTITY_ADMIN, (Object)StaticPredefinedRole.ENTITY_CO_ADMIN, (Object)StaticPredefinedRole.ENTITY_HAS_INVITATION, (Object)StaticPredefinedRole.ENTITY_HAS_REJECTED, (Object)StaticPredefinedRole.ENTITY_HAS_SEND_JOINREQUEST, (Object)StaticPredefinedRole.ENTITY_MEMBER, (Object[])new Role[]{StaticPredefinedRole.ENTITY_UNDECIDED, StaticPredefinedRole.ENTITY_VERSION_REVIEWER, StaticPredefinedRole.EVENT_HAS_REJECTED_INVITATION, StaticPredefinedRole.EVENT_IS_ATTENDING, StaticPredefinedRole.EVENT_IS_INVITED, StaticPredefinedRole.EVENT_IS_MAYBE_ATTENDING, StaticPredefinedRole.EVENT_IS_NOT_ATTENDING, StaticPredefinedRole.EVENT_IS_ON_WAITINGLIST, StaticPredefinedRole.ENTITY_ASSIGNEE});
    private static final ImmutableSet<NameAndParam> ENTITY_ROLE_NAMES = (ImmutableSet)ENTITY_ROLES.stream().map(Authority::getNameAndParam).collect(ImmutableSet.toImmutableSet());
    private static final Function<EntityId, BoolExpr> MEMBER_ROLE_FUNCTION = new NullPermeableFunction<EntityId, BoolExpr>(){

        @Override
        protected BoolExpr applySafe(EntityId input) {
            return BoolExpr.var(StaticPredefinedRole.ENTITY_MEMBER.name() + "," + input.getId());
        }
    };
    private static final Function<EntityId, BoolExpr> ADMIN_ROLE_FUNCTION = new NullPermeableFunction<EntityId, BoolExpr>(){

        @Override
        protected BoolExpr applySafe(EntityId input) {
            return BoolExpr.or(BoolExpr.var(StaticPredefinedRole.ENTITY_CO_ADMIN.name() + "," + input.getId()), BoolExpr.var(StaticPredefinedRole.ENTITY_ADMIN.name() + "," + input.getId()));
        }
    };
    private final AuthorizationContextProvider _authorizationContextProvider;
    private final ConfigFileService _configFileService;
    private final EntityChildrenService _entityChildrenService;
    private final EntityService _entityService;

    @Autowired
    public EntityPermissionServiceImpl(AuthorizationContextProvider authorizationContextProvider, ConfigFileService configFileService, EntityChildrenService entityChildrenService, EntityService entityService) {
        this._authorizationContextProvider = authorizationContextProvider;
        this._configFileService = configFileService;
        this._entityChildrenService = entityChildrenService;
        this._entityService = entityService;
    }

    @Nonnull
    private ImmutableSet<NameAndParam> getSupportedVars() {
        return FluentIterable.from(ENTITY_ROLES).append((Object[])new Role[]{StaticPredefinedRole.LOGGED_IN, StaticPredefinedRole.ENTITY_MEMBER_OF_PARENT, StaticPredefinedRole.ENTITY_ADMIN_OF_PARENT, StaticPredefinedRole.WORKSTREAM_MESSAGE_AUTHOR}).append(this._configFileService.getConfigFile().getAllPersonRoles()).transform(Role.TO_NAME).transform(NameAndParam.FROM_STRING_NO_PARAM).toSet();
    }

    @Nonnull
    private Table<EntityId, NameAndParam, BoolExpr> getInheritedMemberSubstitutions(ImmutableMap<ItemIdAndAction, BoolExpr> expressions) {
        ImmutableSetMultimap<EntityId, NameAndParam> usedVariables = EntityPermissionServiceImpl.getUsedVariablesForEntities(expressions);
        NameAndParam entityMemberOfParent = StaticPredefinedRole.ENTITY_MEMBER_OF_PARENT.getNameAndParam();
        NameAndParam entityAdminOfParent = StaticPredefinedRole.ENTITY_ADMIN_OF_PARENT.getNameAndParam();
        ImmutableSet inheritMembers = usedVariables.inverse().get((Object)entityMemberOfParent);
        ImmutableSet inheritAdmins = usedVariables.inverse().get((Object)entityAdminOfParent);
        ImmutableSetMultimap<EntityId, EntityId> memberParents = this._entityChildrenService.getBequeathingEntityParentsByChildIds((Set<EntityId>)inheritMembers, InheritsRole.INHERIT_MEMBERS);
        ImmutableSetMultimap<EntityId, EntityId> adminParents = this._entityChildrenService.getBequeathingEntityParentsByChildIds((Set<EntityId>)inheritAdmins, InheritsRole.INHERIT_ADMINS);
        ImmutableTable.Builder result = ImmutableTable.builder();
        for (EntityId id : usedVariables.keySet()) {
            result.put((Object)id, (Object)entityMemberOfParent, (Object)BoolExpr.or(memberParents.get((Object)id).stream().map(MEMBER_ROLE_FUNCTION).collect(Collectors.toList())));
            result.put((Object)id, (Object)entityAdminOfParent, (Object)BoolExpr.or(adminParents.get((Object)id).stream().map(ADMIN_ROLE_FUNCTION).collect(Collectors.toList())));
        }
        return result.build();
    }

    @Nonnull
    private ImmutableMap<ItemIdAndAction, BoolExpr> loadExpressions(Set<EntityId> entitiyIds) {
        ImmutableSetMultimap actions = Multimaps2.cartesianProduct(entitiyIds, DriveAction.ALL_ACTIONS);
        return this._authorizationContextProvider.getPersonIndependentAuthorizationContext().neededExpressionsForActionsBulked((SetMultimap<? extends ItemId, ? extends Action>)actions);
    }

    @Nonnull
    private static ImmutableSetMultimap<EntityId, NameAndParam> getUsedVariablesForEntities(ImmutableMap<ItemIdAndAction, BoolExpr> exprs) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (Map.Entry e : exprs.entrySet()) {
            ItemId itemId = ((ItemIdAndAction)e.getKey()).getItemId();
            if (!(itemId instanceof EntityId)) continue;
            result.putAll((Object)((EntityId)itemId), ((BoolExpr)e.getValue()).usedVariables());
        }
        return result.build();
    }

    public Function<EntityId, ImmutableMap<DriveAction, BoolExpr>> expressionsForEntityFunction(Set<EntityId> entityIds, Set<DriveAction> driveActions) {
        ImmutableMap<ItemIdAndAction, BoolExpr> toroExpressions = this.loadExpressions(entityIds);
        ImmutableSet<NameAndParam> supportedVars = this.getSupportedVars();
        Table<EntityId, NameAndParam, BoolExpr> inheritedMemberSubstitutions = this.getInheritedMemberSubstitutions(toroExpressions);
        return entityId -> {
            if (entityId == null) {
                return ImmutableMap.of();
            }
            Function translateToDriveExpressionFunction = expr -> {
                if (!supportedVars.contains(expr)) {
                    LOG.warn("Ignoring unsupported roles in Entity privacy settings for Drive: {}", expr);
                    return BoolExpr.FALSE;
                }
                if (ENTITY_ROLE_NAMES.contains(expr)) {
                    return BoolExpr.var(expr.getName() + "," + entityId.getId());
                }
                if (StaticPredefinedRole.LOGGED_IN.getNameAndParam().equals(expr)) {
                    return BoolExpr.TRUE;
                }
                return (BoolExpr)inheritedMemberSubstitutions.get(entityId, expr);
            };
            return (ImmutableMap)driveActions.stream().collect(ImmutableMap.toImmutableMap(a -> a, driveAction -> {
                ItemIdAndAction itemIdAndAction = new ItemIdAndAction((ItemId)entityId, driveAction.getAction());
                BoolExpr toroExpressionForAction = (BoolExpr)toroExpressions.get((Object)itemIdAndAction);
                if (toroExpressionForAction == null) {
                    return BoolExpr.FALSE;
                }
                BoolExpr driveExpression = toroExpressionForAction.substitute((Function<? super NameAndParam, ? extends BoolExpr>)translateToDriveExpressionFunction);
                BoolExpr simplifiedExpression = driveExpression.simplify();
                if (!simplifiedExpression.equals(BoolExpr.TRUE)) {
                    return simplifiedExpression;
                }
                TenantId tenantId = this._entityService.getByIdNotNull((EntityId)entityId).getTenantId();
                return BoolExpr.or(BoolExpr.var(tenantId.asString()), BoolExpr.var("SUPERADMIN"));
            }));
        };
    }
}

