/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.ListMultimap;
import de.justsoftware.onx.album.business.AlbumService;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.components.TeaserModuleHandler;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.ComponentTypeVisitor;
import de.justsoftware.onx.container.business.EntityModuleHandler;
import de.justsoftware.onx.container.business.EntityModuleService;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ModuleData;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.contentbuttons.business.ContentButtonsModuleHandler;
import de.justsoftware.onx.hierarchy.business.HierarchyModuleHandler;
import de.justsoftware.onx.multiwiki.business.MultiWikiService;
import de.justsoftware.onx.raweditor.business.RawEditorModuleHandler;
import de.justsoftware.onx.survey.business.SurveyService;
import de.justsoftware.onx.videolink.business.VideolinkService;
import de.justsoftware.onx.wikieditor.business.WikiEditorService;
import de.justsoftware.onx.workstream.business.WorkstreamService;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityModuleServiceImpl
implements EntityModuleService {
    @Autowired
    private AlbumService _albumService;
    @Autowired
    private TeaserModuleHandler _teaserEntityModuleHandler;
    @Autowired
    private RawEditorModuleHandler _rawEditorEntityModuleHandler;
    @Autowired
    private SurveyService _surveyService;
    @Autowired
    private WorkstreamService _workstreamService;
    @Autowired
    private VideolinkService _videolinkService;
    @Autowired
    private WikiEditorService _wikiEditorService;
    @Autowired
    private MultiWikiService _multiWikiService;
    @Autowired
    private HierarchyModuleHandler _hierarchyService;
    @Autowired
    private ContentButtonsModuleHandler _contentButtonsModuleHandler;
    private final ComponentTypeVisitor<Optional<? extends EntityModuleHandler>> _entityModuleHandlerVisitor = new ComponentTypeVisitor<Optional<? extends EntityModuleHandler>>(){

        @Override
        public Optional<AlbumService> visitAlbum() {
            return Optional.of(EntityModuleServiceImpl.this._albumService);
        }

        @Override
        public Optional<EntityModuleHandler> visitDocument() {
            return Optional.empty();
        }

        @Override
        public Optional<VideolinkService> visitVideolink() {
            return Optional.of(EntityModuleServiceImpl.this._videolinkService);
        }

        @Override
        public Optional<TeaserModuleHandler> visitChildEntities(EntityType entityType) {
            return Optional.of(EntityModuleServiceImpl.this._teaserEntityModuleHandler);
        }

        @Override
        public Optional<? extends EntityModuleHandler> visitWorkstream() {
            return Optional.empty();
        }

        @Override
        public Optional<EntityModuleHandler> visitProfileFriends() {
            return Optional.empty();
        }

        @Override
        public Optional<EntityModuleHandler> visitLogo() {
            return Optional.empty();
        }

        @Override
        public Optional<EntityModuleHandler> visitCalendarSheet() {
            return Optional.empty();
        }

        @Override
        public Optional<EntityModuleHandler> visitRandomMembers() {
            return Optional.empty();
        }

        @Override
        public Optional<EntityModuleHandler> visitAdminList() {
            return Optional.empty();
        }

        @Override
        public Optional<WikiEditorService> visitWikiEditor() {
            return Optional.of(EntityModuleServiceImpl.this._wikiEditorService);
        }

        @Override
        public Optional<EntityModuleHandler> visitInfoWidget() {
            return Optional.empty();
        }

        @Override
        public Optional<SurveyService> visitSurvey() {
            return Optional.of(EntityModuleServiceImpl.this._surveyService);
        }

        @Override
        public Optional<RawEditorModuleHandler> visitRawEditor1() {
            return Optional.of(EntityModuleServiceImpl.this._rawEditorEntityModuleHandler);
        }

        @Override
        public Optional<RawEditorModuleHandler> visitRawEditor2() {
            return Optional.of(EntityModuleServiceImpl.this._rawEditorEntityModuleHandler);
        }

        @Override
        public Optional<RawEditorModuleHandler> visitRawEditor3() {
            return Optional.of(EntityModuleServiceImpl.this._rawEditorEntityModuleHandler);
        }

        @Override
        public Optional<RawEditorModuleHandler> visitRawEditor4() {
            return Optional.of(EntityModuleServiceImpl.this._rawEditorEntityModuleHandler);
        }

        @Override
        public Optional<MultiWikiService> visitMultiWiki() {
            return Optional.of(EntityModuleServiceImpl.this._multiWikiService);
        }

        @Override
        public Optional<HierarchyModuleHandler> visitHierarchy() {
            return Optional.of(EntityModuleServiceImpl.this._hierarchyService);
        }

        @Override
        public Optional<ContentButtonsModuleHandler> visitContentButtons() {
            return Optional.of(EntityModuleServiceImpl.this._contentButtonsModuleHandler);
        }

        @Override
        public Optional<? extends EntityModuleHandler> visitTopNews() {
            return Optional.empty();
        }

        @Override
        public Optional<? extends EntityModuleHandler> visitTempDocument() {
            return Optional.empty();
        }
    };

    @Nonnull
    private Optional<? extends EntityModuleHandler> getHandler(@Nonnull ComponentType t) {
        return t.accept(this._entityModuleHandlerVisitor);
    }

    @Override
    public ModuleData getModule(SearchAuthorizationCheckContext authorizationContext, EntityItem entity, ComponentType componentType) throws InvalidIDException {
        Optional<? extends EntityModuleHandler> handler = this.getHandler(componentType);
        if (handler.isPresent()) {
            return handler.get().getModuleData(authorizationContext, entity, componentType);
        }
        return null;
    }

    @Override
    public void create(ListMultimap<ComponentType, DBEntity> entitiesForComponentTypeMap, ServerEventCollector eventCollector) {
        for (Map.Entry entry : entitiesForComponentTypeMap.asMap().entrySet()) {
            ComponentType type = (ComponentType)entry.getKey();
            Optional<? extends EntityModuleHandler> handler = this.getHandler(type);
            handler.ifPresent(h -> h.create(type, (Iterable)entry.getValue(), eventCollector));
        }
    }
}

