/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.ProfileReadRole;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.SecretEntityMember;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityMembershipInfoService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityMembership;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.PublicEntityMember;
import de.justsoftware.onx.container.shared.model.RoleOrInheritedRole;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EntityMembershipInfoServiceImpl
implements EntityMembershipInfoService {
    private static final Ordering<PersonTeaserModel> PERSON_TEASER_ORDERING = Ordering.from((Comparator)Collator.getInstance(Locale.GERMAN)).onResultOf(PersonTeaserModel.TO_FULL_NAME_LASTNAME_FIRST);
    private final EntityMemberService _entityMemberService;
    private final ProfileTeaserService _profileTeaserService;

    @Autowired
    public EntityMembershipInfoServiceImpl(EntityMemberService entityMemberService, ProfileTeaserService profileTeaserService) {
        this._entityMemberService = entityMemberService;
        this._profileTeaserService = profileTeaserService;
    }

    @Override
    public ImmutableListMultimap<RoleOrInheritedRole, EntityMembership> getAllEntityAdmins(EntityId entityId, AuthorizationCheckContextWithLocale authCtx) {
        authCtx.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_READ_DETAILS);
        ImmutableList<EntityMemberWithPerson> allDirectMembers = this._entityMemberService.getEntityMembersByEntityId(entityId);
        ImmutableSet directAdmins = FluentIterable.from(allDirectMembers).filter(EntityMemberUtil.composeRoleFilterPredicate(EntityMemberRole.ADMIN)).transform(EntityMember.GET_PERSON_ID).toSet();
        ImmutableSet directCoAdmins = FluentIterable.from(allDirectMembers).filter(EntityMemberUtil.composeRoleFilterPredicate(EntityMemberRole.CO_ADMIN)).transform(EntityMember.GET_PERSON_ID).toSet();
        ImmutableSet inheritedCoAdmins = this._entityMemberService.getInheritedMembers(InheritsRole.INHERIT_ADMINS, (Set<EntityId>)ImmutableSet.of((Object)entityId)).get((Object)entityId);
        ImmutableMap<PersonId, PersonTeaserModel> visiblePersonTeasers = this._profileTeaserService.getPersonTeasersByIds((Set<PersonId>)FluentIterable.from(authCtx.filterRoles((ImmutableCollection<ProfileReadRole>)FluentIterable.from((Iterable)directAdmins).append((Iterable)directCoAdmins).append((Iterable)inheritedCoAdmins).transform(ProfileReadRole::of).toSet())).transform(ProfileId.TO_PERSON_ID).toSet(), authCtx);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        ImmutableList sortedTeaserList = FluentIterable.from((Iterable)visiblePersonTeasers.values()).filter(PersonTeaserModel.NOT_DELETED).toSortedList(PERSON_TEASER_ORDERING);
        for (PersonTeaserModel teaser : sortedTeaserList) {
            PublicEntityMember member;
            boolean isAdmin = directAdmins.contains(teaser.getId());
            PublicEntityMember publicEntityMember = member = isAdmin ? new PublicEntityMember(teaser, (ImmutableSet<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.ADMIN)) : new PublicEntityMember(teaser, (ImmutableSet<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.CO_ADMIN));
            if (isAdmin) {
                builder.put((Object)EntityMemberRole.ADMIN, (Object)member);
            }
            if (directCoAdmins.contains(teaser.getId())) {
                builder.put((Object)EntityMemberRole.CO_ADMIN, (Object)member);
            }
            if (!inheritedCoAdmins.contains(teaser.getId())) continue;
            builder.put((Object)InheritsRole.INHERIT_ADMINS, (Object)member);
        }
        Sets.SetView invisibleAdmins = Sets.difference((Set)directAdmins, (Set)visiblePersonTeasers.keySet());
        UnmodifiableIterator it = invisibleAdmins.iterator();
        while (it.hasNext()) {
            builder.put((Object)EntityMemberRole.ADMIN, (Object)SecretEntityMember.INSTANCE);
            it.next();
        }
        Sets.SetView invisibleCoAdmins = Sets.difference((Set)directCoAdmins, (Set)visiblePersonTeasers.keySet());
        UnmodifiableIterator it2 = invisibleCoAdmins.iterator();
        while (it2.hasNext()) {
            builder.put((Object)EntityMemberRole.CO_ADMIN, (Object)SecretEntityMember.INSTANCE);
            it2.next();
        }
        Sets.SetView invisibleInheritedCoAdmins = Sets.difference((Set)inheritedCoAdmins, (Set)visiblePersonTeasers.keySet());
        UnmodifiableIterator it3 = invisibleInheritedCoAdmins.iterator();
        while (it3.hasNext()) {
            builder.put((Object)InheritsRole.INHERIT_ADMINS, (Object)SecretEntityMember.INSTANCE);
            it3.next();
        }
        return builder.build();
    }
}

